package com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class PGExprTableSource extends SQLExprTableSource implements PGSQLObject, PGTableSource {
   protected boolean only;

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.sampling != null) {
            this.sampling.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public PGExprTableSource clone() {
      PGExprTableSource x = new PGExprTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }
}
