package com.alibaba.druid.sql.dialect.presto.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class PrestoStatementParser extends SQLStatementParser {
   public PrestoStatementParser(String sql) {
      super((SQLExprParser)(new PrestoExprParser(sql, new SQLParserFeature[0])));
   }

   public PrestoStatementParser(Lexer lexer) {
      super((SQLExprParser)(new PrestoExprParser(lexer)));
   }

   protected void parseInsertColumns(SQLInsertInto insert) {
      if (this.lexer.token() != Token.RPAREN) {
         while(true) {
            SQLName expr = this.exprParser.name();
            expr.setParent(insert);
            insert.getColumns().add(expr);
            if (this.lexer.token() == Token.IDENTIFIER) {
               String text = this.lexer.stringVal();
               if (!text.equalsIgnoreCase("TINYINT") && !text.equalsIgnoreCase("BIGINT") && !text.equalsIgnoreCase("INTEGER") && !text.equalsIgnoreCase("DOUBLE") && !text.equalsIgnoreCase("DATE") && !text.equalsIgnoreCase("VARCHAR")) {
                  if (text.equalsIgnoreCase("CHAR")) {
                     this.lexer.nextToken();
                     this.accept(Token.LPAREN);
                     SQLExpr char_len = this.exprParser.primary();
                     this.accept(Token.RPAREN);
                     String dataType = text + "(" + char_len.toString() + ")";
                     expr.getAttributes().put("dataType", dataType);
                  }
               } else {
                  expr.getAttributes().put("dataType", text);
                  this.lexer.nextToken();
               }
            }

            if (this.lexer.token() != Token.COMMA) {
               return;
            }

            this.lexer.nextToken();
         }
      }
   }
}
