package com.alibaba.druid.sql.dialect.sqlserver.ast.clause;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLServerOver extends SQLOver implements SQLServerObject {
   protected SQLExpr referenceWindowName;

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.referenceWindowName);
         if (this.partitionBy != null) {
            for(SQLExpr item : this.partitionBy) {
               this.acceptChild(visitor, item);
            }
         }

         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.distributeBy);
         this.acceptChild(visitor, this.sortBy);
         this.acceptChild(visitor, this.of);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getReferenceWindowName() {
      return this.referenceWindowName;
   }

   public void setReferenceWindowName(SQLExpr referenceWindowName) {
      this.referenceWindowName = referenceWindowName;
   }
}
