package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import java.util.List;

public class Least implements Function {
   public static final Least instance = new Least();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      Object result = null;

      for(SQLExpr item : x.getArguments()) {
         item.accept(visitor);
         Object itemValue = item.getAttributes().get("eval.value");
         if (result == null) {
            result = itemValue;
         } else if (SQLEvalVisitorUtils.lt(itemValue, result)) {
            result = itemValue;
         }
      }

      return result;
   }

   public Object eval(SQLMethodInvokeExpr x) {
      List<SQLExpr> arguments = x.getArguments();
      if (arguments.size() > 0) {
         SQLExpr p0 = (SQLExpr)arguments.get(0);
         if (p0 instanceof SQLIntegerExpr && ((SQLIntegerExpr)p0).getNumber() instanceof Integer) {
            int val = ((SQLIntegerExpr)p0).getNumber().intValue();

            for(int i = 1; i < arguments.size(); ++i) {
               SQLExpr param = (SQLExpr)arguments.get(i);
               if (!(param instanceof SQLIntegerExpr) || !(((SQLIntegerExpr)param).getNumber() instanceof Integer)) {
                  return SQLEvalVisitor.EVAL_ERROR;
               }

               int paramVal = ((SQLIntegerExpr)param).getNumber().intValue();
               if (paramVal < val) {
                  val = paramVal;
               }
            }

            return val;
         }
      }

      return SQLEvalVisitor.EVAL_ERROR;
   }
}
