package com.alibaba.druid.util;

import java.util.Arrays;

public final class FnvHash {
   public static final long BASIC = -3750763034362895579L;
   public static final long PRIME = 1099511628211L;

   public static long fnv1a_64(String input) {
      if (input == null) {
         return 0L;
      } else {
         long hash = -3750763034362895579L;

         for(int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            hash ^= (long)c;
            hash *= 1099511628211L;
         }

         return hash;
      }
   }

   public static long fnv1a_64(StringBuilder input) {
      if (input == null) {
         return 0L;
      } else {
         long hash = -3750763034362895579L;

         for(int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            hash ^= (long)c;
            hash *= 1099511628211L;
         }

         return hash;
      }
   }

   public static long fnv1a_64(String input, int offset, int end) {
      if (input == null) {
         return 0L;
      } else {
         if (input.length() < end) {
            end = input.length();
         }

         long hash = -3750763034362895579L;

         for(int i = offset; i < end; ++i) {
            char c = input.charAt(i);
            hash ^= (long)c;
            hash *= 1099511628211L;
         }

         return hash;
      }
   }

   public static long fnv1a_64(byte[] input, int offset, int end) {
      if (input == null) {
         return 0L;
      } else {
         if (input.length < end) {
            end = input.length;
         }

         long hash = -3750763034362895579L;

         for(int i = offset; i < end; ++i) {
            byte c = input[i];
            hash ^= (long)c;
            hash *= 1099511628211L;
         }

         return hash;
      }
   }

   public static long fnv1a_64(char[] chars) {
      if (chars == null) {
         return 0L;
      } else {
         long hash = -3750763034362895579L;

         for(int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            hash ^= (long)c;
            hash *= 1099511628211L;
         }

         return hash;
      }
   }

   public static long hashCode64(String name) {
      if (name == null) {
         return 0L;
      } else {
         boolean quote = false;
         int len = name.length();
         if (len > 2) {
            char c0 = name.charAt(0);
            char c1 = name.charAt(len - 1);
            if (c0 == '`' && c1 == '`' || c0 == '"' && c1 == '"' || c0 == '\'' && c1 == '\'' || c0 == '[' && c1 == ']') {
               quote = true;
            }
         }

         return quote ? hashCode64(name, 1, len - 1) : hashCode64(name, 0, len);
      }
   }

   public static long fnv1a_64_lower(String key) {
      long hashCode = -3750763034362895579L;

      for(int i = 0; i < key.length(); ++i) {
         char ch = key.charAt(i);
         if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
         }

         hashCode ^= (long)ch;
         hashCode *= 1099511628211L;
      }

      return hashCode;
   }

   public static long fnv1a_64_lower(StringBuilder key) {
      long hashCode = -3750763034362895579L;

      for(int i = 0; i < key.length(); ++i) {
         char ch = key.charAt(i);
         if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
         }

         hashCode ^= (long)ch;
         hashCode *= 1099511628211L;
      }

      return hashCode;
   }

   public static long fnv1a_64_lower(long basic, StringBuilder key) {
      long hashCode = basic;

      for(int i = 0; i < key.length(); ++i) {
         char ch = key.charAt(i);
         if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
         }

         hashCode ^= (long)ch;
         hashCode *= 1099511628211L;
      }

      return hashCode;
   }

   public static long hashCode64(String key, int offset, int end) {
      long hashCode = -3750763034362895579L;

      for(int i = offset; i < end; ++i) {
         char ch = key.charAt(i);
         if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
         }

         hashCode ^= (long)ch;
         hashCode *= 1099511628211L;
      }

      return hashCode;
   }

   public static long hashCode64(long basic, String name) {
      if (name == null) {
         return basic;
      } else {
         boolean quote = false;
         int len = name.length();
         if (len > 2) {
            char c0 = name.charAt(0);
            char c1 = name.charAt(len - 1);
            if (c0 == '`' && c1 == '`' || c0 == '"' && c1 == '"' || c0 == '\'' && c1 == '\'' || c0 == '[' && c1 == ']') {
               quote = true;
            }
         }

         if (!quote) {
            return hashCode64(basic, name, 0, len);
         } else {
            int offset = 1;
            int end = len - 1;

            for(int i = end - 1; i >= 0; --i) {
               char ch = name.charAt(i);
               if (ch != ' ') {
                  break;
               }

               --end;
            }

            return hashCode64(basic, name, offset, end);
         }
      }
   }

   public static long hashCode64(long basic, String key, int offset, int end) {
      long hashCode = basic;

      for(int i = offset; i < end; ++i) {
         char ch = key.charAt(i);
         if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
         }

         hashCode ^= (long)ch;
         hashCode *= 1099511628211L;
      }

      return hashCode;
   }

   public static long fnv_32_lower(String key) {
      long hashCode = -2128831035L;

      for(int i = 0; i < key.length(); ++i) {
         char ch = key.charAt(i);
         if (ch != '_' && ch != '-') {
            if (ch >= 'A' && ch <= 'Z') {
               ch = (char)(ch + 32);
            }

            hashCode ^= (long)ch;
            hashCode *= 16777619L;
         }
      }

      return hashCode;
   }

   public static long[] fnv1a_64_lower(String[] strings, boolean sort) {
      long[] hashCodes = new long[strings.length];

      for(int i = 0; i < strings.length; ++i) {
         hashCodes[i] = fnv1a_64_lower(strings[i]);
      }

      if (sort) {
         Arrays.sort(hashCodes);
      }

      return hashCodes;
   }

   public static long hashCode64(String owner, String name) {
      long hashCode = -3750763034362895579L;
      if (owner != null) {
         String item = owner;
         boolean quote = false;
         int len = owner.length();
         if (len > 2) {
            char c0 = owner.charAt(0);
            char c1 = owner.charAt(len - 1);
            if (c0 == '`' && c1 == '`' || c0 == '"' && c1 == '"' || c0 == '\'' && c1 == '\'' || c0 == '[' && c1 == ']') {
               quote = true;
            }
         }

         int start = quote ? 1 : 0;
         int end = quote ? len - 1 : len;

         for(int j = start; j < end; ++j) {
            char ch = item.charAt(j);
            if (ch >= 'A' && ch <= 'Z') {
               ch = (char)(ch + 32);
            }

            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
         }

         hashCode ^= 46L;
         hashCode *= 1099511628211L;
      }

      if (name != null) {
         String item = name;
         boolean quote = false;
         int len = name.length();
         if (len > 2) {
            char c0 = name.charAt(0);
            char c1 = name.charAt(len - 1);
            if (c0 == '`' && c1 == '`' || c0 == '"' && c1 == '"' || c0 == '\'' && c1 == '\'' || c0 == '[' && c1 == ']') {
               quote = true;
            }
         }

         int start = quote ? 1 : 0;
         int end = quote ? len - 1 : len;

         for(int j = start; j < end; ++j) {
            char ch = item.charAt(j);
            if (ch >= 'A' && ch <= 'Z') {
               ch = (char)(ch + 32);
            }

            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
         }
      }

      return hashCode;
   }

   public interface Constants {
      long HIGH_PRIORITY = FnvHash.fnv1a_64_lower("HIGH_PRIORITY");
      long MANAGEDLOCATION = FnvHash.fnv1a_64_lower("MANAGEDLOCATION");
      long DISTINCTROW = FnvHash.fnv1a_64_lower("DISTINCTROW");
      long STRAIGHT = FnvHash.fnv1a_64_lower("STRAIGHT");
      long STRAIGHT_JOIN = FnvHash.fnv1a_64_lower("STRAIGHT_JOIN");
      long SQL_SMALL_RESULT = FnvHash.fnv1a_64_lower("SQL_SMALL_RESULT");
      long SQL_BIG_RESULT = FnvHash.fnv1a_64_lower("SQL_BIG_RESULT");
      long SQL_BUFFER_RESULT = FnvHash.fnv1a_64_lower("SQL_BUFFER_RESULT");
      long CACHE = FnvHash.fnv1a_64_lower("CACHE");
      long SQL_CACHE = FnvHash.fnv1a_64_lower("SQL_CACHE");
      long SQL_NO_CACHE = FnvHash.fnv1a_64_lower("SQL_NO_CACHE");
      long SQL_CALC_FOUND_ROWS = FnvHash.fnv1a_64_lower("SQL_CALC_FOUND_ROWS");
      long TOP = FnvHash.fnv1a_64_lower("TOP");
      long OUTFILE = FnvHash.fnv1a_64_lower("OUTFILE");
      long SETS = FnvHash.fnv1a_64_lower("SETS");
      long REGEXP = FnvHash.fnv1a_64_lower("REGEXP");
      long RLIKE = FnvHash.fnv1a_64_lower("RLIKE");
      long USING = FnvHash.fnv1a_64_lower("USING");
      long IGNORE = FnvHash.fnv1a_64_lower("IGNORE");
      long FORCE = FnvHash.fnv1a_64_lower("FORCE");
      long CROSS = FnvHash.fnv1a_64_lower("CROSS");
      long NATURAL = FnvHash.fnv1a_64_lower("NATURAL");
      long APPLY = FnvHash.fnv1a_64_lower("APPLY");
      long CONNECT = FnvHash.fnv1a_64_lower("CONNECT");
      long START = FnvHash.fnv1a_64_lower("START");
      long BTREE = FnvHash.fnv1a_64_lower("BTREE");
      long HASH = FnvHash.fnv1a_64_lower("HASH");
      long LIST = FnvHash.fnv1a_64_lower("LIST");
      long NO_WAIT = FnvHash.fnv1a_64_lower("NO_WAIT");
      long WAIT = FnvHash.fnv1a_64_lower("WAIT");
      long NOWAIT = FnvHash.fnv1a_64_lower("NOWAIT");
      long ERRORS = FnvHash.fnv1a_64_lower("ERRORS");
      long VALUE = FnvHash.fnv1a_64_lower("VALUE");
      long OBJECT = FnvHash.fnv1a_64_lower("OBJECT");
      long NEXT = FnvHash.fnv1a_64_lower("NEXT");
      long NEXTVAL = FnvHash.fnv1a_64_lower("NEXTVAL");
      long CURRVAL = FnvHash.fnv1a_64_lower("CURRVAL");
      long PREVVAL = FnvHash.fnv1a_64_lower("PREVVAL");
      long PREVIOUS = FnvHash.fnv1a_64_lower("PREVIOUS");
      long LOW_PRIORITY = FnvHash.fnv1a_64_lower("LOW_PRIORITY");
      long COMMIT_ON_SUCCESS = FnvHash.fnv1a_64_lower("COMMIT_ON_SUCCESS");
      long ROLLBACK_ON_FAIL = FnvHash.fnv1a_64_lower("ROLLBACK_ON_FAIL");
      long QUEUE_ON_PK = FnvHash.fnv1a_64_lower("QUEUE_ON_PK");
      long TARGET_AFFECT_ROW = FnvHash.fnv1a_64_lower("TARGET_AFFECT_ROW");
      long COLLATE = FnvHash.fnv1a_64_lower("COLLATE");
      long BOOLEAN = FnvHash.fnv1a_64_lower("BOOLEAN");
      long SMALLINT = FnvHash.fnv1a_64_lower("SMALLINT");
      long SHORT = FnvHash.fnv1a_64_lower("SHORT");
      long TINY = FnvHash.fnv1a_64_lower("TINY");
      long TINYINT = FnvHash.fnv1a_64_lower("TINYINT");
      long CHARSET = FnvHash.fnv1a_64_lower("CHARSET");
      long SEMI = FnvHash.fnv1a_64_lower("SEMI");
      long ANTI = FnvHash.fnv1a_64_lower("ANTI");
      long PRIOR = FnvHash.fnv1a_64_lower("PRIOR");
      long NOCYCLE = FnvHash.fnv1a_64_lower("NOCYCLE");
      long CYCLE = FnvHash.fnv1a_64_lower("CYCLE");
      long CONNECT_BY_ROOT = FnvHash.fnv1a_64_lower("CONNECT_BY_ROOT");
      long DATE = FnvHash.fnv1a_64_lower("DATE");
      long GSON = FnvHash.fnv1a_64_lower("GSON");
      long NEW = FnvHash.fnv1a_64_lower("NEW");
      long NEWDATE = FnvHash.fnv1a_64_lower("NEWDATE");
      long DATETIME = FnvHash.fnv1a_64_lower("DATETIME");
      long TIME = FnvHash.fnv1a_64_lower("TIME");
      long ZONE = FnvHash.fnv1a_64_lower("ZONE");
      long JSON = FnvHash.fnv1a_64_lower("JSON");
      long TIMESTAMP = FnvHash.fnv1a_64_lower("TIMESTAMP");
      long TIMESTAMPTZ = FnvHash.fnv1a_64_lower("TIMESTAMPTZ");
      long CLOB = FnvHash.fnv1a_64_lower("CLOB");
      long NCLOB = FnvHash.fnv1a_64_lower("NCLOB");
      long TINYBLOB = FnvHash.fnv1a_64_lower("TINYBLOB");
      long BLOB = FnvHash.fnv1a_64_lower("BLOB");
      long XMLTYPE = FnvHash.fnv1a_64_lower("XMLTYPE");
      long BFILE = FnvHash.fnv1a_64_lower("BFILE");
      long UROWID = FnvHash.fnv1a_64_lower("UROWID");
      long ROWID = FnvHash.fnv1a_64_lower("ROWID");
      long REF = FnvHash.fnv1a_64_lower("REF");
      long INTEGER = FnvHash.fnv1a_64_lower("INTEGER");
      long INT = FnvHash.fnv1a_64_lower("INT");
      long INT24 = FnvHash.fnv1a_64_lower("INT24");
      long BINARY_FLOAT = FnvHash.fnv1a_64_lower("BINARY_FLOAT");
      long BINARY_DOUBLE = FnvHash.fnv1a_64_lower("BINARY_DOUBLE");
      long FLOAT = FnvHash.fnv1a_64_lower("FLOAT");
      long REAL = FnvHash.fnv1a_64_lower("REAL");
      long NUMBER = FnvHash.fnv1a_64_lower("NUMBER");
      long NUMERIC = FnvHash.fnv1a_64_lower("NUMERIC");
      long DEC = FnvHash.fnv1a_64_lower("DEC");
      long DECIMAL = FnvHash.fnv1a_64_lower("DECIMAL");
      long CURRENT = FnvHash.fnv1a_64_lower("CURRENT");
      long COUNT = FnvHash.fnv1a_64_lower("COUNT");
      long ROW_NUMBER = FnvHash.fnv1a_64_lower("ROW_NUMBER");
      long FIRST_VALUE = FnvHash.fnv1a_64_lower("FIRST_VALUE");
      long LAST_VALUE = FnvHash.fnv1a_64_lower("LAST_VALUE");
      long WM_CONCAT = FnvHash.fnv1a_64_lower("WM_CONCAT");
      long AVG = FnvHash.fnv1a_64_lower("AVG");
      long MAX = FnvHash.fnv1a_64_lower("MAX");
      long MIN = FnvHash.fnv1a_64_lower("MIN");
      long STDDEV = FnvHash.fnv1a_64_lower("STDDEV");
      long RANK = FnvHash.fnv1a_64_lower("RANK");
      long SUM = FnvHash.fnv1a_64_lower("SUM");
      long ARBITRARY = FnvHash.fnv1a_64_lower("ARBITRARY");
      long GROUP_CONCAT = FnvHash.fnv1a_64_lower("GROUP_CONCAT");
      long CONVERT_TZ = FnvHash.fnv1a_64_lower("CONVERT_TZ");
      long DEDUPLICATION = FnvHash.fnv1a_64_lower("DEDUPLICATION");
      long CONVERT = FnvHash.fnv1a_64_lower("CONVERT");
      long CHAR = FnvHash.fnv1a_64_lower("CHAR");
      long ENUM = FnvHash.fnv1a_64_lower("ENUM");
      long STRING = FnvHash.fnv1a_64_lower("STRING");
      long VARCHAR = FnvHash.fnv1a_64_lower("VARCHAR");
      long VARCHAR2 = FnvHash.fnv1a_64_lower("VARCHAR2");
      long NCHAR = FnvHash.fnv1a_64_lower("NCHAR");
      long NVARCHAR = FnvHash.fnv1a_64_lower("NVARCHAR");
      long NVARCHAR2 = FnvHash.fnv1a_64_lower("NVARCHAR2");
      long NCHAR_VARYING = FnvHash.fnv1a_64_lower("nchar varying");
      long VARBINARY = FnvHash.fnv1a_64_lower("VARBINARY");
      long TINYTEXT = FnvHash.fnv1a_64_lower("TINYTEXT");
      long TEXT = FnvHash.fnv1a_64_lower("TEXT");
      long MEDIUMTEXT = FnvHash.fnv1a_64_lower("MEDIUMTEXT");
      long LONGTEXT = FnvHash.fnv1a_64_lower("LONGTEXT");
      long TRIM = FnvHash.fnv1a_64_lower("TRIM");
      long LEADING = FnvHash.fnv1a_64_lower("LEADING");
      long BOTH = FnvHash.fnv1a_64_lower("BOTH");
      long TRAILING = FnvHash.fnv1a_64_lower("TRAILING");
      long MOD = FnvHash.fnv1a_64_lower("MOD");
      long MATCH = FnvHash.fnv1a_64_lower("MATCH");
      long AGAINST = FnvHash.fnv1a_64_lower("AGAINST");
      long EXTRACT = FnvHash.fnv1a_64_lower("EXTRACT");
      long POLYGON = FnvHash.fnv1a_64_lower("POLYGON");
      long CIRCLE = FnvHash.fnv1a_64_lower("CIRCLE");
      long LSEG = FnvHash.fnv1a_64_lower("LSEG");
      long POINT = FnvHash.fnv1a_64_lower("POINT");
      long BOX = FnvHash.fnv1a_64_lower("BOX");
      long MACADDR = FnvHash.fnv1a_64_lower("MACADDR");
      long INET = FnvHash.fnv1a_64_lower("INET");
      long CIDR = FnvHash.fnv1a_64_lower("CIDR");
      long POSITION = FnvHash.fnv1a_64_lower("POSITION");
      long DUAL = FnvHash.fnv1a_64_lower("DUAL");
      long LEVEL = FnvHash.fnv1a_64_lower("LEVEL");
      long CONNECT_BY_ISCYCLE = FnvHash.fnv1a_64_lower("CONNECT_BY_ISCYCLE");
      long CURRENT_TIMESTAMP = FnvHash.fnv1a_64_lower("CURRENT_TIMESTAMP");
      long LOCALTIMESTAMP = FnvHash.fnv1a_64_lower("LOCALTIMESTAMP");
      long LOCALTIME = FnvHash.fnv1a_64_lower("LOCALTIME");
      long SESSIONTIMEZONE = FnvHash.fnv1a_64_lower("SESSIONTIMEZONE");
      long DBTIMEZONE = FnvHash.fnv1a_64_lower("DBTIMEZONE");
      long CURRENT_DATE = FnvHash.fnv1a_64_lower("CURRENT_DATE");
      long CURRENT_TIME = FnvHash.fnv1a_64_lower("CURRENT_TIME");
      long CURTIME = FnvHash.fnv1a_64_lower("CURTIME");
      long CURRENT_USER = FnvHash.fnv1a_64_lower("CURRENT_USER");
      long FALSE = FnvHash.fnv1a_64_lower("FALSE");
      long TRUE = FnvHash.fnv1a_64_lower("TRUE");
      long LESS = FnvHash.fnv1a_64_lower("LESS");
      long MAXVALUE = FnvHash.fnv1a_64_lower("MAXVALUE");
      long OFFSET = FnvHash.fnv1a_64_lower("OFFSET");
      long LIMIT = FnvHash.fnv1a_64_lower("LIMIT");
      long RAW = FnvHash.fnv1a_64_lower("RAW");
      long LONG_RAW = FnvHash.fnv1a_64_lower("LONG RAW");
      long LONG = FnvHash.fnv1a_64_lower("LONG");
      long BYTE = FnvHash.fnv1a_64_lower("BYTE");
      long ROWNUM = FnvHash.fnv1a_64_lower("ROWNUM");
      long SYSDATE = FnvHash.fnv1a_64_lower("SYSDATE");
      long NOW = FnvHash.fnv1a_64_lower("NOW");
      long ADDTIME = FnvHash.fnv1a_64_lower("ADDTIME");
      long SUBTIME = FnvHash.fnv1a_64_lower("SUBTIME");
      long TIMEDIFF = FnvHash.fnv1a_64_lower("TIMEDIFF");
      long SQLCODE = FnvHash.fnv1a_64_lower("SQLCODE");
      long PRECISION = FnvHash.fnv1a_64_lower("PRECISION");
      long DOUBLE = FnvHash.fnv1a_64_lower("DOUBLE");
      long DOUBLE_PRECISION = FnvHash.fnv1a_64_lower("DOUBLE PRECISION");
      long WITHOUT = FnvHash.fnv1a_64_lower("WITHOUT");
      long BITAND = FnvHash.fnv1a_64_lower("BITAND");
      long DEFINER = FnvHash.fnv1a_64_lower("DEFINER");
      long EVENT = FnvHash.fnv1a_64_lower("EVENT");
      long RESOURCE = FnvHash.fnv1a_64_lower("RESOURCE");
      long RESOURCES = FnvHash.fnv1a_64_lower("RESOURCES");
      long FILE = FnvHash.fnv1a_64_lower("FILE");
      long JAR = FnvHash.fnv1a_64_lower("JAR");
      long PY = FnvHash.fnv1a_64_lower("PY");
      long ARCHIVE = FnvHash.fnv1a_64_lower("archive");
      long DETERMINISTIC = FnvHash.fnv1a_64_lower("DETERMINISTIC");
      long CONTAINS = FnvHash.fnv1a_64_lower("CONTAINS");
      long SQL = FnvHash.fnv1a_64_lower("SQL");
      long CALL = FnvHash.fnv1a_64_lower("CALL");
      long CHARACTER = FnvHash.fnv1a_64_lower("CHARACTER");
      long UNNEST = FnvHash.fnv1a_64_lower("UNNEST");
      long VALIDATE = FnvHash.fnv1a_64_lower("VALIDATE");
      long NOVALIDATE = FnvHash.fnv1a_64_lower("NOVALIDATE");
      long SIMILAR = FnvHash.fnv1a_64_lower("SIMILAR");
      long CASCADE = FnvHash.fnv1a_64_lower("CASCADE");
      long RELY = FnvHash.fnv1a_64_lower("RELY");
      long NORELY = FnvHash.fnv1a_64_lower("NORELY");
      long ROW = FnvHash.fnv1a_64_lower("ROW");
      long ROWS = FnvHash.fnv1a_64_lower("ROWS");
      long RANGE = FnvHash.fnv1a_64_lower("RANGE");
      long PRECEDING = FnvHash.fnv1a_64_lower("PRECEDING");
      long FOLLOWING = FnvHash.fnv1a_64_lower("FOLLOWING");
      long UNBOUNDED = FnvHash.fnv1a_64_lower("UNBOUNDED");
      long SIBLINGS = FnvHash.fnv1a_64_lower("SIBLINGS");
      long RESPECT = FnvHash.fnv1a_64_lower("RESPECT");
      long NULLS = FnvHash.fnv1a_64_lower("NULLS");
      long FIRST = FnvHash.fnv1a_64_lower("FIRST");
      long LAST = FnvHash.fnv1a_64_lower("LAST");
      long AUTO_INCREMENT = FnvHash.fnv1a_64_lower("AUTO_INCREMENT");
      long STORAGE = FnvHash.fnv1a_64_lower("STORAGE");
      long STORED = FnvHash.fnv1a_64_lower("STORED");
      long VIRTUAL = FnvHash.fnv1a_64_lower("VIRTUAL");
      long SIGNED = FnvHash.fnv1a_64_lower("SIGNED");
      long UNSIGNED = FnvHash.fnv1a_64_lower("UNSIGNED");
      long ZEROFILL = FnvHash.fnv1a_64_lower("ZEROFILL");
      long GLOBAL = FnvHash.fnv1a_64_lower("GLOBAL");
      long LOCAL = FnvHash.fnv1a_64_lower("LOCAL");
      long TEMPORARY = FnvHash.fnv1a_64_lower("TEMPORARY");
      long NONCLUSTERED = FnvHash.fnv1a_64_lower("NONCLUSTERED");
      long SESSION = FnvHash.fnv1a_64_lower("SESSION");
      long NAMES = FnvHash.fnv1a_64_lower("NAMES");
      long XML = FnvHash.fnv1a_64_lower("XML");
      long PARTIAL = FnvHash.fnv1a_64_lower("PARTIAL");
      long SIMPLE = FnvHash.fnv1a_64_lower("SIMPLE");
      long RESTRICT = FnvHash.fnv1a_64_lower("RESTRICT");
      long ON = FnvHash.fnv1a_64_lower("ON");
      long ACTION = FnvHash.fnv1a_64_lower("ACTION");
      long SEPARATOR = FnvHash.fnv1a_64_lower("SEPARATOR");
      long DATA = FnvHash.fnv1a_64_lower("DATA");
      long MIGRATE = FnvHash.fnv1a_64_lower("MIGRATE");
      long MAX_ROWS = FnvHash.fnv1a_64_lower("MAX_ROWS");
      long MIN_ROWS = FnvHash.fnv1a_64_lower("MIN_ROWS");
      long PACK_KEYS = FnvHash.fnv1a_64_lower("PACK_KEYS");
      long ENGINE = FnvHash.fnv1a_64_lower("ENGINE");
      long SKIP = FnvHash.fnv1a_64_lower("SKIP");
      long RECURSIVE = FnvHash.fnv1a_64_lower("RECURSIVE");
      long ROLLUP = FnvHash.fnv1a_64_lower("ROLLUP");
      long CUBE = FnvHash.fnv1a_64_lower("CUBE");
      long YEAR = FnvHash.fnv1a_64_lower("YEAR");
      long QUARTER = FnvHash.fnv1a_64_lower("QUARTER");
      long MONTH = FnvHash.fnv1a_64_lower("MONTH");
      long WEEK = FnvHash.fnv1a_64_lower("WEEK");
      long WEEKS = FnvHash.fnv1a_64_lower("WEEKS");
      long WEEKDAY = FnvHash.fnv1a_64_lower("WEEKDAY");
      long WEEKOFYEAR = FnvHash.fnv1a_64_lower("WEEKOFYEAR");
      long YEARWEEK = FnvHash.fnv1a_64_lower("YEARWEEK");
      long YEAR_OF_WEEK = FnvHash.fnv1a_64_lower("YEAR_OF_WEEK");
      long YOW = FnvHash.fnv1a_64_lower("YOW");
      long YEARMONTH = FnvHash.fnv1a_64_lower("YEARMONTH");
      long TO_TIMESTAMP = FnvHash.fnv1a_64_lower("TO_TIMESTAMP");
      long DAY = FnvHash.fnv1a_64_lower("DAY");
      long DAYOFMONTH = FnvHash.fnv1a_64_lower("DAYOFMONTH");
      long DAYOFWEEK = FnvHash.fnv1a_64_lower("DAYOFWEEK");
      long DATE_TRUNC = FnvHash.fnv1a_64_lower("DATE_TRUNC");
      long DAYOFYEAR = FnvHash.fnv1a_64_lower("DAYOFYEAR");
      long MONTH_BETWEEN = FnvHash.fnv1a_64_lower("MONTH_BETWEEN");
      long TIMESTAMPADD = FnvHash.fnv1a_64_lower("TIMESTAMPADD");
      long HOUR = FnvHash.fnv1a_64_lower("HOUR");
      long MINUTE = FnvHash.fnv1a_64_lower("MINUTE");
      long SECOND = FnvHash.fnv1a_64_lower("SECOND");
      long MILLISECOND = FnvHash.fnv1a_64_lower("MILLISECOND");
      long MICROSECOND = FnvHash.fnv1a_64_lower("MICROSECOND");
      long CURDATE = FnvHash.fnv1a_64_lower("CURDATE");
      long CUR_DATE = FnvHash.fnv1a_64_lower("CUR_DATE");
      long DATE_DIFF = FnvHash.fnv1a_64_lower("DATE_DIFF");
      long MICROSECONDS = FnvHash.fnv1a_64_lower("MICROSECONDS");
      long MILLISECONDS = FnvHash.fnv1a_64_lower("MILLISECONDS");
      long SECONDS = FnvHash.fnv1a_64_lower("SECONDS");
      long MINUTES = FnvHash.fnv1a_64_lower("MINUTES");
      long HOURS = FnvHash.fnv1a_64_lower("HOURS");
      long DAYS = FnvHash.fnv1a_64_lower("DAYS");
      long MONTHS = FnvHash.fnv1a_64_lower("MONTHS");
      long YEARS = FnvHash.fnv1a_64_lower("YEARS");
      long BEFORE = FnvHash.fnv1a_64_lower("BEFORE");
      long AFTER = FnvHash.fnv1a_64_lower("AFTER");
      long INSTEAD = FnvHash.fnv1a_64_lower("INSTEAD");
      long DEFERRABLE = FnvHash.fnv1a_64_lower("DEFERRABLE");
      long AS = FnvHash.fnv1a_64_lower("AS");
      long DELAYED = FnvHash.fnv1a_64_lower("DELAYED");
      long GO = FnvHash.fnv1a_64_lower("GO");
      long WAITFOR = FnvHash.fnv1a_64_lower("WAITFOR");
      long EXEC = FnvHash.fnv1a_64_lower("EXEC");
      long EXECUTE = FnvHash.fnv1a_64_lower("EXECUTE");
      long SOURCE = FnvHash.fnv1a_64_lower("SOURCE");
      long STAR = FnvHash.fnv1a_64_lower("*");
      long TO_CHAR = FnvHash.fnv1a_64_lower("TO_CHAR");
      long UNIX_TIMESTAMP = FnvHash.fnv1a_64_lower("UNIX_TIMESTAMP");
      long FROM_UNIXTIME = FnvHash.fnv1a_64_lower("FROM_UNIXTIME");
      long TO_UNIXTIME = FnvHash.fnv1a_64_lower("TO_UNIXTIME");
      long SYS_GUID = FnvHash.fnv1a_64_lower("SYS_GUID");
      long LAST_DAY = FnvHash.fnv1a_64_lower("LAST_DAY");
      long MAKEDATE = FnvHash.fnv1a_64_lower("MAKEDATE");
      long ASCII = FnvHash.fnv1a_64_lower("ASCII");
      long DAYNAME = FnvHash.fnv1a_64_lower("DAYNAME");
      long STATISTICS = FnvHash.fnv1a_64_lower("STATISTICS");
      long TRANSACTION = FnvHash.fnv1a_64_lower("TRANSACTION");
      long OFF = FnvHash.fnv1a_64_lower("OFF");
      long IDENTITY_INSERT = FnvHash.fnv1a_64_lower("IDENTITY_INSERT");
      long PASSWORD = FnvHash.fnv1a_64_lower("PASSWORD");
      long SOCKET = FnvHash.fnv1a_64_lower("SOCKET");
      long OWNER = FnvHash.fnv1a_64_lower("OWNER");
      long PORT = FnvHash.fnv1a_64_lower("PORT");
      long PUBLIC = FnvHash.fnv1a_64_lower("PUBLIC");
      long SYNONYM = FnvHash.fnv1a_64_lower("SYNONYM");
      long MATERIALIZED = FnvHash.fnv1a_64_lower("MATERIALIZED");
      long BITMAP = FnvHash.fnv1a_64_lower("BITMAP");
      long LABEL = FnvHash.fnv1a_64_lower("LABEL");
      long PACKAGE = FnvHash.fnv1a_64_lower("PACKAGE");
      long PACKAGES = FnvHash.fnv1a_64_lower("PACKAGES");
      long TRUNC = FnvHash.fnv1a_64_lower("TRUNC");
      long SYSTIMESTAMP = FnvHash.fnv1a_64_lower("SYSTIMESTAMP");
      long TYPE = FnvHash.fnv1a_64_lower("TYPE");
      long RECORD = FnvHash.fnv1a_64_lower("RECORD");
      long MAP = FnvHash.fnv1a_64_lower("MAP");
      long MAPJOIN = FnvHash.fnv1a_64_lower("MAPJOIN");
      long MAPPED = FnvHash.fnv1a_64_lower("MAPPED");
      long MAPPING = FnvHash.fnv1a_64_lower("MAPPING");
      long COLPROPERTIES = FnvHash.fnv1a_64_lower("COLPROPERTIES");
      long ONLY = FnvHash.fnv1a_64_lower("ONLY");
      long MEMBER = FnvHash.fnv1a_64_lower("MEMBER");
      long STATIC = FnvHash.fnv1a_64_lower("STATIC");
      long FINAL = FnvHash.fnv1a_64_lower("FINAL");
      long INSTANTIABLE = FnvHash.fnv1a_64_lower("INSTANTIABLE");
      long UNSUPPORTED = FnvHash.fnv1a_64_lower("UNSUPPORTED");
      long VARRAY = FnvHash.fnv1a_64_lower("VARRAY");
      long WRAPPED = FnvHash.fnv1a_64_lower("WRAPPED");
      long AUTHID = FnvHash.fnv1a_64_lower("AUTHID");
      long UNDER = FnvHash.fnv1a_64_lower("UNDER");
      long USERENV = FnvHash.fnv1a_64_lower("USERENV");
      long NUMTODSINTERVAL = FnvHash.fnv1a_64_lower("NUMTODSINTERVAL");
      long LATERAL = FnvHash.fnv1a_64_lower("LATERAL");
      long NONE = FnvHash.fnv1a_64_lower("NONE");
      long PARTITIONING = FnvHash.fnv1a_64_lower("PARTITIONING");
      long VALIDPROC = FnvHash.fnv1a_64_lower("VALIDPROC");
      long COMPRESS = FnvHash.fnv1a_64_lower("COMPRESS");
      long YES = FnvHash.fnv1a_64_lower("YES");
      long WMSYS = FnvHash.fnv1a_64_lower("WMSYS");
      long DEPTH = FnvHash.fnv1a_64_lower("DEPTH");
      long BREADTH = FnvHash.fnv1a_64_lower("BREADTH");
      long SCHEDULE = FnvHash.fnv1a_64_lower("SCHEDULE");
      long COMPLETION = FnvHash.fnv1a_64_lower("COMPLETION");
      long RENAME = FnvHash.fnv1a_64_lower("RENAME");
      long AT = FnvHash.fnv1a_64_lower("AT");
      long LANGUAGE = FnvHash.fnv1a_64_lower("LANGUAGE");
      long LOGFILE = FnvHash.fnv1a_64_lower("LOGFILE");
      long LOG = FnvHash.fnv1a_64_lower("LOG");
      long INITIAL_SIZE = FnvHash.fnv1a_64_lower("INITIAL_SIZE");
      long MAX_SIZE = FnvHash.fnv1a_64_lower("MAX_SIZE");
      long NODEGROUP = FnvHash.fnv1a_64_lower("NODEGROUP");
      long EXTENT_SIZE = FnvHash.fnv1a_64_lower("EXTENT_SIZE");
      long AUTOEXTEND_SIZE = FnvHash.fnv1a_64_lower("AUTOEXTEND_SIZE");
      long FILE_BLOCK_SIZE = FnvHash.fnv1a_64_lower("FILE_BLOCK_SIZE");
      long BLOCK_SIZE = FnvHash.fnv1a_64_lower("BLOCK_SIZE");
      long REPLICA_NUM = FnvHash.fnv1a_64_lower("REPLICA_NUM");
      long TABLET_SIZE = FnvHash.fnv1a_64_lower("TABLET_SIZE");
      long PCTFREE = FnvHash.fnv1a_64_lower("PCTFREE");
      long USE_BLOOM_FILTER = FnvHash.fnv1a_64_lower("USE_BLOOM_FILTER");
      long SERVER = FnvHash.fnv1a_64_lower("SERVER");
      long HOST = FnvHash.fnv1a_64_lower("HOST");
      long ADD = FnvHash.fnv1a_64_lower("ADD");
      long REMOVE = FnvHash.fnv1a_64_lower("REMOVE");
      long MOVE = FnvHash.fnv1a_64_lower("MOVE");
      long ALGORITHM = FnvHash.fnv1a_64_lower("ALGORITHM");
      long LINEAR = FnvHash.fnv1a_64_lower("LINEAR");
      long EVERY = FnvHash.fnv1a_64_lower("EVERY");
      long STARTS = FnvHash.fnv1a_64_lower("STARTS");
      long ENDS = FnvHash.fnv1a_64_lower("ENDS");
      long BINARY = FnvHash.fnv1a_64_lower("BINARY");
      long GEOMETRY = FnvHash.fnv1a_64_lower("GEOMETRY");
      long ISOPEN = FnvHash.fnv1a_64_lower("ISOPEN");
      long CONFLICT = FnvHash.fnv1a_64_lower("CONFLICT");
      long NOTHING = FnvHash.fnv1a_64_lower("NOTHING");
      long COMMIT = FnvHash.fnv1a_64_lower("COMMIT");
      long DESCRIBE = FnvHash.fnv1a_64_lower("DESCRIBE");
      long SQLXML = FnvHash.fnv1a_64_lower("SQLXML");
      long BIT = FnvHash.fnv1a_64_lower("BIT");
      long LONGBLOB = FnvHash.fnv1a_64_lower("LONGBLOB");
      long RS = FnvHash.fnv1a_64_lower("RS");
      long RR = FnvHash.fnv1a_64_lower("RR");
      long CS = FnvHash.fnv1a_64_lower("CS");
      long UR = FnvHash.fnv1a_64_lower("UR");
      long INT4 = FnvHash.fnv1a_64_lower("INT4");
      long VARBIT = FnvHash.fnv1a_64_lower("VARBIT");
      long DECODE = FnvHash.fnv1a_64_lower("DECODE");
      long IF = FnvHash.fnv1a_64_lower("IF");
      long EXTERNAL = FnvHash.fnv1a_64_lower("EXTERNAL");
      long SORTED = FnvHash.fnv1a_64_lower("SORTED");
      long CLUSTERED = FnvHash.fnv1a_64_lower("CLUSTERED");
      long LIFECYCLE = FnvHash.fnv1a_64_lower("LIFECYCLE");
      long LOCATION = FnvHash.fnv1a_64_lower("LOCATION");
      long PARTITIONS = FnvHash.fnv1a_64_lower("PARTITIONS");
      long FORMAT = FnvHash.fnv1a_64_lower("FORMAT");
      long ENCODE = FnvHash.fnv1a_64_lower("ENCODE");
      long SELECT = FnvHash.fnv1a_64_lower("SELECT");
      long DELETE = FnvHash.fnv1a_64_lower("DELETE");
      long UPDATE = FnvHash.fnv1a_64_lower("UPDATE");
      long INSERT = FnvHash.fnv1a_64_lower("INSERT");
      long REPLACE = FnvHash.fnv1a_64_lower("REPLACE");
      long TRUNCATE = FnvHash.fnv1a_64_lower("TRUNCATE");
      long CREATE = FnvHash.fnv1a_64_lower("CREATE");
      long MERGE = FnvHash.fnv1a_64_lower("MERGE");
      long SHOW = FnvHash.fnv1a_64_lower("SHOW");
      long ALTER = FnvHash.fnv1a_64_lower("ALTER");
      long DESC = FnvHash.fnv1a_64_lower("DESC");
      long SET = FnvHash.fnv1a_64_lower("SET");
      long KILL = FnvHash.fnv1a_64_lower("KILL");
      long MSCK = FnvHash.fnv1a_64_lower("MSCK");
      long USE = FnvHash.fnv1a_64_lower("USE");
      long ROLLBACK = FnvHash.fnv1a_64_lower("ROLLBACK");
      long GRANT = FnvHash.fnv1a_64_lower("GRANT");
      long REVOKE = FnvHash.fnv1a_64_lower("REVOKE");
      long DROP = FnvHash.fnv1a_64_lower("DROP");
      long USER = FnvHash.fnv1a_64_lower("USER");
      long USAGE = FnvHash.fnv1a_64_lower("USAGE");
      long PCTUSED = FnvHash.fnv1a_64_lower("PCTUSED");
      long OPAQUE = FnvHash.fnv1a_64_lower("OPAQUE");
      long INHERITS = FnvHash.fnv1a_64_lower("INHERITS");
      long DELIMITED = FnvHash.fnv1a_64_lower("DELIMITED");
      long ARRAY = FnvHash.fnv1a_64_lower("ARRAY");
      long SCALAR = FnvHash.fnv1a_64_lower("SCALAR");
      long STRUCT = FnvHash.fnv1a_64_lower("STRUCT");
      long UNIONTYPE = FnvHash.fnv1a_64_lower("UNIONTYPE");
      long TDDL = FnvHash.fnv1a_64_lower("TDDL");
      long CONCURRENTLY = FnvHash.fnv1a_64_lower("CONCURRENTLY");
      long TABLES = FnvHash.fnv1a_64_lower("TABLES");
      long NOCACHE = FnvHash.fnv1a_64_lower("NOCACHE");
      long NOPARALLEL = FnvHash.fnv1a_64_lower("NOPARALLEL");
      long EXIST = FnvHash.fnv1a_64_lower("EXIST");
      long EXISTS = FnvHash.fnv1a_64_lower("EXISTS");
      long SOUNDS = FnvHash.fnv1a_64_lower("SOUNDS");
      long TBLPROPERTIES = FnvHash.fnv1a_64_lower("TBLPROPERTIES");
      long TABLEGROUP = FnvHash.fnv1a_64_lower("TABLEGROUP");
      long TABLEGROUPS = FnvHash.fnv1a_64_lower("TABLEGROUPS");
      long DIMENSION = FnvHash.fnv1a_64_lower("DIMENSION");
      long OPTIONS = FnvHash.fnv1a_64_lower("OPTIONS");
      long OPTIMIZER = FnvHash.fnv1a_64_lower("OPTIMIZER");
      long FULLTEXT = FnvHash.fnv1a_64_lower("FULLTEXT");
      long SPATIAL = FnvHash.fnv1a_64_lower("SPATIAL");
      long SUBPARTITION_AVAILABLE_PARTITION_NUM = FnvHash.fnv1a_64_lower("SUBPARTITION_AVAILABLE_PARTITION_NUM");
      long EXTRA = FnvHash.fnv1a_64_lower("EXTRA");
      long DATABASES = FnvHash.fnv1a_64_lower("DATABASES");
      long COLUMNS = FnvHash.fnv1a_64_lower("COLUMNS");
      long PROCESS = FnvHash.fnv1a_64_lower("PROCESS");
      long PROCESSLIST = FnvHash.fnv1a_64_lower("PROCESSLIST");
      long MPP = FnvHash.fnv1a_64_lower("MPP");
      long SERDE = FnvHash.fnv1a_64_lower("SERDE");
      long SORT = FnvHash.fnv1a_64_lower("SORT");
      long FIELDS = FnvHash.fnv1a_64_lower("FIELDS");
      long COLLECTION = FnvHash.fnv1a_64_lower("COLLECTION");
      long SKEWED = FnvHash.fnv1a_64_lower("SKEWED");
      long SYMBOL = FnvHash.fnv1a_64_lower("SYMBOL");
      long LOAD = FnvHash.fnv1a_64_lower("LOAD");
      long VIEWS = FnvHash.fnv1a_64_lower("VIEWS");
      long SUBSTR = FnvHash.fnv1a_64_lower("SUBSTR");
      long TO_BASE64 = FnvHash.fnv1a_64_lower("TO_BASE64");
      long REGEXP_SUBSTR = FnvHash.fnv1a_64_lower("REGEXP_SUBSTR");
      long REGEXP_COUNT = FnvHash.fnv1a_64_lower("REGEXP_COUNT");
      long REGEXP_EXTRACT = FnvHash.fnv1a_64_lower("REGEXP_EXTRACT");
      long REGEXP_EXTRACT_ALL = FnvHash.fnv1a_64_lower("REGEXP_EXTRACT_ALL");
      long REGEXP_LIKE = FnvHash.fnv1a_64_lower("REGEXP_LIKE");
      long REGEXP_REPLACE = FnvHash.fnv1a_64_lower("REGEXP_REPLACE");
      long REGEXP_SPLIT = FnvHash.fnv1a_64_lower("REGEXP_SPLIT");
      long CONCAT = FnvHash.fnv1a_64_lower("CONCAT");
      long LCASE = FnvHash.fnv1a_64_lower("LCASE");
      long UCASE = FnvHash.fnv1a_64_lower("UCASE");
      long LOWER = FnvHash.fnv1a_64_lower("LOWER");
      long UPPER = FnvHash.fnv1a_64_lower("UPPER");
      long LENGTH = FnvHash.fnv1a_64_lower("LENGTH");
      long LOCATE = FnvHash.fnv1a_64_lower("LOCATE");
      long UDF_SYS_ROWCOUNT = FnvHash.fnv1a_64_lower("UDF_SYS_ROWCOUNT");
      long CHAR_LENGTH = FnvHash.fnv1a_64_lower("CHAR_LENGTH");
      long CHARACTER_LENGTH = FnvHash.fnv1a_64_lower("CHARACTER_LENGTH");
      long SUBSTRING = FnvHash.fnv1a_64_lower("SUBSTRING");
      long SUBSTRING_INDEX = FnvHash.fnv1a_64_lower("SUBSTRING_INDEX");
      long LEFT = FnvHash.fnv1a_64_lower("LEFT");
      long RIGHT = FnvHash.fnv1a_64_lower("RIGHT");
      long RTRIM = FnvHash.fnv1a_64_lower("RTRIM");
      long LEN = FnvHash.fnv1a_64_lower("LEN");
      long GREAST = FnvHash.fnv1a_64_lower("GREAST");
      long LEAST = FnvHash.fnv1a_64_lower("LEAST");
      long IFNULL = FnvHash.fnv1a_64_lower("IFNULL");
      long NULLIF = FnvHash.fnv1a_64_lower("NULLIF");
      long GREATEST = FnvHash.fnv1a_64_lower("GREATEST");
      long COALESCE = FnvHash.fnv1a_64_lower("COALESCE");
      long ISNULL = FnvHash.fnv1a_64_lower("ISNULL");
      long NVL = FnvHash.fnv1a_64_lower("NVL");
      long NVL2 = FnvHash.fnv1a_64_lower("NVL2");
      long TO_DATE = FnvHash.fnv1a_64_lower("TO_DATE");
      long DATEADD = FnvHash.fnv1a_64_lower("DATEADD");
      long DATE_ADD = FnvHash.fnv1a_64_lower("DATE_ADD");
      long ADDDATE = FnvHash.fnv1a_64_lower("ADDDATE");
      long DATE_SUB = FnvHash.fnv1a_64_lower("DATE_SUB");
      long SUBDATE = FnvHash.fnv1a_64_lower("SUBDATE");
      long DATE_PARSE = FnvHash.fnv1a_64_lower("DATE_PARSE");
      long STR_TO_DATE = FnvHash.fnv1a_64_lower("STR_TO_DATE");
      long CLOTHES_FEATURE_EXTRACT_V1 = FnvHash.fnv1a_64_lower("CLOTHES_FEATURE_EXTRACT_V1");
      long CLOTHES_ATTRIBUTE_EXTRACT_V1 = FnvHash.fnv1a_64_lower("CLOTHES_ATTRIBUTE_EXTRACT_V1");
      long GENERIC_FEATURE_EXTRACT_V1 = FnvHash.fnv1a_64_lower("GENERIC_FEATURE_EXTRACT_V1");
      long FACE_FEATURE_EXTRACT_V1 = FnvHash.fnv1a_64_lower("FACE_FEATURE_EXTRACT_V1");
      long TEXT_FEATURE_EXTRACT_V1 = FnvHash.fnv1a_64_lower("TEXT_FEATURE_EXTRACT_V1");
      long JSON_TABLE = FnvHash.fnv1a_64_lower("JSON_TABLE");
      long JSON_EXTRACT = FnvHash.fnv1a_64_lower("JSON_EXTRACT");
      long JSON_EXTRACT_SCALAR = FnvHash.fnv1a_64_lower("json_extract_scalar");
      long JSON_ARRAY_GET = FnvHash.fnv1a_64_lower("JSON_ARRAY_GET");
      long ADD_MONTHS = FnvHash.fnv1a_64_lower("ADD_MONTHS");
      long ABS = FnvHash.fnv1a_64_lower("ABS");
      long ACOS = FnvHash.fnv1a_64_lower("ACOS");
      long ASIN = FnvHash.fnv1a_64_lower("ASIN");
      long ATAN = FnvHash.fnv1a_64_lower("ATAN");
      long ATAN2 = FnvHash.fnv1a_64_lower("ATAN2");
      long COS = FnvHash.fnv1a_64_lower("COS");
      long FLOOR = FnvHash.fnv1a_64_lower("FLOOR");
      long CEIL = FnvHash.fnv1a_64_lower("CEIL");
      long SQRT = FnvHash.fnv1a_64_lower("SQRT");
      long LEAD = FnvHash.fnv1a_64_lower("LEAD");
      long LAG = FnvHash.fnv1a_64_lower("LAG");
      long CEILING = FnvHash.fnv1a_64_lower("CEILING");
      long POWER = FnvHash.fnv1a_64_lower("POWER");
      long EXP = FnvHash.fnv1a_64_lower("EXP");
      long LN = FnvHash.fnv1a_64_lower("LN");
      long LOG10 = FnvHash.fnv1a_64_lower("LOG10");
      long INTERVAL = FnvHash.fnv1a_64_lower("INTERVAL");
      long FROM_DAYS = FnvHash.fnv1a_64_lower("FROM_DAYS");
      long TO_DAYS = FnvHash.fnv1a_64_lower("TO_DAYS");
      long BIGINT = FnvHash.fnv1a_64_lower("BIGINT");
      long LONGLONG = FnvHash.fnv1a_64_lower("LONGLONG");
      long DISCARD = FnvHash.fnv1a_64_lower("DISCARD");
      long EXCHANGE = FnvHash.fnv1a_64_lower("EXCHANGE");
      long ROLE = FnvHash.fnv1a_64_lower("ROLE");
      long OVERWRITE = FnvHash.fnv1a_64_lower("OVERWRITE");
      long NO = FnvHash.fnv1a_64_lower("NO");
      long CATALOG = FnvHash.fnv1a_64_lower("CATALOG");
      long CATALOGS = FnvHash.fnv1a_64_lower("CATALOGS");
      long FUNCTIONS = FnvHash.fnv1a_64_lower("FUNCTIONS");
      long SCHEMAS = FnvHash.fnv1a_64_lower("SCHEMAS");
      long CHANGE = FnvHash.fnv1a_64_lower("CHANGE");
      long MODIFY = FnvHash.fnv1a_64_lower("MODIFY");
      long BEGIN = FnvHash.fnv1a_64_lower("BEGIN");
      long PATH = FnvHash.fnv1a_64_lower("PATH");
      long ENCRYPTION = FnvHash.fnv1a_64_lower("ENCRYPTION");
      long COMPRESSION = FnvHash.fnv1a_64_lower("COMPRESSION");
      long KEY_BLOCK_SIZE = FnvHash.fnv1a_64_lower("KEY_BLOCK_SIZE");
      long CHECKSUM = FnvHash.fnv1a_64_lower("CHECKSUM");
      long CONNECTION = FnvHash.fnv1a_64_lower("CONNECTION");
      long DATASOURCES = FnvHash.fnv1a_64_lower("DATASOURCES");
      long NODE = FnvHash.fnv1a_64_lower("NODE");
      long HELP = FnvHash.fnv1a_64_lower("HELP");
      long BROADCASTS = FnvHash.fnv1a_64_lower("BROADCASTS");
      long MASTER = FnvHash.fnv1a_64_lower("MASTER");
      long SLAVE = FnvHash.fnv1a_64_lower("SLAVE");
      long SQL_DELAY_CUTOFF = FnvHash.fnv1a_64_lower("SQL_DELAY_CUTOFF");
      long SOCKET_TIMEOUT = FnvHash.fnv1a_64_lower("SOCKET_TIMEOUT");
      long FORBID_EXECUTE_DML_ALL = FnvHash.fnv1a_64_lower("FORBID_EXECUTE_DML_ALL");
      long SCAN = FnvHash.fnv1a_64_lower("SCAN");
      long GET = FnvHash.fnv1a_64_lower("GET");
      long PUT = FnvHash.fnv1a_64_lower("PUT");
      long NOLOGFILE = FnvHash.fnv1a_64_lower("NOLOGFILE");
      long NOBADFILE = FnvHash.fnv1a_64_lower("NOBADFILE");
      long TERMINATED = FnvHash.fnv1a_64_lower("TERMINATED");
      long LTRIM = FnvHash.fnv1a_64_lower("LTRIM");
      long MISSING = FnvHash.fnv1a_64_lower("MISSING");
      long SUBPARTITION = FnvHash.fnv1a_64_lower("SUBPARTITION");
      long SUBPARTITIONS = FnvHash.fnv1a_64_lower("SUBPARTITIONS");
      long GENERATED = FnvHash.fnv1a_64_lower("GENERATED");
      long ALWAYS = FnvHash.fnv1a_64_lower("ALWAYS");
      long VISIBLE = FnvHash.fnv1a_64_lower("VISIBLE");
      long INVISIBLE = FnvHash.fnv1a_64_lower("INVISIBLE");
      long INCLUDING = FnvHash.fnv1a_64_lower("INCLUDING");
      long EXCLUDING = FnvHash.fnv1a_64_lower("EXCLUDING");
      long ROUTINE = FnvHash.fnv1a_64_lower("ROUTINE");
      long IDENTIFIED = FnvHash.fnv1a_64_lower("IDENTIFIED");
      long DELIMITER = FnvHash.fnv1a_64_lower("DELIMITER");
      long UNKNOWN = FnvHash.fnv1a_64_lower("UNKNOWN");
      long WEIGHT_STRING = FnvHash.fnv1a_64_lower("WEIGHT_STRING");
      long REVERSE = FnvHash.fnv1a_64_lower("REVERSE");
      long DATE_FORMAT = FnvHash.fnv1a_64_lower("DATE_FORMAT");
      long DAY_OF_WEEK = FnvHash.fnv1a_64_lower("DAY_OF_WEEK");
      long DATEDIFF = FnvHash.fnv1a_64_lower("DATEDIFF");
      long GET_FORMAT = FnvHash.fnv1a_64_lower("GET_FORMAT");
      long TIMESTAMPDIFF = FnvHash.fnv1a_64_lower("TIMESTAMPDIFF");
      long MONTHNAME = FnvHash.fnv1a_64_lower("MONTHNAME");
      long PERIOD_ADD = FnvHash.fnv1a_64_lower("PERIOD_ADD");
      long PERIOD_DIFF = FnvHash.fnv1a_64_lower("PERIOD_DIFF");
      long ROUND = FnvHash.fnv1a_64_lower("ROUND");
      long DBPARTITION = FnvHash.fnv1a_64_lower("DBPARTITION");
      long TBPARTITION = FnvHash.fnv1a_64_lower("TBPARTITION");
      long EXTPARTITION = FnvHash.fnv1a_64_lower("EXTPARTITION");
      long STARTWITH = FnvHash.fnv1a_64_lower("STARTWITH");
      long TBPARTITIONS = FnvHash.fnv1a_64_lower("TBPARTITIONS");
      long DBPARTITIONS = FnvHash.fnv1a_64_lower("DBPARTITIONS");
      long PARTITIONED = FnvHash.fnv1a_64_lower("PARTITIONED");
      long PARALLEL = FnvHash.fnv1a_64_lower("PARALLEL");
      long ALLOW = FnvHash.fnv1a_64_lower("ALLOW");
      long DISALLOW = FnvHash.fnv1a_64_lower("DISALLOW");
      long PIVOT = FnvHash.fnv1a_64_lower("PIVOT");
      long MODEL = FnvHash.fnv1a_64_lower("MODEL");
      long KEEP = FnvHash.fnv1a_64_lower("KEEP");
      long REFERENCE = FnvHash.fnv1a_64_lower("REFERENCE");
      long RETURN = FnvHash.fnv1a_64_lower("RETURN");
      long RETURNS = FnvHash.fnv1a_64_lower("RETURNS");
      long ROWTYPE = FnvHash.fnv1a_64_lower("ROWTYPE");
      long WINDOW = FnvHash.fnv1a_64_lower("WINDOW");
      long MULTIVALUE = FnvHash.fnv1a_64_lower("MULTIVALUE");
      long OPTIONALLY = FnvHash.fnv1a_64_lower("OPTIONALLY");
      long ENCLOSED = FnvHash.fnv1a_64_lower("ENCLOSED");
      long ESCAPED = FnvHash.fnv1a_64_lower("ESCAPED");
      long ESCAPE = FnvHash.fnv1a_64_lower("ESCAPE");
      long LINES = FnvHash.fnv1a_64_lower("LINES");
      long STARTING = FnvHash.fnv1a_64_lower("STARTING");
      long DISTRIBUTE = FnvHash.fnv1a_64_lower("DISTRIBUTE");
      long DISTRIBUTED = FnvHash.fnv1a_64_lower("DISTRIBUTED");
      long CLUSTER = FnvHash.fnv1a_64_lower("CLUSTER");
      long RUNNING = FnvHash.fnv1a_64_lower("RUNNING");
      long CLUSTERING = FnvHash.fnv1a_64_lower("CLUSTERING");
      long PCTVERSION = FnvHash.fnv1a_64_lower("PCTVERSION");
      long IDENTITY = FnvHash.fnv1a_64_lower("IDENTITY");
      long INCREMENT = FnvHash.fnv1a_64_lower("INCREMENT");
      long MINVALUE = FnvHash.fnv1a_64_lower("MINVALUE");
      long ANN = FnvHash.fnv1a_64_lower("ANN");
      long ANN_DISTANCE = FnvHash.fnv1a_64_lower("ANN_DISTANCE");
      long SUPPLEMENTAL = FnvHash.fnv1a_64_lower("SUPPLEMENTAL");
      long SUBSTITUTABLE = FnvHash.fnv1a_64_lower("SUBSTITUTABLE");
      long BASICFILE = FnvHash.fnv1a_64_lower("BASICFILE");
      long IN_MEMORY_METADATA = FnvHash.fnv1a_64_lower("IN_MEMORY_METADATA");
      long CURSOR_SPECIFIC_SEGMENT = FnvHash.fnv1a_64_lower("CURSOR_SPECIFIC_SEGMENT");
      long DEFER = FnvHash.fnv1a_64_lower("DEFER");
      long UNDO_LOG_LIMIT = FnvHash.fnv1a_64_lower("UNDO_LOG_LIMIT");
      long DBPROPERTIES = FnvHash.fnv1a_64_lower("DBPROPERTIES");
      long ANNINDEX = FnvHash.fnv1a_64_lower("ANNINDEX");
      long RTTYPE = FnvHash.fnv1a_64_lower("RTTYPE");
      long DISTANCE = FnvHash.fnv1a_64_lower("DISTANCE");
      long IDXPROPERTIES = FnvHash.fnv1a_64_lower("IDXPROPERTIES");
      long RECOVER = FnvHash.fnv1a_64_lower("RECOVER");
      long BACKUP = FnvHash.fnv1a_64_lower("BACKUP");
      long RESTORE = FnvHash.fnv1a_64_lower("RESTORE");
      long NOSCAN = FnvHash.fnv1a_64_lower("NOSCAN");
      long EXTENDED = FnvHash.fnv1a_64_lower("EXTENDED");
      long FORMATTED = FnvHash.fnv1a_64_lower("FORMATTED");
      long DEPENDENCY = FnvHash.fnv1a_64_lower("DEPENDENCY");
      long AUTHORIZATION = FnvHash.fnv1a_64_lower("AUTHORIZATION");
      long ANALYZE = FnvHash.fnv1a_64_lower("ANALYZE");
      long EXPORT = FnvHash.fnv1a_64_lower("EXPORT");
      long IMPORT = FnvHash.fnv1a_64_lower("IMPORT");
      long TABLESAMPLE = FnvHash.fnv1a_64_lower("TABLESAMPLE");
      long BUCKET = FnvHash.fnv1a_64_lower("BUCKET");
      long BUCKETS = FnvHash.fnv1a_64_lower("BUCKETS");
      long UNARCHIVE = FnvHash.fnv1a_64_lower("UNARCHIVE");
      long SEQUENCES = FnvHash.fnv1a_64_lower("SEQUENCES");
      long OUTLINE = FnvHash.fnv1a_64_lower("OUTLINE");
      long ORD = FnvHash.fnv1a_64_lower("ORD");
      long SPACE = FnvHash.fnv1a_64_lower("SPACE");
      long REPEAT = FnvHash.fnv1a_64_lower("REPEAT");
      long SLOW = FnvHash.fnv1a_64_lower("SLOW");
      long PLAN = FnvHash.fnv1a_64_lower("PLAN");
      long PLANCACHE = FnvHash.fnv1a_64_lower("PLANCACHE");
      long RECYCLEBIN = FnvHash.fnv1a_64_lower("RECYCLEBIN");
      long PURGE = FnvHash.fnv1a_64_lower("PURGE");
      long FLASHBACK = FnvHash.fnv1a_64_lower("FLASHBACK");
      long INPUTFORMAT = FnvHash.fnv1a_64_lower("INPUTFORMAT");
      long OUTPUTFORMAT = FnvHash.fnv1a_64_lower("OUTPUTFORMAT");
      long DUMP = FnvHash.fnv1a_64_lower("DUMP");
      long BROADCAST = FnvHash.fnv1a_64_lower("BROADCAST");
      long GROUP = FnvHash.fnv1a_64_lower("GROUP");
      long GROUPING = FnvHash.fnv1a_64_lower("GROUPING");
      long GROUPS = FnvHash.fnv1a_64_lower("GROUPS");
      long EXCLUDE = FnvHash.fnv1a_64_lower("EXCLUDE");
      long TIES = FnvHash.fnv1a_64_lower("TIES");
      long WITH = FnvHash.fnv1a_64_lower("WITH");
      long WHO = FnvHash.fnv1a_64_lower("WHO");
      long GRANTS = FnvHash.fnv1a_64_lower("GRANTS");
      long STATISTIC = FnvHash.fnv1a_64_lower("STATISTIC");
      long STATISTIC_LIST = FnvHash.fnv1a_64_lower("STATISTIC_LIST");
      long STATUS = FnvHash.fnv1a_64_lower("STATUS");
      long FULL = FnvHash.fnv1a_64_lower("FULL");
      long STATS = FnvHash.fnv1a_64_lower("STATS");
      long OUTLINES = FnvHash.fnv1a_64_lower("OUTLINES");
      long VERSION = FnvHash.fnv1a_64_lower("VERSION");
      long CONFIG = FnvHash.fnv1a_64_lower("CONFIG");
      long USERS = FnvHash.fnv1a_64_lower("USERS");
      long PHYSICAL_PROCESSLIST = FnvHash.fnv1a_64_lower("PHYSICAL_PROCESSLIST");
      long PHYSICAL = FnvHash.fnv1a_64_lower("PHYSICAL");
      long DISTANCEMEASURE = FnvHash.fnv1a_64_lower("DISTANCEMEASURE");
      long UNIT = FnvHash.fnv1a_64_lower("UNIT");
      long DB = FnvHash.fnv1a_64_lower("DB");
      long STEP = FnvHash.fnv1a_64_lower("STEP");
      long HEX = FnvHash.fnv1a_64_lower("HEX");
      long UNHEX = FnvHash.fnv1a_64_lower("UNHEX");
      long POLICY = FnvHash.fnv1a_64_lower("POLICY");
      long QUERY_TASK = FnvHash.fnv1a_64_lower("QUERY_TASK");
      long UUID = FnvHash.fnv1a_64_lower("UUID");
      long PCTTHRESHOLD = FnvHash.fnv1a_64_lower("PCTTHRESHOLD");
      long UNUSABLE = FnvHash.fnv1a_64_lower("UNUSABLE");
      long FILTER = FnvHash.fnv1a_64_lower("FILTER");
      long BIT_COUNT = FnvHash.fnv1a_64_lower("BIT_COUNT");
      long STDDEV_SAMP = FnvHash.fnv1a_64_lower("STDDEV_SAMP");
      long PERCENT_RANK = FnvHash.fnv1a_64_lower("PERCENT_RANK");
      long DENSE_RANK = FnvHash.fnv1a_64_lower("DENSE_RANK");
      long CUME_DIST = FnvHash.fnv1a_64_lower("CUME_DIST");
      long CARDINALITY = FnvHash.fnv1a_64_lower("CARDINALITY");
      long TRY_CAST = FnvHash.fnv1a_64_lower("TRY_CAST");
      long COVERING = FnvHash.fnv1a_64_lower("COVERING");
      long CHARFILTER = FnvHash.fnv1a_64_lower("CHARFILTER");
      long CHARFILTERS = FnvHash.fnv1a_64_lower("CHARFILTERS");
      long TOKENIZER = FnvHash.fnv1a_64_lower("TOKENIZER");
      long TOKENIZERS = FnvHash.fnv1a_64_lower("TOKENIZERS");
      long TOKENFILTER = FnvHash.fnv1a_64_lower("TOKENFILTER");
      long TOKENFILTERS = FnvHash.fnv1a_64_lower("TOKENFILTERS");
      long ANALYZER = FnvHash.fnv1a_64_lower("ANALYZER");
      long ANALYZERS = FnvHash.fnv1a_64_lower("ANALYZERS");
      long DICTIONARY = FnvHash.fnv1a_64_lower("DICTIONARY");
      long DICTIONARIES = FnvHash.fnv1a_64_lower("DICTIONARIES");
      long QUERY = FnvHash.fnv1a_64_lower("QUERY");
      long META = FnvHash.fnv1a_64_lower("META");
      long TRY = FnvHash.fnv1a_64_lower("TRY");
      long D = FnvHash.fnv1a_64_lower("D");
      long T = FnvHash.fnv1a_64_lower("T");
      long TS = FnvHash.fnv1a_64_lower("TS");
      long FN = FnvHash.fnv1a_64_lower("FN");
      long COPY = FnvHash.fnv1a_64_lower("COPY");
      long CREDENTIALS = FnvHash.fnv1a_64_lower("CREDENTIALS");
      long ACCESS_KEY_ID = FnvHash.fnv1a_64_lower("ACCESS_KEY_ID");
      long ACCESS_KEY_SECRET = FnvHash.fnv1a_64_lower("ACCESS_KEY_SECRET");
      long BERNOULLI = FnvHash.fnv1a_64_lower("BERNOULLI");
      long SYSTEM = FnvHash.fnv1a_64_lower("SYSTEM");
      long SYNC = FnvHash.fnv1a_64_lower("SYNC");
      long INIT = FnvHash.fnv1a_64_lower("INIT");
      long BD = FnvHash.fnv1a_64_lower("BD");
      long FORMAT_DATETIME = FnvHash.fnv1a_64_lower("FORMAT_DATETIME");
      long WITHIN = FnvHash.fnv1a_64_lower("WITHIN");
      long RULE = FnvHash.fnv1a_64_lower("RULE");
      long EXPLAIN = FnvHash.fnv1a_64_lower("EXPLAIN");
      long ISOLATION = FnvHash.fnv1a_64_lower("ISOLATION");
      long READ = FnvHash.fnv1a_64_lower("READ");
      long READS = FnvHash.fnv1a_64_lower("READS");
      long MODIFIES = FnvHash.fnv1a_64_lower("MODIFIES");
      long UNCOMMITTED = FnvHash.fnv1a_64_lower("UNCOMMITTED");
      long COMMITTED = FnvHash.fnv1a_64_lower("COMMITTED");
      long REPEATABLE = FnvHash.fnv1a_64_lower("REPEATABLE");
      long SERIALIZABLE = FnvHash.fnv1a_64_lower("SERIALIZABLE");
      long _LATIN1 = FnvHash.fnv1a_64_lower("_LATIN1");
      long _GBK = FnvHash.fnv1a_64_lower("_GBK");
      long _BIG5 = FnvHash.fnv1a_64_lower("_BIG5");
      long _UTF8 = FnvHash.fnv1a_64_lower("_UTF8");
      long _UTF8MB4 = FnvHash.fnv1a_64_lower("_UTF8MB4");
      long _UTF16 = FnvHash.fnv1a_64_lower("_UTF16");
      long _UTF16LE = FnvHash.fnv1a_64_lower("_UTF16LE");
      long _UTF32 = FnvHash.fnv1a_64_lower("_UTF32");
      long _UCS2 = FnvHash.fnv1a_64_lower("_UCS2");
      long _UJIS = FnvHash.fnv1a_64_lower("_UJIS");
      long X = FnvHash.fnv1a_64_lower("X");
      long TRANSFORM = FnvHash.fnv1a_64_lower("TRANSFORM");
      long NESTED = FnvHash.fnv1a_64_lower("NESTED");
      long RESTART = FnvHash.fnv1a_64_lower("RESTART");
      long ASOF = FnvHash.fnv1a_64_lower("ASOF");
      long JSON_SET = FnvHash.fnv1a_64_lower("JSON_SET");
      long JSONB_SET = FnvHash.fnv1a_64_lower("JSONB_SET");
      long TUNNEL = FnvHash.fnv1a_64_lower("TUNNEL");
      long DOWNLOAD = FnvHash.fnv1a_64_lower("DOWNLOAD");
      long UPLOAD = FnvHash.fnv1a_64_lower("UPLOAD");
      long CURRENT_SCHEMA = FnvHash.fnv1a_64_lower("CURRENT_SCHEMA");
   }
}
