package com.palacesun.engine.gateway.netty.framework;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;

public class HttpServer {
   int port;

   public HttpServer(int port) {
      this.port = port;
   }

   public void start() throws Exception {
      ServerBootstrap bootstrap = new ServerBootstrap();
      EventLoopGroup boss = new NioEventLoopGroup();
      EventLoopGroup work = new NioEventLoopGroup();
      ((ServerBootstrap)((ServerBootstrap)bootstrap.group(boss, work).handler(new LoggingHandler(LogLevel.DEBUG))).channel(NioServerSocketChannel.class)).childHandler(new HttpInitializer());
      ChannelFuture f = bootstrap.bind(new InetSocketAddress(this.port)).sync();
      System.out.println(" server start up on port : " + this.port);
      f.channel().closeFuture().sync();
   }

   public static void main(String[] args) {
      HttpServer s = new HttpServer(9001);

      try {
         s.start();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
