package com.palacesun.engine.spy.option;

import com.palacesun.engine.common.P6Util;
import com.palacesun.engine.spy.P6ModuleManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

public class SpyDotProperties implements P6OptionsSource {
   public static final String OPTIONS_FILE_PROPERTY = "spy.properties";
   public static final String OPTIONS_FILE_CHARSET_PROPERTY = "spy.properties".concat(".charset");
   public static final String DEFAULT_OPTIONS_FILE = "spy.properties";
   private final long lastModified;
   private SpyDotPropertiesReloader reloader;
   private final Map<String, String> options;

   public SpyDotProperties() throws IOException {
      URL url = this.locate();
      if (null == url) {
         this.lastModified = -1L;
         this.options = null;
      } else {
         this.lastModified = this.lastModified();
         InputStream in = null;

         try {
            in = url.openStream();
            Properties properties = new Properties();
            String charsetName = System.getProperty(OPTIONS_FILE_CHARSET_PROPERTY, Charset.defaultCharset().name());
            properties.load(new InputStreamReader(in, charsetName));
            this.options = P6Util.getPropertiesMap(properties);
         } finally {
            if (null != in) {
               try {
                  in.close();
               } catch (Exception var10) {
               }
            }

         }

      }
   }

   public boolean isModified() {
      return this.lastModified() != this.lastModified;
   }

   private long lastModified() {
      long lastMod = -1L;
      URLConnection con = null;
      URL url = this.locate();
      if (url != null) {
         try {
            con = url.openConnection();
            lastMod = con.getLastModified();
         } catch (IOException var20) {
         } finally {
            if (con != null) {
               InputStream in = null;

               try {
                  in = con.getInputStream();
               } catch (IOException var19) {
               }

               if (in != null) {
                  try {
                     in.close();
                  } catch (IOException var18) {
                  }
               }
            }

         }
      }

      return lastMod;
   }

   private URL locate() {
      String propsFileName = System.getProperty("spy.properties", "spy.properties");
      if (null == propsFileName || propsFileName.isEmpty()) {
         propsFileName = "spy.properties";
      }

      return P6Util.locateFile(propsFileName);
   }

   public Map<String, String> getOptions() {
      return this.options;
   }

   public void preDestroy(P6ModuleManager p6moduleManager) {
      if (this.reloader != null) {
         this.reloader.kill(p6moduleManager);
      }

   }

   public void postInit(P6ModuleManager p6moduleManager) {
      this.reloader = new SpyDotPropertiesReloader(this, p6moduleManager);
   }
}
