package com.palacesun.masking.appuser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CachedBodyHttpServletRequest extends HttpServletRequestWrapper {
   private final String body;

   public CachedBodyHttpServletRequest(HttpServletRequest request) {
      super(request);
      StringBuilder stringBuilder = new StringBuilder();
      BufferedReader bufferedReader = null;
      ServletInputStream inputStream = null;

      try {
         inputStream = request.getInputStream();
         if (inputStream != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] charBuffer = new char[128];
            int bytesRead = -1;

            while((bytesRead = bufferedReader.read(charBuffer)) > 0) {
               stringBuilder.append(charBuffer, 0, bytesRead);
            }
         } else {
            stringBuilder.append("");
         }
      } catch (IOException var19) {
      } finally {
         if (inputStream != null) {
            try {
               inputStream.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

         if (bufferedReader != null) {
            try {
               bufferedReader.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

      }

      this.body = stringBuilder.toString();
   }

   public ServletInputStream getInputStream() throws IOException {
      final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
      ServletInputStream servletInputStream = new ServletInputStream() {
         public int read() throws IOException {
            return byteArrayInputStream.read();
         }
      };
      return servletInputStream;
   }

   public BufferedReader getReader() throws IOException {
      return new BufferedReader(new InputStreamReader(this.getInputStream()));
   }

   public String getBody() {
      return this.body;
   }
}
