package com.palacesun.masking.log.access;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLog {
   private String id = "";
   private String user;
   private String[] tables;
   private String url;
   private String sql;
   private String rawSql;
   private String executeSql;
   private String accessTime;
   private String createTime;

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String getUser() {
      return this.user;
   }

   public void setUser(String user) {
      this.user = user;
   }

   public String[] getTables() {
      return this.tables;
   }

   public void setTables(String[] tables) {
      this.tables = tables;
   }

   public String getUrl() {
      return this.url;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public String getRawSql() {
      return this.rawSql;
   }

   public void setRawSql(String rawSql) {
      this.rawSql = rawSql;
   }

   public String getExecuteSql() {
      return this.executeSql;
   }

   public void setExecuteSql(String executeSql) {
      this.executeSql = executeSql;
   }

   public String getAccessTime() {
      return this.accessTime;
   }

   public void setAccessTime(String accessTime) {
      Date date = new Date();

      try {
         date = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(accessTime);
      } catch (ParseException var4) {
      }

      this.accessTime = date.toString();
   }

   public String getCreateTime() {
      return this.createTime;
   }

   public void setCreateTime(String createTime) {
      Date date = new Date();

      try {
         date = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(createTime);
      } catch (ParseException var4) {
      }

      this.createTime = date.toString();
   }

   public String getSql() {
      return this.sql;
   }

   public void setSql(String sql) {
      this.sql = sql;
   }
}
