package util.log;

import java.io.IOException;

public class SQLLogger {
   private static boolean enabled = false;

   public static boolean isEnabled() {
      return enabled;
   }

   public static void setEnabled(boolean enabled) {
      SQLLogger.enabled = enabled;
   }

   public static void log(LogInfo log) {
      if (enabled) {
         LogContext.instance().log(log);
      }
   }

   public static void log(String sql) {
      if (enabled) {
         LogInfo info = new LogInfo();
         info.setSql(sql);
         log(info);
      }
   }

   public static void log(String sql, String message) {
      if (enabled) {
         LogInfo info = new LogInfo();
         info.setSql(sql);
         info.setMessage(message);
         log(info);
      }
   }

   public static void main(String[] args) throws IOException {
      for(int i = 0; i < 10; ++i) {
         log("select * from dual;");
         log("select * from dual;", "ok");
      }

      System.in.read();
   }
}
