package util.sqlparse.visitor.es.memo;

import util.sqlparse.visitor.common.Objects;
import util.sqlparse.visitor.common.scope.Scope;

public class FieldMemo extends Reference {
   public String alias;
   public boolean isSelectItem = false;
   public IndexMemo index;
   public Scope scope;
   public boolean complex;
   public boolean atom;
   public boolean isConstant;
   public FieldMemo refField;
   public MappingMemo mapping;
   public String dataType;

   public String getQualifiedName() {
      return this.index.name + "." + this.name;
   }

   public String getUniqueName() {
      return this.scope.id + ":" + this.getQualifiedName();
   }

   public FieldMemo copy() {
      FieldMemo field = new FieldMemo();
      field.name = this.name;
      field.alias = this.name;
      field.isSelectItem = this.isSelectItem;
      field.ref = null;
      field.scope = null;
      return field;
   }

   public int hashCode() {
      int result = this.ref == null ? 0 : this.ref.hashCode();
      result = 31 * result + this.name.hashCode();
      if (this.index != null) {
         result = 31 * result + this.index.hashCode();
      }

      if (this.mapping != null) {
         result = 31 * result + this.mapping.hashCode();
      }

      return result;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         FieldMemo fieldMemo = (FieldMemo)o;
         if ((this.ref != null || fieldMemo.ref == null) && (fieldMemo.ref != null || this.ref == null)) {
            if ((this.index != null || fieldMemo.index == null) && (fieldMemo.index != null || this.index == null)) {
               if (this.index != null && !this.index.equals(fieldMemo.index)) {
                  return false;
               } else if ((this.mapping != null || fieldMemo.mapping == null) && (fieldMemo.mapping != null || this.mapping == null)) {
                  if (this.mapping != null && !this.mapping.equals(fieldMemo.mapping)) {
                     return false;
                  } else {
                     return this.ref != null && !this.ref.equals(fieldMemo.ref) ? false : Objects.equals(this.name, fieldMemo.name);
                  }
               } else {
                  return false;
               }
            } else {
               return false;
            }
         } else {
            return false;
         }
      } else {
         return false;
      }
   }

   public String flatFullName() {
      StringBuilder s = new StringBuilder();
      if (this.index != null) {
         s.append(this.index.name);
         s.append(".");
      }

      if (this.mapping != null) {
         s.append(this.mapping.name);
         s.append(".");
      }

      s.append(this.name);
      return s.toString();
   }

   public String tableName() {
      StringBuilder s = new StringBuilder();
      if (this.mapping != null) {
         s.append(this.mapping.name);
         s.append(".");
      }

      s.append(this.name);
      return s.toString();
   }
}
