package util.sqlparse.visitor.sqlserver.visitor;

import java.util.List;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class SQLServerScopeDialector extends ScopeDialector {
   public SQLServerScopeDialector() {
   }

   public SQLServerScopeDialector(Scope scope) {
      super(scope);
   }

   public boolean expandAllColumns(TableMemo table, boolean isSub, List<FieldMemo> fields) {
      return true;
   }

   public ScopeDialector clone(Scope scope) {
      return new SQLServerScopeDialector(scope);
   }

   public String wrap(String text) {
      if (text == null) {
         return null;
      } else {
         if (text.startsWith("[") && text.endsWith("]")) {
            text = text.substring(1);
            text = text.substring(0, text.length() - 1);
         }

         if (text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1);
            text = text.substring(0, text.length() - 1);
         }

         return text.toLowerCase();
      }
   }

   public boolean isEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else if (name1 == null && name2 == null) {
         return true;
      } else {
         name1 = name1.replaceAll("\\[\\]", "");
         if (name1.startsWith("\"") && name1.endsWith("\"")) {
            name1 = name1.substring(1);
            name1 = name1.substring(0, name1.length() - 1);
         }

         name2 = name2.replaceAll("\\[\\]", "");
         if (name2.startsWith("\"") && name2.endsWith("\"")) {
            name2 = name2.substring(1);
            name2 = name2.substring(0, name2.length() - 1);
         }

         return name1.equalsIgnoreCase(name2);
      }
   }
}
