package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SQLInListExpr extends SQLExprImpl implements SQLReplaceable, Serializable {
   private static final long serialVersionUID = 1L;
   private boolean not = false;
   private SQLExpr expr;
   private List<SQLExpr> targetList = new ArrayList();
   protected SQLCommentHint hint;

   public SQLInListExpr() {
   }

   public SQLInListExpr(SQLExpr expr) {
      this.setExpr(expr);
   }

   public SQLInListExpr(String expr, String... values) {
      this.setExpr(SQLUtils.toSQLExpr(expr));

      for(String value : values) {
         this.targetList.add(new SQLCharExpr(value));
      }

   }

   public SQLInListExpr(SQLExpr expr, boolean not) {
      this.setExpr(expr);
      this.not = not;
   }

   public SQLInListExpr clone() {
      SQLInListExpr x = new SQLInListExpr();
      x.not = this.not;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      for(SQLExpr e : this.targetList) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.targetList.add(e2);
      }

      return x;
   }

   public boolean isNot() {
      return this.not;
   }

   public void setNot(boolean not) {
      this.not = not;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public void addTarget(SQLExpr x) {
      x.setParent(this);
      this.targetList.add(x);
   }

   public void addTarget(int index, SQLExpr x) {
      x.setParent(this);
      this.targetList.add(index, x);
   }

   public List<SQLExpr> getTargetList() {
      return this.targetList;
   }

   public boolean sortTargetList() {
      if (this.targetList.size() < 2) {
         return true;
      } else {
         Class<?> firstClass = ((SQLExpr)this.targetList.get(0)).getClass();

         for(int i = 1; i < this.targetList.size(); ++i) {
            if (((SQLExpr)this.targetList.get(i)).getClass() != firstClass) {
               return false;
            }
         }

         if (!Comparable.class.isAssignableFrom(firstClass)) {
            return false;
         } else {
            List<Comparable> comparableList = new ArrayList<>();
            for (SQLExpr expr : this.targetList) {
               comparableList.add((Comparable) expr);
            }
            Collections.sort(comparableList);
            return true;
         }
      }
   }

   public void setTargetList(List<SQLExpr> targetList) {
      this.targetList = targetList;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.targetList != null) {
            for(SQLExpr item : this.targetList) {
               if (item != null) {
                  item.accept(visitor);
               }
            }
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.expr != null) {
         children.add(this.expr);
      }

      children.addAll(this.targetList);
      return children;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.not ? 1231 : 1237);
      result = 31 * result + (this.targetList == null ? 0 : this.targetList.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLInListExpr other = (SQLInListExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         if (this.not != other.not) {
            return false;
         } else {
            if (this.targetList == null) {
               if (other.targetList != null) {
                  return false;
               }
            } else if (!this.targetList.equals(other.targetList)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return SQLBooleanExpr.DATA_TYPE;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         for(int i = this.targetList.size() - 1; i >= 0; --i) {
            if (this.targetList.get(i) == expr) {
               if (target == null) {
                  this.targetList.remove(i);
               } else {
                  this.targetList.set(i, target);
                  target.setParent(this);
               }

               return true;
            }
         }

         return false;
      }
   }

   public SQLCommentHint getHint() {
      return this.hint;
   }

   public void setHint(SQLCommentHint hint) {
      this.hint = hint;
   }
}
