package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class SQLNCharExpr extends SQLTextLiteralExpr {
   private static SQLDataType defaultDataType = new SQLCharacterDataType("nvarchar");

   public SQLNCharExpr() {
   }

   public SQLNCharExpr(String text) {
      this.text = text;
   }

   public SQLNCharExpr(String text, SQLObject parent) {
      this.text = text;
      this.parent = parent;
   }

   public void output(Appendable buf) {
      try {
         if (this.text != null && this.text.length() != 0) {
            buf.append("N'");
            buf.append(this.text.replaceAll("'", "''"));
            buf.append("'");
         } else {
            buf.append("NULL");
         }
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public SQLNCharExpr clone() {
      return new SQLNCharExpr(this.text);
   }

   public SQLDataType computeDataType() {
      return defaultDataType;
   }
}
