package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class SQLNotExpr extends SQLExprImpl implements Serializable, SQLReplaceable {
   private static final long serialVersionUID = 1L;
   public SQLExpr expr;

   public SQLNotExpr() {
   }

   public SQLNotExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.expr = x;
   }

   public void output(Appendable buf) {
      try {
         buf.append(" NOT ");
         this.expr.output(buf);
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.expr != null) {
         this.expr.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return Collections.singletonList(this.expr);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLNotExpr other = (SQLNotExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         return true;
      }
   }

   public SQLNotExpr clone() {
      SQLNotExpr x = new SQLNotExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public SQLDataType computeDataType() {
      return SQLBooleanExpr.DATA_TYPE;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }
}
