package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExprImpl;
import java.util.Collections;
import java.util.List;

public abstract class SQLTextLiteralExpr extends SQLExprImpl implements SQLLiteralExpr {
   protected String text;

   public SQLTextLiteralExpr() {
   }

   public SQLTextLiteralExpr(String text) {
      this.text = text;
   }

   public String getText() {
      return this.text;
   }

   public void setText(String text) {
      this.text = text;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLTextLiteralExpr other = (SQLTextLiteralExpr)obj;
         if (this.text == null) {
            if (other.text != null) {
               return false;
            }
         } else if (!this.text.equals(other.text)) {
            return false;
         }

         return true;
      }
   }

   public abstract SQLTextLiteralExpr clone();

   public List getChildren() {
      return Collections.emptyList();
   }
}
