package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLValuesExpr extends SQLExprImpl implements SQLReplaceable {
   private List<SQLListExpr> values = new ArrayList();

   public List<SQLListExpr> getValues() {
      return this.values;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLValuesExpr that = (SQLValuesExpr)o;
         return this.values.equals(that.values);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.values.hashCode();
   }

   public SQLExpr clone() {
      SQLValuesExpr x = new SQLValuesExpr();

      for(SQLListExpr value : this.values) {
         SQLListExpr value2 = value.clone();
         value2.setParent(x);
         x.values.add(value2);
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.values.size(); ++i) {
         if (this.values.get(i) == expr) {
            target.setParent(this);
            this.values.set(i, (SQLListExpr)target);
            return true;
         }
      }

      return false;
   }

   public List getChildren() {
      return this.values;
   }
}
