package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDbTypedObject;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import java.util.List;

public abstract class SQLConstraintImpl extends SQLObjectImpl implements SQLConstraint, SQLDbTypedObject {
   protected DbType dbType;
   protected SQLName name;
   protected Boolean enable;
   protected Boolean validate;
   protected Boolean rely;
   private SQLExpr comment;
   public List<SQLCommentHint> hints;

   public void cloneTo(SQLConstraintImpl x) {
      if (this.getName() != null) {
         x.setName(this.getName().clone());
      }

      x.enable = this.enable;
      x.validate = this.validate;
      x.rely = this.rely;
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public void setName(String name) {
      this.setName((SQLName)(new SQLIdentifierExpr(name)));
   }

   public Boolean getEnable() {
      return this.enable;
   }

   public void setEnable(Boolean enable) {
      this.enable = enable;
   }

   public void cloneTo(SQLConstraint x) {
      if (this.getName() != null) {
         x.setName(this.getName().clone());
      }

   }

   public Boolean getValidate() {
      return this.validate;
   }

   public void setValidate(Boolean validate) {
      this.validate = validate;
   }

   public Boolean getRely() {
      return this.rely;
   }

   public void setRely(Boolean rely) {
      this.rely = rely;
   }

   public DbType getDbType() {
      return this.dbType;
   }

   public void setDbType(DbType dbType) {
      this.dbType = dbType;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.comment = x;
   }

   public void simplify() {
      if (this.getName() instanceof SQLIdentifierExpr) {
         SQLIdentifierExpr identExpr = (SQLIdentifierExpr)this.getName();
         String columnName = identExpr.getName();
         String normalized = SQLUtils.normalize(columnName, this.dbType);
         if (columnName != normalized) {
            this.setName(normalized);
         }
      }

   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.getName() == expr) {
         this.setName((SQLName)target);
         return true;
      } else if (this.getComment() == expr) {
         this.setComment(target);
         return true;
      } else {
         return false;
      }
   }
}
