package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLShowDatabasesStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   private boolean physical;
   private boolean full;
   private SQLName database;
   private SQLExpr like;
   private SQLExpr where;
   private boolean extra;

   public boolean isPhysical() {
      return this.physical;
   }

   public void setPhysical(boolean physical) {
      this.physical = physical;
   }

   public SQLName getDatabase() {
      return this.database;
   }

   public void setDatabase(SQLName database) {
      this.database = database;
   }

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr like) {
      this.like = like;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
         this.acceptChild(visitor, this.like);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public boolean isExtra() {
      return this.extra;
   }

   public void setExtra(boolean extra) {
      this.extra = extra;
   }

   public boolean isFull() {
      return this.full;
   }

   public void setFull(boolean full) {
      this.full = full;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.database == expr) {
         this.setDatabase((SQLName)target);
         return true;
      } else if (this.like == expr) {
         this.setLike(target);
         return true;
      } else if (this.where == expr) {
         this.setWhere(target);
         return true;
      } else {
         return false;
      }
   }
}
