package com.alibaba.druid.sql.dialect.db2.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2OptionValue extends DB2SQLObjectImpl implements SQLExpr {
   protected SQLExpr option;
   protected SQLExpr value;
   private boolean eq = false;

   public boolean isEq() {
      return this.eq;
   }

   public void setEq(boolean eq) {
      this.eq = eq;
   }

   public SQLExpr getOption() {
      return this.option;
   }

   public void setOption(SQLExpr option) {
      this.option = option;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.option);
         if (this.value != null) {
            this.acceptChild(visitor, this.value);
         }
      }

      visitor.endVisit(this);
   }

   public void cloneTo(DB2OptionValue c) {
      c.setOption(this.option.clone());
      if (this.value != null) {
         c.setValue(this.value.clone());
      }

   }

   public DB2OptionValue clone() {
      DB2OptionValue c = new DB2OptionValue();
      this.cloneTo(c);
      return c;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> c = new ArrayList();
      c.add(this.option);
      if (this.value != null) {
         c.add(this.value);
      }

      return c;
   }
}
