package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DB2SelectStatement extends SQLSelectStatement implements DB2SQLStatement {
   public DB2SelectStatement() {
      super(DbType.db2);
   }

   public DB2SelectStatement(SQLSelect select) {
      super(select, DbType.db2);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DB2ASTVisitor) {
         this.accept0((DB2ASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
      }

      visitor.endVisit(this);
   }
}
