package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DB2SetTransactionStatement extends SQLSetStatement implements DB2SQLStatement {
   private boolean transaction;
   private boolean readWrite;
   private boolean readOnly;
   private boolean isolationLevel;
   private boolean serializable;
   private boolean readUncommitted;
   private boolean readCommitted;
   private boolean repeatableRead;

   public boolean isTransaction() {
      return this.transaction;
   }

   public void setTransaction(boolean transaction) {
      this.transaction = transaction;
   }

   public boolean isReadWrite() {
      return this.readWrite;
   }

   public void setReadWrite(boolean readWrite) {
      this.readWrite = readWrite;
   }

   public boolean isReadOnly() {
      return this.readOnly;
   }

   public void setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
   }

   public boolean isIsolationLevel() {
      return this.isolationLevel;
   }

   public void setIsolationLevel(boolean isolationLevel) {
      this.isolationLevel = isolationLevel;
   }

   public boolean isSerializable() {
      return this.serializable;
   }

   public void setSerializable(boolean serializable) {
      this.serializable = serializable;
   }

   public boolean isReadUncommitted() {
      return this.readUncommitted;
   }

   public void setReadUncommitted(boolean readUncommitted) {
      this.readUncommitted = readUncommitted;
   }

   public boolean isReadCommitted() {
      return this.readCommitted;
   }

   public void setReadCommitted(boolean readCommitted) {
      this.readCommitted = readCommitted;
   }

   public boolean isRepeatableRead() {
      return this.repeatableRead;
   }

   public void setRepeatableRead(boolean repeatableRead) {
      this.repeatableRead = repeatableRead;
   }

   public DB2SetTransactionStatement() {
      super(DbType.db2);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DB2ASTVisitor) {
         this.accept0((DB2ASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }
}
