package com.alibaba.druid.sql.dialect.db2.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLIndexSpec;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLPartition;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLPartitionBy;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2BoxExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2CidrExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2CircleExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2ColumnSimpleDefinitionExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2CurrentTimeExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2ExtractExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2InetExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2LineSegmentsExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2MacAddrExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2OptionValue;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2PointExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2PolygonExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2SQLObjectCollection;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2SchemaTables;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2TypeCastExpr;
import com.alibaba.druid.sql.dialect.db2.ast.expr.constraint.DB2Constraint;
import com.alibaba.druid.sql.dialect.db2.ast.expr.constraint.DB2StorageParameter;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2ExprTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2FunctionTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2MethodInvokeTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2RowsFromTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2SubqueryTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource.DB2ValuesTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterGroupStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterIndexStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterRoleStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterSchemaStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterSequenceStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterSessionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterSynonymStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterSystemKillSessionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterTableSpaceStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterTableStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterTriggerStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2AlterViewStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CommonStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2ConnectToStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateGroupStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateIndexStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateMaterializedViewStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateRoleStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateSchemaStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateSeqenceStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateSynonymStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTableAsStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTableSpaceStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTableStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTriggerStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateViewStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DeleteStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropConnectionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropSchemaStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropSequenceStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropSessionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2DropTriggerStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2GrantStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2InsertStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2LockTableStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2RevokeStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SetConnectionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SetSessionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SetTransactionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2ShowStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2StartTransactionStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2UpdateStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableAddColumn;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableAddConstraint;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableAlterColumnOptions;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableCluster;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableDisableEnabelTrigger;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableDropColumn;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableDropConstraint;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableInheriteOrNotParentTable;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableModify;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableOf;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableRenameColumn;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableRenameConstraint;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableRenameTo;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableSetNewTableSpace;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableSetReset;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableSetSchema;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableSetTableSpace;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableSetWith;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterTableValidateConstraint;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2AlterUserStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2ColumnDefinition;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable.DB2CreateUserStatement;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.PGUtils;

public class DB2SchemaStatVisitor extends SchemaStatVisitor implements DB2ASTVisitor {
   public DB2SchemaStatVisitor() {
      super(DbType.db2);
   }

   public DB2SchemaStatVisitor(SchemaRepository repository) {
      super(repository);
   }

   public DbType getDbType() {
      return DbType.db2;
   }

   public void endVisit(DB2SelectQueryBlock x) {
   }

   public boolean visit(DB2SelectQueryBlock x) {
      return true;
   }

   public void endVisit(DB2SelectQueryBlock.FetchClause x) {
   }

   public boolean visit(DB2SelectQueryBlock.FetchClause x) {
      return true;
   }

   public void endVisit(DB2SelectQueryBlock.ForClause x) {
   }

   public boolean visit(DB2SelectQueryBlock.ForClause x) {
      return true;
   }

   public void endVisit(DB2DeleteStatement x) {
   }

   public boolean visit(DB2DeleteStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      SQLTableSource using = x.getUsing();
      if (using != null) {
         using.accept(this);
      }

      x.putAttribute("_original_use_mode", this.getMode());
      this.setMode(x, TableStat.Mode.Delete);
      TableStat stat = this.getTableStat(x.getTableName());
      stat.incrementDeleteCount();
      this.accept(x.getWhere());
      return false;
   }

   public void endVisit(DB2InsertStatement x) {
   }

   public boolean visit(DB2InsertStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      x.putAttribute("_original_use_mode", this.getMode());
      this.setMode(x, TableStat.Mode.Insert);
      SQLName tableName = x.getTableName();
      TableStat stat = this.getTableStat(tableName);
      stat.incrementInsertCount();
      this.accept(x.getColumns());
      this.accept(x.getQuery());
      return false;
   }

   public void endVisit(DB2SelectStatement x) {
   }

   public boolean visit(DB2SelectStatement x) {
      return this.visit((SQLSelectStatement)x);
   }

   public void endVisit(DB2UpdateStatement x) {
   }

   public boolean isPseudoColumn(long hash) {
      return PGUtils.isPseudoColumn(hash);
   }

   public boolean visit(DB2UpdateStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      TableStat stat = this.getTableStat(x.getTableName());
      stat.incrementUpdateCount();
      this.accept(x.getFrom());
      this.accept(x.getItems());
      this.accept(x.getWhere());
      return false;
   }

   public void endVisit(DB2FunctionTableSource x) {
   }

   public boolean visit(DB2FunctionTableSource x) {
      return true;
   }

   public void endVisit(DB2TypeCastExpr x) {
   }

   public boolean visit(DB2TypeCastExpr x) {
      x.getExpr().accept(this);
      return false;
   }

   public void endVisit(DB2ExtractExpr x) {
   }

   public boolean visit(DB2ExtractExpr x) {
      return true;
   }

   public void endVisit(DB2BoxExpr x) {
   }

   public boolean visit(DB2BoxExpr x) {
      return true;
   }

   public void endVisit(DB2PointExpr x) {
   }

   public boolean visit(DB2PointExpr x) {
      return true;
   }

   public void endVisit(DB2MacAddrExpr x) {
   }

   public boolean visit(DB2MacAddrExpr x) {
      return true;
   }

   public void endVisit(DB2InetExpr x) {
   }

   public boolean visit(DB2InetExpr x) {
      return true;
   }

   public void endVisit(DB2CidrExpr x) {
   }

   public boolean visit(DB2CidrExpr x) {
      return true;
   }

   public void endVisit(DB2PolygonExpr x) {
   }

   public boolean visit(DB2PolygonExpr x) {
      return true;
   }

   public void endVisit(DB2CircleExpr x) {
   }

   public boolean visit(DB2CircleExpr x) {
      return true;
   }

   public void endVisit(DB2LineSegmentsExpr x) {
   }

   public boolean visit(DB2LineSegmentsExpr x) {
      return true;
   }

   public void endVisit(DB2ShowStatement x) {
   }

   public boolean visit(DB2ShowStatement x) {
      return false;
   }

   public void endVisit(DB2StartTransactionStatement x) {
   }

   public boolean visit(DB2StartTransactionStatement x) {
      return false;
   }

   public void endVisit(DB2ConnectToStatement x) {
   }

   public boolean visit(DB2ConnectToStatement x) {
      return false;
   }

   public void endVisit(DB2CreateSchemaStatement x) {
   }

   public boolean visit(DB2CreateSchemaStatement x) {
      return false;
   }

   public void endVisit(DB2DropSchemaStatement x) {
   }

   public boolean visit(DB2DropSchemaStatement x) {
      return false;
   }

   public void endVisit(DB2AlterSchemaStatement x) {
   }

   public boolean visit(DB2AlterSchemaStatement x) {
      return false;
   }

   public void endVisit(DB2MethodInvokeTableSource x) {
   }

   public boolean visit(DB2MethodInvokeTableSource x) {
      return true;
   }

   public void endVisit(DB2ExprTableSource x) {
   }

   public boolean visit(DB2ExprTableSource x) {
      return true;
   }

   public void endVisit(DB2SubqueryTableSource x) {
   }

   public boolean visit(DB2SubqueryTableSource x) {
      return true;
   }

   public void endVisit(DB2ValuesTableSource x) {
   }

   public boolean visit(DB2ValuesTableSource x) {
      return true;
   }

   public void endVisit(DB2ValuesTableSource.ValueRow x) {
   }

   public boolean visit(DB2ValuesTableSource.ValueRow x) {
      return true;
   }

   public void endVisit(DB2SelectQueryBlock.ForClauses x) {
   }

   public boolean visit(DB2SelectQueryBlock.ForClauses x) {
      return true;
   }

   public void endVisit(DB2ColumnSimpleDefinitionExpr x) {
   }

   public boolean visit(DB2ColumnSimpleDefinitionExpr x) {
      return true;
   }

   public void endVisit(DB2RowsFromTableSource x) {
   }

   public boolean visit(DB2RowsFromTableSource x) {
      return true;
   }

   public void endVisit(DB2AlterDatabaseStatement x) {
   }

   public boolean visit(DB2AlterDatabaseStatement x) {
      return true;
   }

   public void endVisit(DB2AlterIndexStatement x) {
   }

   public boolean visit(DB2AlterIndexStatement x) {
      return true;
   }

   public void endVisit(DB2AlterSequenceStatement x) {
   }

   public boolean visit(DB2AlterSequenceStatement x) {
      return true;
   }

   public void endVisit(DB2AlterTableStatement x) {
   }

   public boolean visit(DB2AlterTableStatement x) {
      return true;
   }

   public void endVisit(DB2AlterTableRenameColumn x) {
   }

   public boolean visit(DB2AlterTableRenameColumn x) {
      return true;
   }

   public void endVisit(DB2AlterTableRenameConstraint x) {
   }

   public boolean visit(DB2AlterTableRenameConstraint x) {
      return true;
   }

   public void endVisit(DB2AlterTableRenameTo x) {
   }

   public boolean visit(DB2AlterTableRenameTo x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetSchema x) {
   }

   public boolean visit(DB2AlterTableSetSchema x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetNewTableSpace x) {
   }

   public boolean visit(DB2AlterTableSetNewTableSpace x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetWith x) {
   }

   public boolean visit(DB2AlterTableSetWith x) {
      return true;
   }

   public void endVisit(DB2AlterTableAddColumn x) {
   }

   public boolean visit(DB2AlterTableAddColumn x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetWith.DB2AlterTableDistributeByOption x) {
   }

   public boolean visit(DB2AlterTableSetWith.DB2AlterTableDistributeByOption x) {
      return true;
   }

   public void endVisit(DB2AlterTableDropColumn x) {
   }

   public boolean visit(DB2AlterTableDropColumn x) {
      return true;
   }

   public void endVisit(DB2AlterTableAlterColumn x) {
   }

   public boolean visit(DB2AlterTableAlterColumn x) {
      return true;
   }

   public void endVisit(DB2AlterTableAlterColumnOptions x) {
   }

   public boolean visit(DB2AlterTableAlterColumnOptions x) {
      return true;
   }

   public void endVisit(DB2AlterTableAlterColumnOptions.DB2AlterTableAlterColumnOptionValue x) {
   }

   public boolean visit(DB2AlterTableAlterColumnOptions.DB2AlterTableAlterColumnOptionValue x) {
      return true;
   }

   public void endVisit(DB2AlterTableAddConstraint x) {
   }

   public boolean visit(DB2AlterTableAddConstraint x) {
      return true;
   }

   public void endVisit(DB2AlterTableAddConstraint.DB2AlterTableAddConstraintUsingIndex x) {
   }

   public boolean visit(DB2AlterTableAddConstraint.DB2AlterTableAddConstraintUsingIndex x) {
      return true;
   }

   public void endVisit(DB2AlterTableValidateConstraint x) {
   }

   public boolean visit(DB2AlterTableValidateConstraint x) {
      return true;
   }

   public void endVisit(DB2AlterTableDropConstraint x) {
   }

   public boolean visit(DB2AlterTableDropConstraint x) {
      return true;
   }

   public void endVisit(DB2AlterTableDisableEnabelTrigger x) {
   }

   public boolean visit(DB2AlterTableDisableEnabelTrigger x) {
      return true;
   }

   public void endVisit(DB2AlterTableCluster x) {
   }

   public boolean visit(DB2AlterTableCluster x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetReset x) {
   }

   public boolean visit(DB2AlterTableSetReset x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetReset.StorageParameter x) {
   }

   public boolean visit(DB2AlterTableSetReset.StorageParameter x) {
      return true;
   }

   public void endVisit(DB2AlterTableInheriteOrNotParentTable x) {
   }

   public boolean visit(DB2AlterTableInheriteOrNotParentTable x) {
      return true;
   }

   public void endVisit(DB2AlterTableOf x) {
   }

   public boolean visit(DB2AlterTableOf x) {
      return true;
   }

   public void endVisit(DB2AlterTableSetTableSpace x) {
   }

   public boolean visit(DB2AlterTableSetTableSpace x) {
      return true;
   }

   public void endVisit(DB2CreateDatabaseStatement x) {
   }

   public boolean visit(DB2CreateDatabaseStatement x) {
      return true;
   }

   public void endVisit(DB2Constraint x) {
   }

   public boolean visit(DB2Constraint x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2ConstraintCheck x) {
   }

   public boolean visit(DB2Constraint.DB2ConstraintCheck x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2Unique x) {
   }

   public boolean visit(DB2Constraint.DB2Unique x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2PrimaryKey x) {
   }

   public boolean visit(DB2Constraint.DB2PrimaryKey x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2ForeignKey x) {
   }

   public boolean visit(DB2Constraint.DB2ForeignKey x) {
      return true;
   }

   public void endVisit(DB2OptionValue x) {
   }

   public boolean visit(DB2OptionValue x) {
      return true;
   }

   public void endVisit(DB2StorageParameter x) {
   }

   public boolean visit(DB2StorageParameter x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2IndexParamaters x) {
   }

   public boolean visit(DB2Constraint.DB2IndexParamaters x) {
      return true;
   }

   public void endVisit(DB2Constraint.DB2Reference x) {
   }

   public boolean visit(DB2Constraint.DB2Reference x) {
      return true;
   }

   public void endVisit(DB2ColumnDefinition x) {
   }

   public boolean visit(DB2ColumnDefinition x) {
      return true;
   }

   public void endVisit(DB2CreateTableStatement x) {
   }

   public boolean visit(DB2CreateTableStatement x) {
      return true;
   }

   public void endVisit(DB2CreateTableStatement.DB2TableDistributedBy x) {
   }

   public boolean visit(DB2CreateTableStatement.DB2TableDistributedBy x) {
      return true;
   }

   public void endVisit(DB2SQLObjectCollection x) {
   }

   public boolean visit(DB2SQLObjectCollection x) {
      return true;
   }

   public void endVisit(DB2SchemaTables x) {
   }

   public boolean visit(DB2SchemaTables x) {
      return true;
   }

   public void endVisit(DB2GrantStatement x) {
   }

   public boolean visit(DB2GrantStatement x) {
      return true;
   }

   public boolean visit(DB2AlterViewStatement x) {
      return true;
   }

   public boolean visit(DB2CreateSeqenceStatement x) {
      return true;
   }

   public boolean visit(DB2CreateTableSpaceStatement x) {
      return true;
   }

   public boolean visit(DB2CreateViewStatement x) {
      return true;
   }

   public boolean visit(DB2DropSequenceStatement x) {
      return true;
   }

   public boolean visit(DB2SQLPartitionBy x) {
      return true;
   }

   public boolean visit(DB2SQLPartition x) {
      return true;
   }

   public boolean visit(DB2SQLIndexSpec x) {
      return true;
   }

   public boolean visit(DB2CreateIndexStatement x) {
      return true;
   }

   public void endVisit(DB2AlterSessionStatement x) {
   }

   public boolean visit(DB2AlterSessionStatement x) {
      return true;
   }

   public void endVisit(DB2AlterSystemKillSessionStatement x) {
   }

   public boolean visit(DB2AlterSystemKillSessionStatement x) {
      return true;
   }

   public void endVisit(DB2AlterTableSpaceStatement x) {
   }

   public boolean visit(DB2AlterTableSpaceStatement x) {
      return true;
   }

   public void endVisit(DB2AlterTableModify x) {
   }

   public boolean visit(DB2AlterTableModify x) {
      return false;
   }

   public void endVisit(DB2CreateUserStatement x) {
   }

   public boolean visit(DB2CreateUserStatement x) {
      return false;
   }

   public void endVisit(DB2AlterUserStatement x) {
   }

   public boolean visit(DB2AlterUserStatement x) {
      return false;
   }

   public void endVisit(DB2CommonStatement x) {
   }

   public boolean visit(DB2CommonStatement x) {
      return false;
   }

   public void endVisit(DB2CreateGroupStatement x) {
   }

   public boolean visit(DB2CreateGroupStatement x) {
      return false;
   }

   public void endVisit(DB2AlterGroupStatement x) {
   }

   public boolean visit(DB2AlterGroupStatement x) {
      return false;
   }

   public void endVisit(DB2CreateMaterializedViewStatement x) {
   }

   public boolean visit(DB2CreateMaterializedViewStatement x) {
      return false;
   }

   public void endVisit(DB2DropSequenceStatement x) {
   }

   public void endVisit(DB2CreateSynonymStatement x) {
   }

   public boolean visit(DB2CreateSynonymStatement x) {
      return false;
   }

   public void endVisit(DB2AlterSynonymStatement x) {
   }

   public boolean visit(DB2AlterSynonymStatement x) {
      return false;
   }

   public void endVisit(DB2CreateRoleStatement x) {
   }

   public boolean visit(DB2CreateRoleStatement x) {
      return false;
   }

   public void endVisit(DB2AlterRoleStatement x) {
   }

   public boolean visit(DB2AlterRoleStatement x) {
      return false;
   }

   public void endVisit(DB2CreateTableAsStatement x) {
   }

   public boolean visit(DB2CreateTableAsStatement x) {
      return false;
   }

   public void endVisit(DB2RevokeStatement x) {
   }

   public boolean visit(DB2RevokeStatement x) {
      return false;
   }

   public void endVisit(DB2CreateTriggerStatement x) {
   }

   public boolean visit(DB2CreateTriggerStatement x) {
      return false;
   }

   public void endVisit(DB2AlterTriggerStatement x) {
   }

   public boolean visit(DB2AlterTriggerStatement x) {
      return false;
   }

   public void endVisit(DB2DropTriggerStatement x) {
   }

   public boolean visit(DB2DropTriggerStatement x) {
      return false;
   }

   public void endVisit(DB2SetTransactionStatement x) {
   }

   public boolean visit(DB2SetTransactionStatement x) {
      return false;
   }

   public void endVisit(DB2SetSessionStatement x) {
   }

   public boolean visit(DB2SetSessionStatement x) {
      return false;
   }

   public void endVisit(DB2DropSessionStatement x) {
   }

   public boolean visit(DB2DropSessionStatement x) {
      return false;
   }

   public void endVisit(DB2SetConnectionStatement x) {
   }

   public boolean visit(DB2SetConnectionStatement x) {
      return false;
   }

   public void endVisit(DB2DropConnectionStatement x) {
   }

   public boolean visit(DB2DropConnectionStatement x) {
      return false;
   }

   public void endVisit(DB2LockTableStatement x) {
   }

   public boolean visit(DB2LockTableStatement x) {
      return false;
   }

   public void endVisit(DB2CurrentTimeExpr x) {
   }

   public boolean visit(DB2CurrentTimeExpr x) {
      return false;
   }
}
