package com.alibaba.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GaussAlterTableAlterColumnOptions extends GaussSQLObjectImpl implements SQLAlterTableItem {
   private boolean set = false;
   private List<GaussAlterTableAlterColumnOptionValue> options = new ArrayList();

   public boolean isSet() {
      return this.set;
   }

   public void setSet(boolean set) {
      this.set = set;
   }

   public List<GaussAlterTableAlterColumnOptionValue> getOptions() {
      return this.options;
   }

   public void setOptions(List<GaussAlterTableAlterColumnOptionValue> options) {
      this.options = options;
   }

   public void addOption(GaussAlterTableAlterColumnOptionValue option) {
      this.options.add(option);
      option.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public GaussAlterTableAlterColumnOptions clone() {
      GaussAlterTableAlterColumnOptions c = new GaussAlterTableAlterColumnOptions();
      c.set = this.set;

      for(GaussAlterTableAlterColumnOptionValue option : this.options) {
         c.addOption(option.clone());
      }

      return c;
   }

   public static class GaussAlterTableAlterColumnOptionValue extends GaussSQLObjectImpl {
      private SQLExpr attribute;
      private SQLExpr value;

      public SQLExpr getAttribute() {
         return this.attribute;
      }

      public void setAttribute(SQLExpr attribute) {
         this.attribute = attribute;
         attribute.setParent(this);
      }

      public SQLExpr getValue() {
         return this.value;
      }

      public void setValue(SQLExpr value) {
         this.value = value;
         value.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((GaussASTVisitor)visitor);
      }

      public void accept0(GaussASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.attribute);
            this.acceptChild(visitor, this.value);
         }

         visitor.endVisit(this);
      }

      public GaussAlterTableAlterColumnOptionValue clone() {
         GaussAlterTableAlterColumnOptionValue option = new GaussAlterTableAlterColumnOptionValue();
         option.setAttribute(this.attribute.clone());
         if (this.value != null) {
            option.setValue(this.value.clone());
         }

         return option;
      }
   }
}
