package com.alibaba.druid.sql.dialect.hive.ast;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class HiveInputOutputFormat extends SQLExprImpl {
   private SQLExpr input;
   private SQLExpr output;

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         HiveInputOutputFormat that = (HiveInputOutputFormat)o;
         if (this.input != null) {
            if (!this.input.equals(that.input)) {
               return false;
            }
         } else if (that.input != null) {
            return false;
         }

         return this.output != null ? this.output.equals(that.output) : that.output == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.input != null ? this.input.hashCode() : 0;
      result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
      return result;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.input);
         this.acceptChild(v, this.output);
      }

      v.endVisit(this);
   }

   public HiveInputOutputFormat clone() {
      HiveInputOutputFormat x = new HiveInputOutputFormat();
      if (this.input != null) {
         x.setInput(this.input.clone());
      }

      if (this.output != null) {
         x.setOutput(this.output.clone());
      }

      return x;
   }

   public SQLExpr getInput() {
      return this.input;
   }

   public void setInput(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.input = x;
   }

   public SQLExpr getOutput() {
      return this.output;
   }

   public void setOutput(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.output = x;
   }
}
