package com.alibaba.druid.sql.dialect.hive.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public abstract class HiveStatementImpl extends SQLStatementImpl implements HiveStatement {
   public HiveStatementImpl() {
      super(DbType.hive);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof HiveASTVisitor) {
         this.accept0((HiveASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(HiveASTVisitor v) {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLObject> getChildren() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }
}
