package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExportTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLImportTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmContinueStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmGotoStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmLabelStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmPrintStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveLoadDataStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExplainPlanCacheStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class HiveStatementParser extends SQLStatementParser {
   public HiveStatementParser(String sql) {
      super((SQLExprParser)(new HiveExprParser(sql)));
      this.dbType = DbType.hive;
   }

   public HiveStatementParser(String sql, SQLParserFeature... features) {
      super((SQLExprParser)(new HiveExprParser(sql, features)));
      this.dbType = DbType.hive;
   }

   public HiveStatementParser(Lexer lexer) {
      super((SQLExprParser)(new HiveExprParser(lexer)));
      this.dbType = DbType.hive;
   }

   public HiveSelectParser createSQLSelectParser() {
      return new HiveSelectParser(this.exprParser, this.selectListCache);
   }

   public SQLCreateTableParser getSQLCreateTableParser() {
      return new HiveCreateTableParser(this.exprParser);
   }

   public boolean parseStatementListDialect(List<SQLStatement> statementList) {
      return false;
   }

   protected HiveLoadDataStatement parseLoad() {
      this.accept(Token.LOAD);
      this.acceptIdentifier("DATA");
      HiveLoadDataStatement stmt = new HiveLoadDataStatement();
      if (this.lexer.token() == Token.LOCAL) {
         this.lexer.nextToken();
         stmt.setLocal(true);
      }

      this.acceptIdentifier("INPATH");
      SQLExpr inpath = this.exprParser.expr();
      stmt.setInpath(inpath);
      if (this.lexer.token() == Token.OVERWRITE) {
         this.lexer.nextToken();
         stmt.setOverwrite(true);
      }

      this.accept(Token.INTO);
      this.accept(Token.TABLE);
      SQLExpr table = this.exprParser.expr();
      stmt.setInto(table);
      if (this.lexer.token() == Token.PARTITION) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         this.exprParser.exprList(stmt.getPartition(), stmt);
         this.accept(Token.RPAREN);
      }

      return stmt;
   }

   protected SQLStatement parseExport() {
      this.lexer.nextToken();
      this.accept(Token.TABLE);
      SQLExportTableStatement stmt = new SQLExportTableStatement();
      stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
      if (this.lexer.token() == Token.PARTITION) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         this.parseAssignItems(stmt.getPartition(), stmt, false);
         this.accept(Token.RPAREN);
      }

      if (this.lexer.token() == Token.TO) {
         this.lexer.nextToken();
         SQLExpr to = this.exprParser.primary();
         stmt.setTo(to);
      }

      return stmt;
   }

   protected SQLStatement parseImport() {
      this.lexer.nextToken();
      SQLImportTableStatement stmt = new SQLImportTableStatement();
      if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
         this.lexer.nextToken();
         stmt.setExtenal(true);
      }

      if (this.lexer.token() == Token.TABLE) {
         this.lexer.nextToken();
         stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
      }

      if (this.lexer.token() == Token.PARTITION) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         this.parseAssignItems(stmt.getPartition(), stmt, false);
         this.accept(Token.RPAREN);
      }

      if (this.lexer.token() == Token.FROM) {
         this.lexer.nextToken();
         SQLExpr to = this.exprParser.primary();
         stmt.setFrom(to);
      }

      return stmt;
   }

   public HiveExprParser getExprParser() {
      return (HiveExprParser)this.exprParser;
   }

   public void parseStatementList(List<SQLStatement> statementList, int max, SQLObject parent) {
      if ("select @@session.tx_read_only".equals(this.lexer.text) && this.lexer.token() == Token.SELECT) {
         SQLSelect select = new SQLSelect();
         MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
         queryBlock.addSelectItem(new SQLPropertyExpr(new SQLVariantRefExpr("@@session"), "tx_read_only"));
         select.setQuery(queryBlock);
         SQLSelectStatement stmt = new SQLSelectStatement(select);
         statementList.add(stmt);
         this.lexer.reset(29, '\u001a', Token.EOF);
      } else {
         boolean semi = false;

         for(int i = 0; max == -1 || statementList.size() < max; ++i) {
            while(this.lexer.token() == Token.MULTI_LINE_COMMENT || this.lexer.token() == Token.LINE_COMMENT) {
               this.lexer.nextToken();
            }

            switch (this.lexer.token()) {
               case EOF:
               case END:
               case UNTIL:
               case ELSE:
               case WHEN:
                  if (this.lexer.isKeepComments() && this.lexer.hasComment() && statementList.size() > 0) {
                     SQLStatement stmt = (SQLStatement)statementList.get(statementList.size() - 1);
                     stmt.addAfterComment(this.lexer.readAndResetComments());
                  }

                  return;
               case SEMI:
                  int line0 = this.lexer.getLine();
                  this.lexer.nextToken();
                  int line1 = this.lexer.getLine();
                  if (statementList.size() > 0) {
                     SQLStatement lastStmt = (SQLStatement)statementList.get(statementList.size() - 1);
                     lastStmt.setAfterSemi(true);
                     if (this.lexer.isKeepComments()) {
                        SQLStatement stmt = (SQLStatement)statementList.get(statementList.size() - 1);
                        if (line1 - line0 <= 1) {
                           stmt.addAfterComment(this.lexer.readAndResetComments());
                        }
                     }
                  }

                  semi = true;
                  break;
               case WITH:
                  SQLStatement stmt = this.parseWith();
                  stmt.setParent(parent);
                  statementList.add(stmt);
                  break;
               case SELECT:
                  MySqlHintStatement hintStatement = null;
                  SQLStatement stmt1 = this.parseSelect();
                  stmt1.setParent(parent);
                  if (hintStatement != null && stmt1 instanceof SQLStatementImpl) {
                     SQLStatementImpl stmtImpl = (SQLStatementImpl)stmt1;
                     List<SQLCommentHint> hints = stmtImpl.getHeadHintsDirect();
                     if (hints == null) {
                        stmtImpl.setHeadHints(hintStatement.getHints());
                     } else {
                        hints.addAll(hintStatement.getHints());
                     }

                     statementList.set(statementList.size() - 1, stmt1);
                  } else {
                     statementList.add(stmt1);
                  }

                  semi = false;
                  break;
               case LOAD:
                  SQLStatement stmt2 = this.parseLoad();
                  stmt2.setParent(parent);
                  statementList.add(stmt2);
                  break;
               case UPDATE:
                  Lexer.SavePoint savePoint = this.lexer.mark();
                  this.lexer.nextToken();
                  this.lexer.reset(savePoint);
                  SQLStatement stmt3 = this.parseUpdateStatement();
                  stmt3.setParent(parent);
                  statementList.add(stmt3);
                  break;
               case CREATE:
                  HiveCreateParser parser = new HiveCreateParser(this.exprParser);
                  SQLStatement stmt4 = parser.parseCreate();
                  stmt4.setParent(parent);
                  statementList.add(stmt4);
                  break;
               case INSERT:
                  HiveInsertParser insertParser = new HiveInsertParser(this.exprParser);
                  SQLStatement stmt5 = insertParser.parseInsert();
                  stmt5.setParent(parent);
                  statementList.add(stmt5);
                  break;
               case DELETE:
                  SQLStatement stmt6 = this.parseDeleteStatement();
                  stmt6.setParent(parent);
                  statementList.add(stmt6);
                  break;
               case EXPLAIN:
                  this.lexer.computeRowAndColumn();
                  int sourceLine = this.lexer.getPosLine();
                  int sourceColumn = this.lexer.getPosColumn();
                  Lexer.SavePoint savePoint2 = this.lexer.mark();
                  this.lexer.nextToken();
                  if (this.lexer.identifierEquals("PLANCACHE")) {
                     this.lexer.nextToken();
                     MySqlExplainPlanCacheStatement stmt7 = new MySqlExplainPlanCacheStatement();
                     stmt7.setSourceLine(sourceLine);
                     stmt7.setSourceLine(sourceColumn);
                     statementList.add(stmt7);
                  } else {
                     this.lexer.reset(savePoint2);
                     SQLExplainStatement stmt8 = this.parseExplain();
                     stmt8.setSourceLine(sourceLine);
                     stmt8.setSourceLine(sourceColumn);
                     stmt8.setParent(parent);
                     statementList.add(stmt8);
                  }
                  break;
               case SET:
                  SQLStatement stmt8 = this.parseSet();
                  stmt8.setParent(parent);
                  statementList.add(stmt8);
                  break;
               case ALTER:
                  HiveAlterStatementParser alterParser = new HiveAlterStatementParser(this.exprParser);
                  SQLStatement stmt9 = alterParser.parseAlter();
                  stmt9.setParent(parent);
                  statementList.add(stmt9);
                  break;
               case TRUNCATE:
                  SQLStatement stmt10 = this.parseTruncate();
                  stmt10.setParent(parent);
                  statementList.add(stmt10);
                  break;
               case USE:
                  SQLStatement stmt11 = this.parseUse();
                  stmt11.setParent(parent);
                  statementList.add(stmt11);
                  break;
               case GRANT:
                  HiveGrantParser grantParser = new HiveGrantParser(this.exprParser);
                  SQLStatement stmt12 = grantParser.parseGrant();
                  stmt12.setParent(parent);
                  statementList.add(stmt12);
                  break;
               case REVOKE:
                  HiveGrantParser revokeParser = new HiveGrantParser(this.exprParser);
                  SQLStatement stmt13 = revokeParser.parseRevoke();
                  stmt13.setParent(parent);
                  statementList.add(stmt13);
                  break;
               case SHOW:
                  HiveShowParser showParser = new HiveShowParser(this.exprParser);
                  SQLStatement stmt14 = showParser.parseShow();
                  stmt14.setParent(parent);
                  statementList.add(stmt14);
                  break;
               case ABORT:
                  HiveShowParser abortParser = new HiveShowParser(this.exprParser);
                  SQLStatement stmt15 = abortParser.parseAbort();
                  stmt15.setParent(parent);
                  statementList.add(stmt15);
                  break;
               case MERGE:
                  SQLStatement stmt16 = this.parseMerge();
                  stmt16.setParent(parent);
                  statementList.add(stmt16);
                  break;
               case REPEAT:
                  SQLStatement stmt17 = this.parseRepeat();
                  stmt17.setParent(parent);
                  statementList.add(stmt17);
                  break;
               case WHILE:
                  SQLStatement stmt18 = this.parseWhile();
                  stmt18.setParent(parent);
                  statementList.add(stmt18);
                  break;
               case IF:
                  SQLStatement stmt19 = this.parseIf();
                  stmt19.setParent(parent);
                  statementList.add(stmt19);
                  break;
               case CASE:
                  SQLStatement stmt20 = this.parseCase();
                  stmt20.setParent(parent);
                  statementList.add(stmt20);
                  break;
               case OPEN:
                  SQLStatement stmt21 = this.parseOpen();
                  stmt21.setParent(parent);
                  statementList.add(stmt21);
                  break;
               case NULL:
                  this.lexer.nextToken();
                  SQLExprStatement stmt22 = new SQLExprStatement(new SQLNullExpr());
                  stmt22.setParent(parent);
                  statementList.add(stmt22);
                  break;
               case FETCH:
                  SQLStatement stmt23 = this.parseFetch();
                  stmt23.setParent(parent);
                  statementList.add(stmt23);
                  break;
               case DROP:
                  SQLStatement stmt24 = this.parseDrop();
                  stmt24.setParent(parent);
                  statementList.add(stmt24);
                  break;
               case COMMENT:
                  SQLStatement stmt25 = this.parseComment();
                  stmt25.setParent(parent);
                  statementList.add(stmt25);
                  break;
               case KILL:
                  SQLStatement stmt26 = this.parseKill();
                  stmt26.setParent(parent);
                  statementList.add(stmt26);
                  break;
               case CLOSE:
                  SQLStatement stmt27 = this.parseClose();
                  stmt27.setParent(parent);
                  statementList.add(stmt27);
                  break;
               case RETURN:
                  SQLStatement stmt28 = this.parseReturn();
                  stmt28.setParent(parent);
                  statementList.add(stmt28);
                  break;
               case UPSERT:
                  SQLStatement stmt29 = this.parseUpsert();
                  stmt29.setParent(parent);
                  statementList.add(stmt29);
                  break;
               case LEAVE:
                  SQLStatement stmt30 = this.parseLeave();
                  stmt30.setParent(parent);
                  statementList.add(stmt30);
                  break;
               default:
                  if (this.lexer.token() == Token.CASE) {
                     SQLStatement stmt31 = this.parseCase();
                     stmt31.setParent(parent);
                     statementList.add(stmt31);
                  } else if (this.lexer.token() != Token.LBRACE && !this.lexer.identifierEquals("CALL")) {
                     if (this.lexer.identifierEquals("UPSERT")) {
                        SQLStatement stmt32 = this.parseUpsert();
                        statementList.add(stmt32);
                     } else {
                        if (this.lexer.identifierEquals("LIST")) {
                           Lexer.SavePoint mark = this.lexer.mark();
                           SQLStatement stmt33 = this.parseList();
                           if (stmt33 != null) {
                              statementList.add(stmt33);
                              continue;
                           }

                           this.lexer.reset(mark);
                        }

                        if (this.lexer.identifierEquals("RENAME")) {
                           SQLStatement stmt34 = this.parseRename();
                           statementList.add(stmt34);
                        } else if (this.lexer.token() == Token.CONTINUE) {
                           this.lexer.nextToken();
                           DmContinueStatement stmt35 = new DmContinueStatement();
                           if (this.lexer.token() == Token.IDENTIFIER) {
                              String label = this.lexer.stringVal();
                              this.lexer.nextToken();
                              stmt35.setLabel(label);
                           }

                           if (this.lexer.token() == Token.WHEN) {
                              this.lexer.nextToken();
                              stmt35.setWhen(this.exprParser.expr());
                           }

                           stmt35.setParent(parent);
                           statementList.add(stmt35);
                        } else if (this.lexer.token() == Token.GOTO) {
                           this.lexer.nextToken();
                           SQLName label = this.exprParser.name();
                           DmGotoStatement stmt36 = new DmGotoStatement(label);
                           stmt36.setParent(parent);
                           statementList.add(stmt36);
                        } else if (this.lexer.token() == Token.LTLT) {
                           this.lexer.nextToken();
                           SQLName label = this.exprParser.name();
                           DmLabelStatement stmt37 = new DmLabelStatement(label);
                           this.accept(Token.GTGT);
                           stmt37.setParent(parent);
                           statementList.add(stmt37);
                        } else if (this.lexer.identifierEquals("RELEASE")) {
                           SQLStatement stmt38 = this.parseReleaseSavePoint();
                           statementList.add(stmt38);
                        } else if (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.DECLARE) {
                           if (this.lexer.token() == Token.SAVEPOINT) {
                              SQLStatement stmt39 = this.parseSavePoint();
                              statementList.add(stmt39);
                           } else if (this.lexer.identifierEquals("REFRESH")) {
                              SQLStatement stmt40 = this.parseRefresh();
                              statementList.add(stmt40);
                           } else if (this.lexer.identifierEquals(FnvHash.Constants.COPY)) {
                              SQLStatement stmt41 = this.parseCopy();
                              statementList.add(stmt41);
                           } else if (this.lexer.token() != Token.DESC && !this.lexer.identifierEquals(FnvHash.Constants.DESCRIBE)) {
                              if (this.lexer.identifierEquals("ROLLBACK")) {
                                 SQLStatement stmt42 = this.parseRollback();
                                 statementList.add(stmt42);
                                 if (parent instanceof SQLBlockStatement && DbType.mysql == this.dbType) {
                                    return;
                                 }
                              } else if (this.lexer.identifierEquals("DUMP")) {
                                 SQLStatement stmt43 = this.parseDump();
                                 statementList.add(stmt43);
                              } else if (this.lexer.token() == Token.COMMIT) {
                                 SQLStatement stmt44 = this.parseCommit();
                                 statementList.add(stmt44);
                                 if (parent instanceof SQLBlockStatement && DbType.mysql == this.dbType) {
                                    return;
                                 }
                              } else if (this.lexer.identifierEquals(FnvHash.Constants.RETURN)) {
                                 SQLStatement stmt45 = this.parseReturn();
                                 statementList.add(stmt45);
                              } else if (this.lexer.identifierEquals(FnvHash.Constants.PURGE)) {
                                 SQLStatement stmt46 = this.parsePurge();
                                 statementList.add(stmt46);
                              } else if (this.lexer.identifierEquals(FnvHash.Constants.FLASHBACK)) {
                                 SQLStatement stmt47 = this.parseFlashback();
                                 statementList.add(stmt47);
                              } else if (this.lexer.identifierEquals(FnvHash.Constants.WHO)) {
                                 SQLStatement stmt48 = this.parseWhoami();
                                 statementList.add(stmt48);
                              } else if (this.lexer.token() == Token.FOR) {
                                 SQLStatement stmt49 = this.parseFor();
                                 statementList.add(stmt49);
                                 stmt49.setParent(parent);
                              } else if (this.lexer.token() == Token.LPAREN) {
                                 char markChar = this.lexer.current();
                                 int markBp = this.lexer.bp();

                                 do {
                                    this.lexer.nextToken();
                                 } while(this.lexer.token() == Token.LPAREN);

                                 if (this.lexer.token() != Token.SELECT) {
                                    throw new ParserException("TODO " + this.lexer.info());
                                 }

                                 this.lexer.reset(markBp, markChar, Token.LPAREN);
                                 SQLStatement stmt50 = this.parseSelect();
                                 statementList.add(stmt50);
                              } else if (this.lexer.token() == Token.VALUES) {
                                 SQLValuesTableSource values = this.createSQLSelectParser().parseValues();
                                 SQLSelectStatement stmt56 = new SQLSelectStatement();
                                 stmt56.setSelect(new SQLSelect(values));
                                 stmt56.setParent(parent);
                                 statementList.add(stmt56);
                              } else if (this.lexer.identifierEquals("PRINT")) {
                                 this.lexer.nextToken();
                                 DmPrintStatement stmt57 = new DmPrintStatement();
                                 stmt57.setString(this.exprParser.expr());
                                 stmt57.setParent(parent);
                                 statementList.add(stmt57);
                              } else {
                                 if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.VARIANT) {
                                    Lexer.SavePoint savePoint3 = this.lexer.mark();
                                    if (this.lexer.token() == Token.VARIANT) {
                                       this.exprParser.name();
                                    } else {
                                       this.lexer.nextToken();
                                       if (this.lexer.token() == Token.DOT) {
                                          this.lexer.nextToken();
                                          this.lexer.nextToken();
                                       }
                                    }

                                    if (this.lexer.token() == Token.COLONEQ || this.lexer.token() == Token.EQ) {
                                       this.lexer.reset(savePoint3);
                                       SQLStatement stmt51 = this.parseSet();
                                       stmt51.setParent(parent);
                                       statementList.add(stmt51);
                                       continue;
                                    }

                                    if (this.lexer.token() == Token.LPAREN) {
                                       this.lexer.reset(savePoint3);
                                       SQLCallStatement stmt52 = this.parseCall();
                                       stmt52.setParent(parent);
                                       statementList.add(stmt52);
                                       continue;
                                    }

                                    this.lexer.reset(savePoint3);
                                 }

                                 int size = statementList.size();
                                 if (this.parseStatementListDialect(statementList)) {
                                    if (parent != null) {
                                       for(int j = size; j < statementList.size(); ++j) {
                                          SQLStatement dialectStmt = (SQLStatement)statementList.get(j);
                                          dialectStmt.setParent(parent);
                                       }
                                    }
                                 } else {
                                    this.printError(this.lexer.token());
                                 }
                              }
                           } else {
                              SQLStatement stmt53 = this.parseDescribe();
                              stmt53.setParent(parent);
                              statementList.add(stmt53);
                           }
                        } else {
                           SQLStatement stmt54 = this.parseBlock();
                           stmt54.setParent(parent);
                           statementList.add(stmt54);
                        }
                     }
                  } else {
                     SQLCallStatement stmt55 = this.parseCall();
                     stmt55.setParent(parent);
                     statementList.add(stmt55);
                  }
            }
         }

      }
   }
}
