package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.dialect.mariadb.ast.MariadbObject;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class MariadbPartitionByKey extends SQLPartitionBy implements MariadbObject {
   private int algorithm = 2;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MariadbASTVisitor) {
         this.accept0((MariadbASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.partitionsCount);
         this.acceptChild(visitor, this.getPartitions());
         this.acceptChild(visitor, this.subPartitionBy);
      }

      visitor.endVisit(this);
   }

   public void cloneTo(MariadbPartitionByKey x) {
      super.cloneTo(x);

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      x.algorithm = this.algorithm;
   }

   public MariadbPartitionByKey clone() {
      MariadbPartitionByKey x = new MariadbPartitionByKey();
      this.cloneTo(x);
      return x;
   }

   public int getAlgorithm() {
      return this.algorithm;
   }

   public void setAlgorithm(int algorithm) {
      this.algorithm = algorithm;
   }
}
