package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.dialect.mariadb.ast.MariadbObject;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public abstract class MariadbStatementImpl extends SQLStatementImpl implements SQLStatement, MariadbObject {
   public MariadbStatementImpl() {
      super(DbType.mariadb);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MariadbASTVisitor) {
         this.accept0((MariadbASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MariadbASTVisitor v) {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLObject> getChildren() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }
}
