package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class MariadbUpdateTableSource extends SQLTableSourceImpl {
   private MariadbUpdateStatement update;

   public MariadbUpdateTableSource(MariadbUpdateStatement update) {
      this.update = update;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MariadbASTVisitor) {
         this.accept0((MariadbASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.update);
      }

      visitor.endVisit(this);
   }

   public MariadbUpdateStatement getUpdate() {
      return this.update;
   }

   public void setUpdate(MariadbUpdateStatement update) {
      this.update = update;
   }

   public MariadbUpdateTableSource clone() {
      MariadbUpdateTableSource x = new MariadbUpdateTableSource(this.update);
      x.setAlias(this.alias);
      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
