package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseItem;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlAlterDatabaseSetOption extends MySqlObjectImpl implements SQLAlterDatabaseItem {
   private List<SQLAssignItem> options = new ArrayList();
   private SQLName on;

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getOption(String name) {
      for(SQLAssignItem item : this.options) {
         SQLExpr target = item.getTarget();
         if (target instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)target).getName().equalsIgnoreCase(name)) {
            return item.getValue();
         }
      }

      return null;
   }

   public List<SQLAssignItem> getOptions() {
      return this.options;
   }

   public SQLName getOn() {
      return this.on;
   }

   public void setOn(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.on = x;
   }
}
