package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class OracleOuterExpr extends SQLExprImpl implements OracleExpr, SQLReplaceable {
   private SQLExpr expr;

   public OracleOuterExpr() {
   }

   public OracleOuterExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public OracleOuterExpr clone() {
      OracleOuterExpr x = new OracleOuterExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      } else {
         this.acceptChild(visitor, this.expr);
      }

   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.expr);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         OracleOuterExpr other = (OracleOuterExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         return true;
      }
   }
}
