package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.Arrays;
import java.util.List;

public class OracleTreatExpr extends OracleSQLObjectImpl implements SQLExpr {
   private SQLExpr expr;
   private SQLExpr type;
   private boolean ref;

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      if (type != null) {
         type.setParent(this);
      }

      this.type = type;
   }

   public boolean isRef() {
      return this.ref;
   }

   public void setRef(boolean ref) {
      this.ref = ref;
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.type);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.expr, this.type);
   }

   public OracleTreatExpr clone() {
      OracleTreatExpr x = new OracleTreatExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      if (this.type != null) {
         x.setType(this.type.clone());
      }

      x.ref = this.ref;
      return x;
   }
}
