package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleXmlContentExpr extends SQLExprImpl {
   private SQLExpr value;
   private SQLExpr placeholder;
   private boolean wellformed;

   public boolean equals(Object o) {
      if (o == null) {
         return false;
      } else {
         return o == this;
      }
   }

   public int hashCode() {
      return this.value.hashCode();
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof OracleASTVisitor) {
         OracleASTVisitor visitor = (OracleASTVisitor)v;
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.value);
         }

         visitor.endVisit(this);
      }

   }

   public SQLExpr clone() {
      OracleXmlContentExpr expr = new OracleXmlContentExpr();
      expr.value = this.value.clone();
      expr.placeholder = this.placeholder.clone();
      return null;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public SQLExpr getPlaceholder() {
      return this.placeholder;
   }

   public void setPlaceholder(SQLExpr placeholder) {
      this.placeholder = placeholder;
   }

   public boolean isWellformed() {
      return this.wellformed;
   }

   public void setWellformed(boolean wellformed) {
      this.wellformed = wellformed;
   }
}
