package com.alibaba.druid.sql.dialect.postgresql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import java.util.Collections;
import java.util.List;

public class PGExtractExpr extends PGExprImpl implements SQLReplaceable {
   private PGDateField field;
   private SQLExpr source;

   public PGExtractExpr clone() {
      PGExtractExpr x = new PGExtractExpr();
      x.field = this.field;
      if (this.source != null) {
         x.setSource(this.source.clone());
      }

      return x;
   }

   public PGDateField getField() {
      return this.field;
   }

   public void setField(PGDateField field) {
      this.field = field;
   }

   public SQLExpr getSource() {
      return this.source;
   }

   public void setSource(SQLExpr source) {
      if (source != null) {
         source.setParent(this);
      }

      this.source = source;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.source == expr) {
         this.setSource(target);
         return true;
      } else {
         return false;
      }
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.source);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.source);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
      result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         PGExtractExpr other = (PGExtractExpr)obj;
         if (this.field != other.field) {
            return false;
         } else {
            if (this.source == null) {
               if (other.source != null) {
                  return false;
               }
            } else if (!this.source.equals(other.source)) {
               return false;
            }

            return true;
         }
      }
   }
}
