package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.Arrays;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SparkNullsExpr extends SparkSqlExprImpl {
   private SQLExpr expr;
   private boolean ignore;

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.expr);
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this) && this.expr != null) {
         this.expr.accept(v);
      }

      v.endVisit(this);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public boolean isIgnore() {
      return this.ignore;
   }

   public void setIgnore(boolean ignore) {
      this.ignore = ignore;
   }

   public SQLExpr clone() {
      SparkNullsExpr e = new SparkNullsExpr();
      e.expr = this.expr.clone();
      e.ignore = this.ignore;
      return e;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkNullsExpr that = (SparkNullsExpr)o;
         return this.ignore == that.ignore && Objects.equals(this.expr, that.expr);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.expr, this.ignore);
   }
}
