package com.alibaba.druid.sql.dialect.sqlserver.ast.stmt;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLServerSelectUnPivot extends SQLServerPivotBase {
   private NullsIncludeType nullsIncludeType;
   private final List<SQLExpr> items = new ArrayList();
   private final List<SQLServerSelectPivot.Item> pivotIn = new ArrayList();

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.pivotIn);
      }

      visitor.endVisit(this);
   }

   public List<SQLServerSelectPivot.Item> getPivotIn() {
      return this.pivotIn;
   }

   public List<SQLExpr> getItems() {
      return this.items;
   }

   public void addItem(SQLExpr item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public NullsIncludeType getNullsIncludeType() {
      return this.nullsIncludeType;
   }

   public void setNullsIncludeType(NullsIncludeType nullsIncludeType) {
      this.nullsIncludeType = nullsIncludeType;
   }

   public SQLServerSelectUnPivot clone() {
      SQLServerSelectUnPivot x = new SQLServerSelectUnPivot();
      x.setNullsIncludeType(this.nullsIncludeType);

      for(SQLExpr e : this.items) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.getItems().add(e2);
      }

      for(SQLExpr e : this.pivotFor) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.getPivotFor().add(e2);
      }

      for(SQLServerSelectPivot.Item e : this.pivotIn) {
         SQLServerSelectPivot.Item e2 = e.clone();
         e2.setParent(x);
         x.getPivotIn().add(e2);
      }

      return x;
   }

   public static enum NullsIncludeType {
      INCLUDE_NULLS,
      EXCLUDE_NULLS;

      public static String toString(NullsIncludeType type, boolean ucase) {
         if (INCLUDE_NULLS.equals(type)) {
            return ucase ? "INCLUDE NULLS" : "include nulls";
         } else if (EXCLUDE_NULLS.equals(type)) {
            return ucase ? "EXCLUDE NULLS" : "exclude nulls";
         } else {
            throw new IllegalArgumentException();
         }
      }
   }
}
