package com.alibaba.fastjson;

import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldTypeResolver;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;

public abstract class JSON implements JSONStreamAware, JSONAware {
   public static TimeZone defaultTimeZone = TimeZone.getDefault();
   public static Locale defaultLocale = Locale.getDefault();
   public static String DEFAULT_TYPE_KEY = "@type";
   static final SerializeFilter[] emptyFilters = new SerializeFilter[0];
   public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
   public static int DEFAULT_PARSER_FEATURE;
   public static int DEFAULT_GENERATE_FEATURE;
   private static final ConcurrentHashMap<Type, Type> mixInsMapper = new ConcurrentHashMap(16);
   private static final ThreadLocal<byte[]> bytesLocal;
   private static final ThreadLocal<char[]> charsLocal;
   public static final String VERSION = "1.2.84";

   private static void config(Properties properties) {
      String featuresProperty = properties.getProperty("fastjson.serializerFeatures.MapSortField");
      int mask = SerializerFeature.MapSortField.getMask();
      if ("true".equals(featuresProperty)) {
         DEFAULT_GENERATE_FEATURE |= mask;
      } else if ("false".equals(featuresProperty)) {
         DEFAULT_GENERATE_FEATURE &= ~mask;
      }

      if ("true".equals(properties.getProperty("parser.features.NonStringKeyAsString"))) {
         DEFAULT_PARSER_FEATURE |= Feature.NonStringKeyAsString.getMask();
      }

      if ("true".equals(properties.getProperty("parser.features.ErrorOnEnumNotMatch")) || "true".equals(properties.getProperty("fastjson.parser.features.ErrorOnEnumNotMatch"))) {
         DEFAULT_PARSER_FEATURE |= Feature.ErrorOnEnumNotMatch.getMask();
      }

      if ("false".equals(properties.getProperty("fastjson.asmEnable"))) {
         ParserConfig.global.setAsmEnable(false);
         SerializeConfig.globalInstance.setAsmEnable(false);
      }

   }

   public static void setDefaultTypeKey(String typeKey) {
      DEFAULT_TYPE_KEY = typeKey;
      ParserConfig.global.symbolTable.addSymbol(typeKey, 0, typeKey.length(), typeKey.hashCode(), true);
   }

   public static Object parse(String text) {
      return parse(text, DEFAULT_PARSER_FEATURE);
   }

   public static Object parse(String text, ParserConfig config) {
      return parse(text, config, DEFAULT_PARSER_FEATURE);
   }

   public static Object parse(String text, ParserConfig config, Feature... features) {
      int featureValues = DEFAULT_PARSER_FEATURE;

      for(Feature feature : features) {
         featureValues = Feature.config(featureValues, feature, true);
      }

      return parse(text, config, featureValues);
   }

   public static Object parse(String text, ParserConfig config, int features) {
      if (text == null) {
         return null;
      } else {
         DefaultJSONParser parser = new DefaultJSONParser(text, config, features);
         Object value = parser.parse();
         parser.handleResovleTask(value);
         parser.close();
         return value;
      }
   }

   public static Object parse(String text, int features) {
      return parse(text, ParserConfig.getGlobalInstance(), features);
   }

   public static Object parse(byte[] input, Feature... features) {
      char[] chars = allocateChars(input.length);
      int len = IOUtils.decodeUTF8(input, 0, input.length, chars);
      return len < 0 ? null : parse(new String(chars, 0, len), features);
   }

   public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature... features) {
      if (input != null && input.length != 0) {
         int featureValues = DEFAULT_PARSER_FEATURE;

         for(Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
         }

         return parse(input, off, len, charsetDecoder, featureValues);
      } else {
         return null;
      }
   }

   public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
      charsetDecoder.reset();
      int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
      char[] chars = allocateChars(scaleLength);
      ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
      CharBuffer charBuf = CharBuffer.wrap(chars);
      IOUtils.decode(charsetDecoder, byteBuf, charBuf);
      int position = charBuf.position();
      DefaultJSONParser parser = new DefaultJSONParser(chars, position, ParserConfig.getGlobalInstance(), features);
      Object value = parser.parse();
      parser.handleResovleTask(value);
      parser.close();
      return value;
   }

   public static Object parse(String text, Feature... features) {
      int featureValues = DEFAULT_PARSER_FEATURE;

      for(Feature feature : features) {
         featureValues = Feature.config(featureValues, feature, true);
      }

      return parse(text, featureValues);
   }

   public static JSONObject parseObject(String text, Feature... features) {
      return (JSONObject)parse(text, features);
   }

   public static JSONObject parseObject(String text) {
      Object obj = parse(text);
      if (obj instanceof JSONObject) {
         return (JSONObject)obj;
      } else {
         try {
            return (JSONObject)toJSON(obj);
         } catch (RuntimeException e) {
            throw new JSONException("can not cast to JSONObject.", e);
         }
      }
   }

   public static <T> T parseObject(String text, TypeReference<T> type, Feature... features) {
      return (T)parseObject(text, type.type, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String json, Class<T> clazz, Feature... features) {
      return (T)parseObject(json, clazz, ParserConfig.global, (ParseProcess)null, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String text, Class<T> clazz, ParseProcess processor, Feature... features) {
      return (T)parseObject(text, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String json, Type type, Feature... features) {
      return (T)parseObject(json, type, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String input, Type clazz, ParseProcess processor, Feature... features) {
      return (T)parseObject(input, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String input, Type clazz, int featureValues, Feature... features) {
      if (input == null) {
         return null;
      } else {
         for(Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
         }

         DefaultJSONParser parser = new DefaultJSONParser(input, ParserConfig.getGlobalInstance(), featureValues);
         T value = (T)parser.parseObject(clazz);
         parser.handleResovleTask(value);
         parser.close();
         return value;
      }
   }

   public static <T> T parseObject(String input, Type clazz, ParserConfig config, Feature... features) {
      return (T)parseObject(input, clazz, config, (ParseProcess)null, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(String input, Type clazz, ParserConfig config, int featureValues, Feature... features) {
      return (T)parseObject(input, clazz, config, (ParseProcess)null, featureValues, features);
   }

   public static <T> T parseObject(String input, Type clazz, ParserConfig config, ParseProcess processor, int featureValues, Feature... features) {
      if (input != null && input.length() != 0) {
         if (features != null) {
            for(Feature feature : features) {
               featureValues |= feature.mask;
            }
         }

         DefaultJSONParser parser = new DefaultJSONParser(input, config, featureValues);
         if (processor != null) {
            if (processor instanceof ExtraTypeProvider) {
               parser.getExtraTypeProviders().add((ExtraTypeProvider)processor);
            }

            if (processor instanceof ExtraProcessor) {
               parser.getExtraProcessors().add((ExtraProcessor)processor);
            }

            if (processor instanceof FieldTypeResolver) {
               parser.setFieldTypeResolver((FieldTypeResolver)processor);
            }
         }

         T value = (T)parser.parseObject((Type)clazz, null);
         parser.handleResovleTask(value);
         parser.close();
         return value;
      } else {
         return null;
      }
   }

   public static <T> T parseObject(byte[] bytes, Type clazz, Feature... features) {
      return (T)parseObject(bytes, 0, bytes.length, (Charset)IOUtils.UTF8, clazz, features);
   }

   public static <T> T parseObject(byte[] bytes, int offset, int len, Charset charset, Type clazz, Feature... features) {
      return (T)parseObject(bytes, offset, len, charset, clazz, ParserConfig.global, (ParseProcess)null, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(byte[] bytes, Charset charset, Type clazz, ParserConfig config, ParseProcess processor, int featureValues, Feature... features) {
      return (T)parseObject(bytes, 0, bytes.length, charset, clazz, config, processor, featureValues, features);
   }

   public static <T> T parseObject(byte[] bytes, int offset, int len, Charset charset, Type clazz, ParserConfig config, ParseProcess processor, int featureValues, Feature... features) {
      if (charset == null) {
         charset = IOUtils.UTF8;
      }

      String strVal = null;
      if (charset != IOUtils.UTF8) {
         if (len < 0) {
            return null;
         }

         strVal = new String(bytes, offset, len, charset);
      } else {
         char[] chars = allocateChars(bytes.length);
         int chars_len = IOUtils.decodeUTF8(bytes, offset, len, chars);
         if (chars_len < 0) {
            label102: {
               InputStreamReader gzipReader = null;

               Object var14;
               try {
                  gzipReader = new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(bytes, offset, len)), "UTF-8");
                  strVal = IOUtils.readAll(gzipReader);
                  break label102;
               } catch (Exception var18) {
                  var14 = null;
               } finally {
                  IOUtils.close(gzipReader);
               }

               return (T)var14;
            }
         }

         if (strVal == null && chars_len < 0) {
            return null;
         }

         if (strVal == null) {
            strVal = new String(chars, 0, chars_len);
         }
      }

      return (T)parseObject(strVal, clazz, config, processor, featureValues, features);
   }

   public static <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature... features) {
      charsetDecoder.reset();
      int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
      char[] chars = allocateChars(scaleLength);
      ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
      CharBuffer charByte = CharBuffer.wrap(chars);
      IOUtils.decode(charsetDecoder, byteBuf, charByte);
      int position = charByte.position();
      return (T)parseObject(chars, position, clazz, features);
   }

   public static <T> T parseObject(char[] input, int length, Type clazz, Feature... features) {
      if (input != null && input.length != 0) {
         int featureValues = DEFAULT_PARSER_FEATURE;

         for(Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
         }

         DefaultJSONParser parser = new DefaultJSONParser(input, length, ParserConfig.getGlobalInstance(), featureValues);
         T value = (T)parser.parseObject(clazz);
         parser.handleResovleTask(value);
         parser.close();
         return value;
      } else {
         return null;
      }
   }

   public static <T> T parseObject(InputStream is, Type type, Feature... features) throws IOException {
      return (T)parseObject(is, IOUtils.UTF8, type, features);
   }

   public static <T> T parseObject(InputStream is, Charset charset, Type type, Feature... features) throws IOException {
      return (T)parseObject(is, charset, type, ParserConfig.global, features);
   }

   public static <T> T parseObject(InputStream is, Charset charset, Type type, ParserConfig config, Feature... features) throws IOException {
      return (T)parseObject((InputStream)is, charset, type, config, (ParseProcess)null, DEFAULT_PARSER_FEATURE, features);
   }

   public static <T> T parseObject(InputStream is, Charset charset, Type type, ParserConfig config, ParseProcess processor, int featureValues, Feature... features) throws IOException {
      if (charset == null) {
         charset = IOUtils.UTF8;
      }

      byte[] bytes = allocateBytes(65536);
      int offset = 0;

      while(true) {
         int readCount = is.read(bytes, offset, bytes.length - offset);
         if (readCount == -1) {
            return (T)parseObject(bytes, 0, offset, charset, type, config, processor, featureValues, features);
         }

         offset += readCount;
         if (offset == bytes.length) {
            byte[] newBytes = new byte[bytes.length * 3 / 2];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            bytes = newBytes;
         }
      }
   }

   public static <T> T parseObject(String text, Class<T> clazz) {
      return (T)parseObject(text, clazz);
   }

   public static JSONArray parseArray(String text) {
      return parseArray(text, ParserConfig.global);
   }

   public static JSONArray parseArray(String text, ParserConfig parserConfig) {
      if (text == null) {
         return null;
      } else {
         DefaultJSONParser parser = new DefaultJSONParser(text, parserConfig);
         JSONLexer lexer = parser.lexer;
         JSONArray array;
         if (lexer.token() == 8) {
            lexer.nextToken();
            array = null;
         } else if (lexer.token() == 20 && lexer.isBlankInput()) {
            array = null;
         } else {
            array = new JSONArray();
            parser.parseArray(array);
            parser.handleResovleTask(array);
         }

         parser.close();
         return array;
      }
   }

   public static <T> List<T> parseArray(String text, Class<T> clazz) {
      return parseArray(text, clazz, ParserConfig.global);
   }

   public static <T> List<T> parseArray(String text, Class<T> clazz, ParserConfig config) {
      if (text == null) {
         return null;
      } else {
         DefaultJSONParser parser = new DefaultJSONParser(text, config);
         JSONLexer lexer = parser.lexer;
         int token = lexer.token();
         List<T> list;
         if (token == 8) {
            lexer.nextToken();
            list = null;
         } else if (token == 20 && lexer.isBlankInput()) {
            list = null;
         } else {
            list = new ArrayList();
            parser.parseArray(clazz, (Collection)list);
            parser.handleResovleTask(list);
         }

         parser.close();
         return list;
      }
   }

   public static List<Object> parseArray(String text, Type[] types) {
      return parseArray(text, types, ParserConfig.global);
   }

   public static List<Object> parseArray(String text, Type[] types, ParserConfig config) {
      if (text == null) {
         return null;
      } else {
         DefaultJSONParser parser = new DefaultJSONParser(text, config);
         Object[] objectArray = parser.parseArray(types);
         List<Object> list;
         if (objectArray == null) {
            list = null;
         } else {
            list = Arrays.asList(objectArray);
         }

         parser.handleResovleTask(list);
         parser.close();
         return list;
      }
   }

   public static String toJSONString(Object object) {
      return toJSONString(object, emptyFilters);
   }

   public static String toJSONString(Object object, SerializerFeature... features) {
      return toJSONString(object, DEFAULT_GENERATE_FEATURE, features);
   }

   public static String toJSONString(Object object, int defaultFeatures, SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter((Writer)null, defaultFeatures, features);

      String var7;
      try {
         JSONSerializer serializer = new JSONSerializer(out);
         serializer.write(object);
         String outString = out.toString();
         int len = outString.length();
         if (len <= 0 || outString.charAt(len - 1) != '.' || !(object instanceof Number) || out.isEnabled(SerializerFeature.WriteClassName)) {
            var7 = outString;
            return var7;
         }

         var7 = outString.substring(0, len - 1);
      } finally {
         out.close();
      }

      return var7;
   }

   public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature... features) {
      return toJSONString(object, SerializeConfig.globalInstance, (SerializeFilter[])null, dateFormat, DEFAULT_GENERATE_FEATURE, features);
   }

   public static String toJSONString(Object object, SerializeFilter filter, SerializerFeature... features) {
      return toJSONString(object, SerializeConfig.globalInstance, new SerializeFilter[]{filter}, null, DEFAULT_GENERATE_FEATURE, features);
   }

   public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature... features) {
      return toJSONString(object, SerializeConfig.globalInstance, filters, null, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, SerializerFeature... features) {
      return toJSONBytes(object, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeFilter filter, SerializerFeature... features) {
      return toJSONBytes(object, SerializeConfig.globalInstance, new SerializeFilter[]{filter}, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, int defaultFeatures, SerializerFeature... features) {
      return toJSONBytes(object, SerializeConfig.globalInstance, defaultFeatures, features);
   }

   public static String toJSONString(Object object, SerializeConfig config, SerializerFeature... features) {
      return toJSONString(object, config, (SerializeFilter)null, features);
   }

   public static String toJSONString(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature... features) {
      return toJSONString(object, config, new SerializeFilter[]{filter}, null, DEFAULT_GENERATE_FEATURE, features);
   }

   public static String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, SerializerFeature... features) {
      return toJSONString(object, config, filters, null, DEFAULT_GENERATE_FEATURE, features);
   }

   public static String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter((Writer)null, defaultFeatures, features);

      String var15;
      try {
         JSONSerializer serializer = new JSONSerializer(out, config);
         if (dateFormat != null && dateFormat.length() != 0) {
            serializer.setDateFormat(dateFormat);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
         }

         if (filters != null) {
            for(SerializeFilter filter : filters) {
               serializer.addFilter(filter);
            }
         }

         serializer.write(object);
         var15 = out.toString();
      } finally {
         out.close();
      }

      return var15;
   }

   /** @deprecated */
   public static String toJSONStringZ(Object object, SerializeConfig mapping, SerializerFeature... features) {
      return toJSONString(object, mapping, emptyFilters, null, 0, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializerFeature... features) {
      return toJSONBytes(object, config, emptyFilters, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeConfig config, int defaultFeatures, SerializerFeature... features) {
      return toJSONBytes(object, config, emptyFilters, defaultFeatures, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature... features) {
      return toJSONBytes(object, SerializeConfig.globalInstance, filters, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature... features) {
      return toJSONBytes(object, config, new SerializeFilter[]{filter}, DEFAULT_GENERATE_FEATURE, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter[] filters, int defaultFeatures, SerializerFeature... features) {
      return toJSONBytes(object, config, filters, null, defaultFeatures, features);
   }

   public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) {
      return toJSONBytes(IOUtils.UTF8, object, config, filters, dateFormat, defaultFeatures, features);
   }

   public static byte[] toJSONBytes(Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter((Writer)null, defaultFeatures, features);

      byte[] var16;
      try {
         JSONSerializer serializer = new JSONSerializer(out, config);
         if (dateFormat != null && dateFormat.length() != 0) {
            serializer.setDateFormat(dateFormat);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
         }

         if (filters != null) {
            for(SerializeFilter filter : filters) {
               serializer.addFilter(filter);
            }
         }

         serializer.write(object);
         var16 = out.toBytes(charset);
      } finally {
         out.close();
      }

      return var16;
   }

   public static byte[] toJSONBytesWithFastJsonConfig(Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter((Writer)null, defaultFeatures, features);

      byte[] var16;
      try {
         JSONSerializer serializer = new JSONSerializer(out, config);
         if (dateFormat != null && dateFormat.length() != 0) {
            serializer.setFastJsonConfigDateFormatPattern(dateFormat);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
         }

         if (filters != null) {
            for(SerializeFilter filter : filters) {
               serializer.addFilter(filter);
            }
         }

         serializer.write(object);
         var16 = out.toBytes(charset);
      } finally {
         out.close();
      }

      return var16;
   }

   public static String toJSONString(Object object, boolean prettyFormat) {
      return !prettyFormat ? toJSONString(object) : toJSONString(object, SerializerFeature.PrettyFormat);
   }

   /** @deprecated */
   public static void writeJSONStringTo(Object object, Writer writer, SerializerFeature... features) {
      writeJSONString(writer, object, features);
   }

   public static void writeJSONString(Writer writer, Object object, SerializerFeature... features) {
      writeJSONString(writer, object, DEFAULT_GENERATE_FEATURE, features);
   }

   public static void writeJSONString(Writer writer, Object object, int defaultFeatures, SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter(writer, defaultFeatures, features);

      try {
         JSONSerializer serializer = new JSONSerializer(out);
         serializer.write(object);
      } finally {
         out.close();
      }

   }

   public static final int writeJSONString(OutputStream os, Object object, SerializerFeature... features) throws IOException {
      return writeJSONString(os, object, DEFAULT_GENERATE_FEATURE, features);
   }

   public static final int writeJSONString(OutputStream os, Object object, int defaultFeatures, SerializerFeature... features) throws IOException {
      return writeJSONString(os, IOUtils.UTF8, object, SerializeConfig.globalInstance, (SerializeFilter[])null, null, defaultFeatures, features);
   }

   public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializerFeature... features) throws IOException {
      return writeJSONString(os, charset, object, SerializeConfig.globalInstance, (SerializeFilter[])null, null, DEFAULT_GENERATE_FEATURE, features);
   }

   public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) throws IOException {
      SerializeWriter writer = new SerializeWriter((Writer)null, defaultFeatures, features);

      int var18;
      try {
         JSONSerializer serializer = new JSONSerializer(writer, config);
         if (dateFormat != null && dateFormat.length() != 0) {
            serializer.setDateFormat(dateFormat);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
         }

         if (filters != null) {
            for(SerializeFilter filter : filters) {
               serializer.addFilter(filter);
            }
         }

         serializer.write(object);
         int len = writer.writeToEx(os, charset);
         var18 = len;
      } finally {
         writer.close();
      }

      return var18;
   }

   public static final int writeJSONStringWithFastJsonConfig(OutputStream os, Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature... features) throws IOException {
      SerializeWriter writer = new SerializeWriter((Writer)null, defaultFeatures, features);

      int var18;
      try {
         JSONSerializer serializer = new JSONSerializer(writer, config);
         if (dateFormat != null && dateFormat.length() != 0) {
            serializer.setFastJsonConfigDateFormatPattern(dateFormat);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
         }

         if (filters != null) {
            for(SerializeFilter filter : filters) {
               serializer.addFilter(filter);
            }
         }

         serializer.write(object);
         int len = writer.writeToEx(os, charset);
         var18 = len;
      } finally {
         writer.close();
      }

      return var18;
   }

   public String toString() {
      return this.toJSONString();
   }

   public String toJSONString() {
      SerializeWriter out = new SerializeWriter();

      String var2;
      try {
         (new JSONSerializer(out)).write((Object)this);
         var2 = out.toString();
      } finally {
         out.close();
      }

      return var2;
   }

   public String toString(SerializerFeature... features) {
      SerializeWriter out = new SerializeWriter((Writer)null, DEFAULT_GENERATE_FEATURE, features);

      String var3;
      try {
         (new JSONSerializer(out)).write((Object)this);
         var3 = out.toString();
      } finally {
         out.close();
      }

      return var3;
   }

   public void writeJSONString(Appendable appendable) {
      SerializeWriter out = new SerializeWriter();

      try {
         (new JSONSerializer(out)).write((Object)this);
         appendable.append(out.toString());
      } catch (IOException e) {
         throw new JSONException(e.getMessage(), e);
      } finally {
         out.close();
      }

   }

   public static Object toJSON(Object javaObject) {
      return toJSON(javaObject, SerializeConfig.globalInstance);
   }

   /** @deprecated */
   public static Object toJSON(Object javaObject, ParserConfig parserConfig) {
      return toJSON(javaObject, SerializeConfig.globalInstance);
   }

   public static Object toJSON(Object javaObject, SerializeConfig config) {
      if (javaObject == null) {
         return null;
      } else if (javaObject instanceof JSON) {
         return javaObject;
      } else if (javaObject instanceof Map) {
         Map<Object, Object> map = (Map)javaObject;
         int size = map.size();
         Map innerMap;
         if (map instanceof LinkedHashMap) {
            innerMap = new LinkedHashMap(size);
         } else if (map instanceof TreeMap) {
            innerMap = new TreeMap();
         } else {
            innerMap = new HashMap(size);
         }

         JSONObject json = new JSONObject(innerMap);

         for(Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            String jsonKey = TypeUtils.castToString(key);
            Object jsonValue = toJSON(entry.getValue(), config);
            json.put(jsonKey, jsonValue);
         }

         return json;
      } else if (javaObject instanceof Collection) {
         Collection<Object> collection = (Collection)javaObject;
         JSONArray array = new JSONArray(collection.size());

         for(Object item : collection) {
            Object jsonValue = toJSON(item, config);
            array.add(jsonValue);
         }

         return array;
      } else if (javaObject instanceof JSONSerializable) {
         String json = toJSONString(javaObject);
         return parse(json);
      } else {
         Class<?> clazz = javaObject.getClass();
         if (clazz.isEnum()) {
            return ((Enum)javaObject).name();
         } else if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);

            for(int i = 0; i < len; ++i) {
               Object item = Array.get(javaObject, i);
               Object jsonValue = toJSON(item);
               array.add(jsonValue);
            }

            return array;
         } else if (ParserConfig.isPrimitive2(clazz)) {
            return javaObject;
         } else {
            ObjectSerializer serializer = config.getObjectWriter(clazz);
            if (!(serializer instanceof JavaBeanSerializer)) {
               String text = toJSONString(javaObject, config);
               return parse(text);
            } else {
               JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
               JSONType jsonType = javaBeanSerializer.getJSONType();
               boolean ordered = false;
               if (jsonType != null) {
                  for(SerializerFeature serializerFeature : jsonType.serialzeFeatures()) {
                     if (serializerFeature == SerializerFeature.SortField || serializerFeature == SerializerFeature.MapSortField) {
                        ordered = true;
                     }
                  }
               }

               JSONObject json = new JSONObject(ordered);

               try {
                  Map<String, Object> values = javaBeanSerializer.getFieldValuesMap(javaObject);

                  for(Map.Entry<String, Object> entry : values.entrySet()) {
                     json.put((String)entry.getKey(), toJSON(entry.getValue(), config));
                  }

                  return json;
               } catch (Exception e) {
                  throw new JSONException("toJSON error", e);
               }
            }
         }
      }
   }

   public static <T> T toJavaObject(JSON json, Class<T> clazz) {
      return (T)TypeUtils.cast(json, clazz, ParserConfig.getGlobalInstance());
   }

   public <T> T toJavaObject(Class<T> clazz) {
      return (T)(clazz != JSONArray.class && clazz != JSON.class && clazz != Collection.class && clazz != List.class ? TypeUtils.cast(this, clazz, ParserConfig.getGlobalInstance()) : this);
   }

   public <T> T toJavaObject(Type type) {
      return (T)TypeUtils.cast(this, type, ParserConfig.getGlobalInstance());
   }

   public <T> T toJavaObject(TypeReference typeReference) {
      Type type = typeReference != null ? typeReference.getType() : null;
      return (T)TypeUtils.cast(this, type, ParserConfig.getGlobalInstance());
   }

   private static byte[] allocateBytes(int length) {
      byte[] chars = (byte[])bytesLocal.get();
      if (chars == null) {
         if (length <= 65536) {
            chars = new byte[65536];
            bytesLocal.set(chars);
         } else {
            chars = new byte[length];
         }
      } else if (chars.length < length) {
         chars = new byte[length];
      }

      return chars;
   }

   private static char[] allocateChars(int length) {
      char[] chars = (char[])charsLocal.get();
      if (chars == null) {
         if (length <= 65536) {
            chars = new char[65536];
            charsLocal.set(chars);
         } else {
            chars = new char[length];
         }
      } else if (chars.length < length) {
         chars = new char[length];
      }

      return chars;
   }

   /** @deprecated */
   public static boolean isValid(String str) {
      if (str != null && str.length() != 0) {
         JSONScanner lexer = new JSONScanner(str);

         try {
            lexer.nextToken();
            int token = lexer.token();
            switch (token) {
               case 2:
               case 3:
               case 4:
               case 5:
               case 6:
               case 7:
               case 8:
                  lexer.nextToken();
                  break;
               case 9:
               case 10:
               case 11:
               case 13:
               default:
                  boolean var11 = false;
                  return var11;
               case 12:
                  if (lexer.getCurrent() == 26) {
                     boolean var9 = false;
                     return var9;
                  }

                  lexer.skipObject(true);
                  break;
               case 14:
                  lexer.skipArray(true);
            }

            boolean var10 = lexer.token() == 20;
            return var10;
         } catch (Exception var7) {
            boolean var3 = false;
            return var3;
         } finally {
            lexer.close();
         }
      } else {
         return false;
      }
   }

   /** @deprecated */
   public static boolean isValidObject(String str) {
      if (str != null && str.length() != 0) {
         JSONScanner lexer = new JSONScanner(str);

         boolean var9;
         try {
            lexer.nextToken();
            int token = lexer.token();
            if (token != 12) {
               var9 = false;
               return var9;
            }

            if (lexer.getCurrent() != 26) {
               lexer.skipObject(true);
               var9 = lexer.token() == 20;
               return var9;
            }

            var9 = false;
         } catch (Exception var7) {
            var9 = false;
            return var9;
         } finally {
            lexer.close();
         }

         return var9;
      } else {
         return false;
      }
   }

   /** @deprecated */
   public static boolean isValidArray(String str) {
      if (str != null && str.length() != 0) {
         JSONScanner lexer = new JSONScanner(str);

         boolean var9;
         try {
            lexer.nextToken();
            int token = lexer.token();
            if (token != 14) {
               var9 = false;
               return var9;
            }

            lexer.skipArray(true);
            var9 = lexer.token() == 20;
         } catch (Exception var7) {
            var9 = false;
            return var9;
         } finally {
            lexer.close();
         }

         return var9;
      } else {
         return false;
      }
   }

   public static <T> void handleResovleTask(DefaultJSONParser parser, T value) {
      parser.handleResovleTask(value);
   }

   public static void addMixInAnnotations(Type target, Type mixinSource) {
      if (target != null && mixinSource != null) {
         mixInsMapper.put(target, mixinSource);
      }

   }

   public static void removeMixInAnnotations(Type target) {
      if (target != null) {
         mixInsMapper.remove(target);
      }

   }

   public static void clearMixInAnnotations() {
      mixInsMapper.clear();
   }

   public static Type getMixInAnnotations(Type target) {
      return target != null ? (Type)mixInsMapper.get(target) : null;
   }

   static {
      int features = 0;
      features |= Feature.AutoCloseSource.getMask();
      features |= Feature.InternFieldNames.getMask();
      features |= Feature.UseBigDecimal.getMask();
      features |= Feature.AllowUnQuotedFieldNames.getMask();
      features |= Feature.AllowSingleQuotes.getMask();
      features |= Feature.AllowArbitraryCommas.getMask();
      features |= Feature.SortFeidFastMatch.getMask();
      features |= Feature.IgnoreNotMatch.getMask();
      DEFAULT_PARSER_FEATURE = features;
      features = 0;
      features |= SerializerFeature.QuoteFieldNames.getMask();
      features |= SerializerFeature.SkipTransientField.getMask();
      features |= SerializerFeature.WriteEnumUsingName.getMask();
      features |= SerializerFeature.SortField.getMask();
      DEFAULT_GENERATE_FEATURE = features;
      config(IOUtils.DEFAULT_PROPERTIES);
      bytesLocal = new ThreadLocal();
      charsLocal = new ThreadLocal();
   }
}
