package com.alibaba.fastjson;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;

public class JSONArray extends JSON implements List<Object>, Cloneable, RandomAccess, Serializable {
   private static final long serialVersionUID = 1L;
   private final List<Object> list;
   protected transient Object relatedArray;
   protected transient Type componentType;

   public JSONArray() {
      this.list = new ArrayList();
   }

   public JSONArray(List<Object> list) {
      if (list == null) {
         throw new IllegalArgumentException("list is null.");
      } else {
         this.list = list;
      }
   }

   public JSONArray(int initialCapacity) {
      this.list = new ArrayList(initialCapacity);
   }

   public Object getRelatedArray() {
      return this.relatedArray;
   }

   public void setRelatedArray(Object relatedArray) {
      this.relatedArray = relatedArray;
   }

   public Type getComponentType() {
      return this.componentType;
   }

   public void setComponentType(Type componentType) {
      this.componentType = componentType;
   }

   public int size() {
      return this.list.size();
   }

   public boolean isEmpty() {
      return this.list.isEmpty();
   }

   public boolean contains(Object o) {
      return this.list.contains(o);
   }

   public Iterator<Object> iterator() {
      return this.list.iterator();
   }

   public Object[] toArray() {
      return this.list.toArray();
   }

   public <T> T[] toArray(T[] a) {
      return (T[])this.list.toArray(a);
   }

   public boolean add(Object e) {
      return this.list.add(e);
   }

   public JSONArray fluentAdd(Object e) {
      this.list.add(e);
      return this;
   }

   public boolean remove(Object o) {
      return this.list.remove(o);
   }

   public JSONArray fluentRemove(Object o) {
      this.list.remove(o);
      return this;
   }

   public boolean containsAll(Collection<?> c) {
      return this.list.containsAll(c);
   }

   public boolean addAll(Collection<?> c) {
      return this.list.addAll(c);
   }

   public JSONArray fluentAddAll(Collection<?> c) {
      this.list.addAll(c);
      return this;
   }

   public boolean addAll(int index, Collection<?> c) {
      return this.list.addAll(index, c);
   }

   public JSONArray fluentAddAll(int index, Collection<?> c) {
      this.list.addAll(index, c);
      return this;
   }

   public boolean removeAll(Collection<?> c) {
      return this.list.removeAll(c);
   }

   public JSONArray fluentRemoveAll(Collection<?> c) {
      this.list.removeAll(c);
      return this;
   }

   public boolean retainAll(Collection<?> c) {
      return this.list.retainAll(c);
   }

   public JSONArray fluentRetainAll(Collection<?> c) {
      this.list.retainAll(c);
      return this;
   }

   public void clear() {
      this.list.clear();
   }

   public JSONArray fluentClear() {
      this.list.clear();
      return this;
   }

   public Object set(int index, Object element) {
      if (index == -1) {
         this.list.add(element);
         return null;
      } else if (this.list.size() > index) {
         return this.list.set(index, element);
      } else {
         for(int i = this.list.size(); i < index; ++i) {
            this.list.add(null);
         }

         this.list.add(element);
         return null;
      }
   }

   public JSONArray fluentSet(int index, Object element) {
      this.set(index, element);
      return this;
   }

   public void add(int index, Object element) {
      this.list.add(index, element);
   }

   public JSONArray fluentAdd(int index, Object element) {
      this.list.add(index, element);
      return this;
   }

   public Object remove(int index) {
      return this.list.remove(index);
   }

   public JSONArray fluentRemove(int index) {
      this.list.remove(index);
      return this;
   }

   public int indexOf(Object o) {
      return this.list.indexOf(o);
   }

   public int lastIndexOf(Object o) {
      return this.list.lastIndexOf(o);
   }

   public ListIterator<Object> listIterator() {
      return this.list.listIterator();
   }

   public ListIterator<Object> listIterator(int index) {
      return this.list.listIterator(index);
   }

   public List<Object> subList(int fromIndex, int toIndex) {
      return this.list.subList(fromIndex, toIndex);
   }

   public Object get(int index) {
      return this.list.get(index);
   }

   public JSONObject getJSONObject(int index) {
      Object value = this.list.get(index);
      if (value instanceof JSONObject) {
         return (JSONObject)value;
      } else {
         return value instanceof Map ? new JSONObject((Map)value) : (JSONObject)toJSON(value);
      }
   }

   public JSONArray getJSONArray(int index) {
      Object value = this.list.get(index);
      if (value instanceof JSONArray) {
         return (JSONArray)value;
      } else {
         return value instanceof List ? new JSONArray((List)value) : (JSONArray)toJSON(value);
      }
   }

   public <T> T getObject(int index, Class<T> clazz) {
      Object obj = this.list.get(index);
      return (T)TypeUtils.castToJavaBean(obj, clazz);
   }

   public <T> T getObject(int index, Type type) {
      Object obj = this.list.get(index);
      if (type instanceof Class) {
         return (T)TypeUtils.castToJavaBean(obj, (Class)type);
      } else {
         String json = JSON.toJSONString(obj);
         return (T)JSON.parseObject(json, type);
      }
   }

   public Boolean getBoolean(int index) {
      Object value = this.get(index);
      return value == null ? null : TypeUtils.castToBoolean(value);
   }

   public boolean getBooleanValue(int index) {
      Object value = this.get(index);
      return value == null ? false : TypeUtils.castToBoolean(value);
   }

   public Byte getByte(int index) {
      Object value = this.get(index);
      return TypeUtils.castToByte(value);
   }

   public byte getByteValue(int index) {
      Object value = this.get(index);
      Byte byteVal = TypeUtils.castToByte(value);
      return byteVal == null ? 0 : byteVal;
   }

   public Short getShort(int index) {
      Object value = this.get(index);
      return TypeUtils.castToShort(value);
   }

   public short getShortValue(int index) {
      Object value = this.get(index);
      Short shortVal = TypeUtils.castToShort(value);
      return shortVal == null ? 0 : shortVal;
   }

   public Integer getInteger(int index) {
      Object value = this.get(index);
      return TypeUtils.castToInt(value);
   }

   public int getIntValue(int index) {
      Object value = this.get(index);
      Integer intVal = TypeUtils.castToInt(value);
      return intVal == null ? 0 : intVal;
   }

   public Long getLong(int index) {
      Object value = this.get(index);
      return TypeUtils.castToLong(value);
   }

   public long getLongValue(int index) {
      Object value = this.get(index);
      Long longVal = TypeUtils.castToLong(value);
      return longVal == null ? 0L : longVal;
   }

   public Float getFloat(int index) {
      Object value = this.get(index);
      return TypeUtils.castToFloat(value);
   }

   public float getFloatValue(int index) {
      Object value = this.get(index);
      Float floatValue = TypeUtils.castToFloat(value);
      return floatValue == null ? 0.0F : floatValue;
   }

   public Double getDouble(int index) {
      Object value = this.get(index);
      return TypeUtils.castToDouble(value);
   }

   public double getDoubleValue(int index) {
      Object value = this.get(index);
      Double doubleValue = TypeUtils.castToDouble(value);
      return doubleValue == null ? (double)0.0F : doubleValue;
   }

   public BigDecimal getBigDecimal(int index) {
      Object value = this.get(index);
      return TypeUtils.castToBigDecimal(value);
   }

   public BigInteger getBigInteger(int index) {
      Object value = this.get(index);
      return TypeUtils.castToBigInteger(value);
   }

   public String getString(int index) {
      Object value = this.get(index);
      return TypeUtils.castToString(value);
   }

   public Date getDate(int index) {
      Object value = this.get(index);
      return TypeUtils.castToDate(value);
   }

   public Object getSqlDate(int index) {
      Object value = this.get(index);
      return TypeUtils.castToSqlDate(value);
   }

   public Object getTimestamp(int index) {
      Object value = this.get(index);
      return TypeUtils.castToTimestamp(value);
   }

   public <T> List<T> toJavaList(Class<T> clazz) {
      List<T> list = new ArrayList(this.size());
      ParserConfig config = ParserConfig.getGlobalInstance();

      for(Object item : this) {
         T classItem = (T)TypeUtils.cast(item, clazz, config);
         list.add(classItem);
      }

      return list;
   }

   public Object clone() {
      return new JSONArray(new ArrayList(this.list));
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else {
         return obj instanceof JSONArray ? this.list.equals(((JSONArray)obj).list) : this.list.equals(obj);
      }
   }

   public int hashCode() {
      return this.list.hashCode();
   }
}
