package com.alibaba.fastjson;

public enum PropertyNamingStrategy {
   CamelCase,
   PascalCase,
   SnakeCase,
   KebabCase,
   NoChange,
   NeverUseThisValueExceptDefaultValue;

   public String translate(String propertyName) {
      switch (this) {
         case SnakeCase:
            StringBuilder buf = new StringBuilder();
            int i = 0;

            for(; i < propertyName.length(); ++i) {
               char ch = propertyName.charAt(i);
               if (ch >= 'A' && ch <= 'Z') {
                  char ch_ucase = (char)(ch + 32);
                  if (i > 0) {
                     buf.append('_');
                  }

                  buf.append(ch_ucase);
               } else {
                  buf.append(ch);
               }
            }

            return buf.toString();
         case KebabCase:
            StringBuilder buf2 = new StringBuilder();

            for(int i2 = 0; i2 < propertyName.length(); ++i2) {
               char ch = propertyName.charAt(i2);
               if (ch >= 'A' && ch <= 'Z') {
                  char ch_ucase = (char)(ch + 32);
                  if (i2 > 0) {
                     buf2.append('-');
                  }

                  buf2.append(ch_ucase);
               } else {
                  buf2.append(ch);
               }
            }

            return buf2.toString();
         case PascalCase:
            char ch = propertyName.charAt(0);
            if (ch >= 'a' && ch <= 'z') {
               char[] chars = propertyName.toCharArray();
               chars[0] = (char)(chars[0] - 32);
               return new String(chars);
            }

            return propertyName;
         case CamelCase:
            char ch2 = propertyName.charAt(0);
            if (ch2 >= 'A' && ch2 <= 'Z') {
               char[] chars = propertyName.toCharArray();
               chars[0] = (char)(chars[0] + 32);
               return new String(chars);
            }

            return propertyName;
         case NoChange:
         case NeverUseThisValueExceptDefaultValue:
         default:
            return propertyName;
      }
   }
}
