package com.alibaba.fastjson.annotation;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
public @interface JSONField {
   int ordinal() default 0;

   String name() default "";

   String format() default "";

   boolean serialize() default true;

   boolean deserialize() default true;

   SerializerFeature[] serialzeFeatures() default {};

   Feature[] parseFeatures() default {};

   String label() default "";

   boolean jsonDirect() default false;

   Class<?> serializeUsing() default Void.class;

   Class<?> deserializeUsing() default Void.class;

   String[] alternateNames() default {};

   boolean unwrapped() default false;

   String defaultValue() default "";
}
