package com.alibaba.fastjson.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
   public final byte[] b;
   private final int[] items;
   private final String[] strings;
   private final int maxStringLength;
   public final int header;
   private boolean readAnnotations;

   public ClassReader(InputStream is, boolean readAnnotations) throws IOException {
      this.readAnnotations = readAnnotations;
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      byte[] buf = new byte[1024];

      while(true) {
         int len = is.read(buf);
         if (len == -1) {
            is.close();
            this.b = out.toByteArray();
            this.items = new int[this.readUnsignedShort(8)];
            int n = this.items.length;
            this.strings = new String[n];
            int max = 0;
            len = 10;

            for(int i = 1; i < n; ++i) {
               this.items[i] = len + 1;
               int size;
               switch (this.b[len]) {
                  case 1:
                     size = 3 + this.readUnsignedShort(len + 1);
                     if (size > max) {
                        max = size;
                     }
                     break;
                  case 2:
                  case 7:
                  case 8:
                  case 13:
                  case 14:
                  case 16:
                  case 17:
                  default:
                     size = 3;
                     break;
                  case 3:
                  case 4:
                  case 9:
                  case 10:
                  case 11:
                  case 12:
                  case 18:
                     size = 5;
                     break;
                  case 5:
                  case 6:
                     size = 9;
                     ++i;
                     break;
                  case 15:
                     size = 4;
               }

               len += size;
            }

            this.maxStringLength = max;
            this.header = len;
            return;
         }

         if (len > 0) {
            out.write(buf, 0, len);
         }
      }
   }

   public void accept(TypeCollector classVisitor) {
      char[] c = new char[this.maxStringLength];
      int anns = 0;
      if (this.readAnnotations) {
         int u = this.getAttributes();

         for(int i = this.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.readUTF8(u + 2, c);
            if ("RuntimeVisibleAnnotations".equals(attrName)) {
               anns = u + 8;
               break;
            }

            u += 6 + this.readInt(u + 4);
         }
      }

      int u = this.header;
      int len = this.readUnsignedShort(u + 6);
      u += 8;

      for(int i = 0; i < len; ++i) {
         u += 2;
      }

      int var11 = this.readUnsignedShort(u);

      int v;
      for(v = u + 2; var11 > 0; --var11) {
         int j = this.readUnsignedShort(v + 6);

         for(v += 8; j > 0; --j) {
            v += 6 + this.readInt(v + 2);
         }
      }

      var11 = this.readUnsignedShort(v);

      for(v += 2; var11 > 0; --var11) {
         int j = this.readUnsignedShort(v + 6);

         for(v += 8; j > 0; --j) {
            v += 6 + this.readInt(v + 2);
         }
      }

      var11 = this.readUnsignedShort(v);

      for(int var24 = v + 2; var11 > 0; --var11) {
         var24 += 6 + this.readInt(var24 + 2);
      }

      if (anns != 0) {
         var11 = this.readUnsignedShort(anns);

         for(int var25 = anns + 2; var11 > 0; --var11) {
            String name = this.readUTF8(var25, c);
            classVisitor.visitAnnotation(name);
         }
      }

      var11 = this.readUnsignedShort(u);

      for(u += 2; var11 > 0; --var11) {
         int j = this.readUnsignedShort(u + 6);

         for(u += 8; j > 0; --j) {
            u += 6 + this.readInt(u + 2);
         }
      }

      var11 = this.readUnsignedShort(u);

      for(int v2 = u + 2; var11 > 0; --var11) {
         v2 = this.readMethod(classVisitor, c, v2);
      }

   }

   private int getAttributes() {
      int u = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;

      for(int i = this.readUnsignedShort(u); i > 0; --i) {
         for(int j = this.readUnsignedShort(u + 8); j > 0; --j) {
            u += 6 + this.readInt(u + 12);
         }

         u += 8;
      }

      u += 2;

      for(int i = this.readUnsignedShort(u); i > 0; --i) {
         for(int j = this.readUnsignedShort(u + 8); j > 0; --j) {
            u += 6 + this.readInt(u + 12);
         }

         u += 8;
      }

      return u + 2;
   }

   private int readMethod(TypeCollector classVisitor, char[] c, int u) {
      int access = this.readUnsignedShort(u);
      String name = this.readUTF8(u + 2, c);
      String desc = this.readUTF8(u + 4, c);
      int v = 0;
      int w = 0;
      int j = this.readUnsignedShort(u + 6);

      for(u += 8; j > 0; --j) {
         String attrName = this.readUTF8(u, c);
         int attrSize = this.readInt(u + 2);
         u += 6;
         if (attrName.equals("Code")) {
            v = u;
         }

         u += attrSize;
      }

      if (w != 0) {
         w += 2;

         for(int var27 = 0; var27 < this.readUnsignedShort(w); ++var27) {
            w += 2;
         }
      }

      MethodCollector mv = classVisitor.visitMethod(access, name, desc);
      if (mv != null && v != 0) {
         int codeLength = this.readInt(v + 4);
         v += 8;
         int codeEnd = v + codeLength;
         j = this.readUnsignedShort(codeEnd);

         for(v = codeEnd + 2; j > 0; --j) {
            v += 8;
         }

         int varTable = 0;
         int varTypeTable = 0;
         j = this.readUnsignedShort(v);

         for(int var23 = v + 2; j > 0; --j) {
            String attrName = this.readUTF8(var23, c);
            if (attrName.equals("LocalVariableTable")) {
               varTable = var23 + 6;
            } else if (attrName.equals("LocalVariableTypeTable")) {
               varTypeTable = var23 + 6;
            }

            var23 += 6 + this.readInt(var23 + 2);
         }

         if (varTable != 0) {
            if (varTypeTable != 0) {
               int k = this.readUnsignedShort(varTypeTable) * 3;
               w = varTypeTable + 2;

               for(int[] typeTable = new int[k]; k > 0; w += 10) {
                  --k;
                  typeTable[k] = w + 6;
                  --k;
                  typeTable[k] = this.readUnsignedShort(w + 8);
                  --k;
                  typeTable[k] = this.readUnsignedShort(w);
               }
            }

            int k = this.readUnsignedShort(varTable);

            for(int var26 = varTable + 2; k > 0; --k) {
               int index = this.readUnsignedShort(var26 + 8);
               mv.visitLocalVariable(this.readUTF8(var26 + 4, c), index);
               var26 += 10;
            }
         }
      }

      return u;
   }

   private int readUnsignedShort(int index) {
      byte[] b = this.b;
      return (b[index] & 255) << 8 | b[index + 1] & 255;
   }

   private int readInt(int index) {
      byte[] b = this.b;
      return (b[index] & 255) << 24 | (b[index + 1] & 255) << 16 | (b[index + 2] & 255) << 8 | b[index + 3] & 255;
   }

   private String readUTF8(int index, char[] buf) {
      int item = this.readUnsignedShort(index);
      String s = this.strings[item];
      if (s != null) {
         return s;
      } else {
         index = this.items[item];
         return this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
      }
   }

   private String readUTF(int index, int utfLen, char[] buf) {
      int endIndex = index + utfLen;
      byte[] b = this.b;
      int strLen = 0;
      int st = 0;
      char cc = 0;

      while(index < endIndex) {
         int c = b[index++];
         switch (st) {
            case 0:
               c &= 255;
               if (c < 128) {
                  buf[strLen++] = (char)c;
               } else {
                  if (c < 224 && c > 191) {
                     cc = (char)(c & 31);
                     st = 1;
                     continue;
                  }

                  cc = (char)(c & 15);
                  st = 2;
               }
               break;
            case 1:
               buf[strLen++] = (char)(cc << 6 | c & 63);
               st = 0;
               break;
            case 2:
               cc = (char)(cc << 6 | c & 63);
               st = 1;
         }
      }

      return new String(buf, 0, strLen);
   }
}
