package com.alibaba.fastjson.asm;

public class Label {
   int status;
   int position;
   private int referenceCount;
   private int[] srcAndRefPositions;
   static final int FORWARD_REFERENCE_TYPE_MASK = -268435456;
   static final int FORWARD_REFERENCE_HANDLE_MASK = 268435455;
   static final int FORWARD_REFERENCE_TYPE_SHORT = 268435456;
   static final int FORWARD_REFERENCE_TYPE_WIDE = 536870912;
   int inputStackTop;
   int outputStackMax;
   Label successor;
   Label next;

   void put(MethodWriter owner, ByteVector out, int source, boolean wideOffset) {
      if ((this.status & 2) == 0) {
         if (wideOffset) {
            this.addReference(source, out.length, 536870912);
            out.putInt(-1);
         } else {
            this.addReference(source, out.length, 268435456);
            out.putShort(-1);
         }
      } else if (wideOffset) {
         out.putInt(this.position - source);
      } else {
         out.putShort(this.position - source);
      }

   }

   private void addReference(int sourcePosition, int referencePosition, int referenceType) {
      if (this.srcAndRefPositions == null) {
         this.srcAndRefPositions = new int[6];
      }

      if (this.referenceCount >= this.srcAndRefPositions.length) {
         int[] a = new int[this.srcAndRefPositions.length + 6];
         System.arraycopy(this.srcAndRefPositions, 0, a, 0, this.srcAndRefPositions.length);
         this.srcAndRefPositions = a;
      }

      this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
      this.srcAndRefPositions[this.referenceCount++] = referencePosition | referenceType;
   }

   void resolve(MethodWriter owner, int position, byte[] data) {
      this.status |= 2;
      this.position = position;
      int i = 0;

      while(i < this.referenceCount) {
         int source = this.srcAndRefPositions[i++];
         int reference = this.srcAndRefPositions[i++];
         int handle = reference & 268435455;
         int offset = position - source;
         if ((reference & -268435456) == 268435456) {
            data[handle++] = (byte)(offset >>> 8);
            data[handle] = (byte)offset;
         } else {
            data[handle++] = (byte)(offset >>> 24);
            data[handle++] = (byte)(offset >>> 16);
            data[handle++] = (byte)(offset >>> 8);
            data[handle] = (byte)offset;
         }
      }

   }
}
