package com.alibaba.fastjson.asm;

public class Type {
   public static final Type VOID_TYPE = new Type(0, (char[])null, 1443168256, 1);
   public static final Type BOOLEAN_TYPE = new Type(1, (char[])null, 1509950721, 1);
   public static final Type CHAR_TYPE = new Type(2, (char[])null, 1124075009, 1);
   public static final Type BYTE_TYPE = new Type(3, (char[])null, 1107297537, 1);
   public static final Type SHORT_TYPE = new Type(4, (char[])null, 1392510721, 1);
   public static final Type INT_TYPE = new Type(5, (char[])null, 1224736769, 1);
   public static final Type FLOAT_TYPE = new Type(6, (char[])null, 1174536705, 1);
   public static final Type LONG_TYPE = new Type(7, (char[])null, 1241579778, 1);
   public static final Type DOUBLE_TYPE = new Type(8, (char[])null, 1141048066, 1);
   protected final int sort;
   private final char[] buf;
   private final int off;
   private final int len;

   private Type(int sort, char[] buf, int off, int len) {
      this.sort = sort;
      this.buf = buf;
      this.off = off;
      this.len = len;
   }

   public static Type getType(String typeDescriptor) {
      return getType(typeDescriptor.toCharArray(), 0);
   }

   public static int getArgumentsAndReturnSizes(String desc) {
      int n = 1;
      int c = 1;

      while(true) {
         char car = desc.charAt(c++);
         if (car == ')') {
            car = desc.charAt(c);
            return n << 2 | (car == 'V' ? 0 : (car != 'D' && car != 'J' ? 1 : 2));
         }

         if (car == 'L') {
            while(desc.charAt(c++) != ';') {
            }

            ++n;
         } else if (car != 'D' && car != 'J') {
            ++n;
         } else {
            n += 2;
         }
      }
   }

   private static Type getType(char[] buf, int off) {
      switch (buf[off]) {
         case 'B':
            return BYTE_TYPE;
         case 'C':
            return CHAR_TYPE;
         case 'D':
            return DOUBLE_TYPE;
         case 'E':
         case 'G':
         case 'H':
         case 'K':
         case 'L':
         case 'M':
         case 'N':
         case 'O':
         case 'P':
         case 'Q':
         case 'R':
         case 'T':
         case 'U':
         case 'W':
         case 'X':
         case 'Y':
         default:
            int len2;
            for(len2 = 1; buf[off + len2] != ';'; ++len2) {
            }

            return new Type(10, buf, off + 1, len2 - 1);
         case 'F':
            return FLOAT_TYPE;
         case 'I':
            return INT_TYPE;
         case 'J':
            return LONG_TYPE;
         case 'S':
            return SHORT_TYPE;
         case 'V':
            return VOID_TYPE;
         case 'Z':
            return BOOLEAN_TYPE;
         case '[':
            int len;
            for(len = 1; buf[off + len] == '['; ++len) {
            }

            if (buf[off + len] == 'L') {
               ++len;

               while(buf[off + len] != ';') {
                  ++len;
               }
            }

            return new Type(9, buf, off, len + 1);
      }
   }

   public String getInternalName() {
      return new String(this.buf, this.off, this.len);
   }

   String getDescriptor() {
      return new String(this.buf, this.off, this.len);
   }

   private int getDimensions() {
      int i;
      for(i = 1; this.buf[this.off + i] == '['; ++i) {
      }

      return i;
   }

   static Type[] getArgumentTypes(String methodDescriptor) {
      char[] buf = methodDescriptor.toCharArray();
      int off = 1;
      int size = 0;

      while(true) {
         char car = buf[off++];
         if (car == ')') {
            Type[] args = new Type[size];
            off = 1;

            for(int var6 = 0; buf[off] != ')'; ++var6) {
               args[var6] = getType(buf, off);
               off += args[var6].len + (args[var6].sort == 10 ? 2 : 0);
            }

            return args;
         }

         if (car == 'L') {
            while(buf[off++] != ';') {
            }

            ++size;
         } else if (car != '[') {
            ++size;
         }
      }
   }

   protected String getClassName() {
      switch (this.sort) {
         case 0:
            return "void";
         case 1:
            return "boolean";
         case 2:
            return "char";
         case 3:
            return "byte";
         case 4:
            return "short";
         case 5:
            return "int";
         case 6:
            return "float";
         case 7:
            return "long";
         case 8:
            return "double";
         case 9:
            Type elementType = getType(this.buf, this.off + this.getDimensions());
            StringBuilder b = new StringBuilder(elementType.getClassName());

            for(int i = this.getDimensions(); i > 0; --i) {
               b.append("[]");
            }

            return b.toString();
         default:
            return (new String(this.buf, this.off, this.len)).replace('/', '.');
      }
   }
}
