package com.alibaba.fastjson.asm;

import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.util.ASMUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class TypeCollector {
   private static String JSONType = ASMUtils.desc(JSONType.class);
   private static final Map<String, String> primitives = new HashMap<String, String>() {
      {
         this.put("int", "I");
         this.put("boolean", "Z");
         this.put("byte", "B");
         this.put("char", "C");
         this.put("short", "S");
         this.put("float", "F");
         this.put("long", "J");
         this.put("double", "D");
      }
   };
   private final String methodName;
   private final Class<?>[] parameterTypes;
   protected MethodCollector collector;
   protected boolean jsonType;

   public TypeCollector(String methodName, Class<?>[] parameterTypes) {
      this.methodName = methodName;
      this.parameterTypes = parameterTypes;
      this.collector = null;
   }

   protected MethodCollector visitMethod(int access, String name, String desc) {
      if (this.collector != null) {
         return null;
      } else if (!name.equals(this.methodName)) {
         return null;
      } else {
         Type[] argTypes = Type.getArgumentTypes(desc);
         int longOrDoubleQuantity = 0;

         for(Type t : argTypes) {
            String className = t.getClassName();
            if (className.equals("long") || className.equals("double")) {
               ++longOrDoubleQuantity;
            }
         }

         if (argTypes.length != this.parameterTypes.length) {
            return null;
         } else {
            for(int i = 0; i < argTypes.length; ++i) {
               if (!this.correctTypeName(argTypes[i], this.parameterTypes[i].getName())) {
                  return null;
               }
            }

            return this.collector = new MethodCollector(Modifier.isStatic(access) ? 0 : 1, argTypes.length + longOrDoubleQuantity);
         }
      }
   }

   public void visitAnnotation(String desc) {
      if (JSONType.equals(desc)) {
         this.jsonType = true;
      }

   }

   private boolean correctTypeName(Type type, String paramTypeName) {
      String s = type.getClassName();

      StringBuilder braces;
      for(braces = new StringBuilder(); s.endsWith("[]"); s = s.substring(0, s.length() - 2)) {
         braces.append('[');
      }

      if (braces.length() != 0) {
         if (primitives.containsKey(s)) {
            s = braces.append((String)primitives.get(s)).toString();
         } else {
            s = braces.append('L').append(s).append(';').toString();
         }
      }

      return s.equals(paramTypeName);
   }

   public String[] getParameterNamesForMethod() {
      return this.collector != null && this.collector.debugInfoPresent ? this.collector.getResult().split(",") : new String[0];
   }

   public boolean matched() {
      return this.collector != null;
   }

   public boolean hasJsonType() {
      return this.jsonType;
   }
}
