package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.JSONPathException;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessable;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldTypeResolver;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.PropertyProcessable;
import com.alibaba.fastjson.parser.deserializer.ResolveFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.LongCodec;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultJSONParser implements Closeable {
   public final Object input;
   public final SymbolTable symbolTable;
   protected ParserConfig config;
   private static final Set<Class<?>> primitiveClasses = new HashSet();
   private String dateFormatPattern;
   private DateFormat dateFormat;
   public final JSONLexer lexer;
   protected ParseContext context;
   private ParseContext[] contextArray;
   private int contextArrayIndex;
   private List<ResolveTask> resolveTaskList;
   public static final int NONE = 0;
   public static final int NeedToResolve = 1;
   public static final int TypeNameRedirect = 2;
   public int resolveStatus;
   private List<ExtraTypeProvider> extraTypeProviders;
   private List<ExtraProcessor> extraProcessors;
   protected FieldTypeResolver fieldTypeResolver;
   private int objectKeyLevel;
   private boolean autoTypeEnable;
   private String[] autoTypeAccept;
   protected transient BeanContext lastBeanContext;

   public String getDateFomartPattern() {
      return this.dateFormatPattern;
   }

   public DateFormat getDateFormat() {
      if (this.dateFormat == null) {
         this.dateFormat = new SimpleDateFormat(this.dateFormatPattern, this.lexer.getLocale());
         this.dateFormat.setTimeZone(this.lexer.getTimeZone());
      }

      return this.dateFormat;
   }

   public void setDateFormat(String dateFormat) {
      this.dateFormatPattern = dateFormat;
      this.dateFormat = null;
   }

   /** @deprecated */
   public void setDateFomrat(DateFormat dateFormat) {
      this.setDateFormat(dateFormat);
   }

   public void setDateFormat(DateFormat dateFormat) {
      this.dateFormat = dateFormat;
   }

   public DefaultJSONParser(String input) {
      this(input, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
   }

   public DefaultJSONParser(String input, ParserConfig config) {
      this(input, new JSONScanner(input, JSON.DEFAULT_PARSER_FEATURE), config);
   }

   public DefaultJSONParser(String input, ParserConfig config, int features) {
      this(input, new JSONScanner(input, features), config);
   }

   public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
      this(input, new JSONScanner(input, length, features), config);
   }

   public DefaultJSONParser(JSONLexer lexer) {
      this(lexer, ParserConfig.getGlobalInstance());
   }

   public DefaultJSONParser(JSONLexer lexer, ParserConfig config) {
      this(null, lexer, config);
   }

   public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
      this.dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
      this.contextArrayIndex = 0;
      this.resolveStatus = 0;
      this.extraTypeProviders = null;
      this.extraProcessors = null;
      this.fieldTypeResolver = null;
      this.objectKeyLevel = 0;
      this.autoTypeAccept = null;
      this.lexer = lexer;
      this.input = input;
      this.config = config;
      this.symbolTable = config.symbolTable;
      int ch = lexer.getCurrent();
      if (ch == 123) {
         lexer.next();
         ((JSONLexerBase)lexer).token = 12;
      } else if (ch == 91) {
         lexer.next();
         ((JSONLexerBase)lexer).token = 14;
      } else {
         lexer.nextToken();
      }

   }

   public SymbolTable getSymbolTable() {
      return this.symbolTable;
   }

   public String getInput() {
      return this.input instanceof char[] ? new String((char[])this.input) : this.input.toString();
   }

   public final Object parseObject(Map object, Object fieldName) {
      JSONLexer lexer = this.lexer;
      if (lexer.token() == 8) {
         lexer.nextToken();
         return null;
      } else if (lexer.token() == 13) {
         lexer.nextToken();
         return object;
      } else if (lexer.token() == 4 && lexer.stringVal().length() == 0) {
         lexer.nextToken();
         return object;
      } else if (lexer.token() != 12 && lexer.token() != 16) {
         throw new JSONException("syntax error, expect {, actual " + lexer.tokenName() + ", " + lexer.info());
      } else {
         ParseContext context = this.context;

         try {
            boolean isJsonObjectMap = object instanceof JSONObject;
            Map map = isJsonObjectMap ? ((JSONObject)object).getInnerMap() : object;
            boolean setContextFlag = false;

            while(true) {
               lexer.skipWhitespace();
               char ch = lexer.getCurrent();
               if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                  while(ch == ',') {
                     lexer.next();
                     lexer.skipWhitespace();
                     ch = lexer.getCurrent();
                  }
               }

               boolean isObjectKey = false;
               Object key;
               if (ch == '"') {
                  key = lexer.scanSymbol(this.symbolTable, '"');
                  lexer.skipWhitespace();
                  ch = lexer.getCurrent();
                  if (ch != ':') {
                     throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                  }
               } else {
                  if (ch == '}') {
                     lexer.next();
                     lexer.resetStringPosition();
                     lexer.nextToken();
                     if (!setContextFlag) {
                        if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                           context = this.context;
                        } else {
                           ParseContext contextR = this.setContext(object, fieldName);
                           if (context == null) {
                              context = contextR;
                           }

                           setContextFlag = true;
                        }
                     }

                     Map var40 = object;
                     return var40;
                  }

                  if (ch == '\'') {
                     if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                     }

                     key = lexer.scanSymbol(this.symbolTable, '\'');
                     lexer.skipWhitespace();
                     ch = lexer.getCurrent();
                     if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                     }
                  } else {
                     if (ch == 26) {
                        throw new JSONException("syntax error");
                     }

                     if (ch == ',') {
                        throw new JSONException("syntax error");
                     }

                     if ((ch < '0' || ch > '9') && ch != '-') {
                        if (ch != '{' && ch != '[') {
                           if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                              throw new JSONException("syntax error");
                           }

                           key = lexer.scanSymbolUnQuoted(this.symbolTable);
                           lexer.skipWhitespace();
                           ch = lexer.getCurrent();
                           if (ch != ':') {
                              throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                           }
                        } else {
                           if (this.objectKeyLevel++ > 512) {
                              throw new JSONException("object key level > 512");
                           }

                           lexer.nextToken();
                           key = this.parse();
                           isObjectKey = true;
                        }
                     } else {
                        lexer.resetStringPosition();
                        lexer.scanNumber();

                        try {
                           if (lexer.token() == 2) {
                              key = lexer.integerValue();
                           } else {
                              key = lexer.decimalValue(true);
                           }

                           if (lexer.isEnabled(Feature.NonStringKeyAsString) || isJsonObjectMap) {
                              key = key.toString();
                           }
                        } catch (NumberFormatException var25) {
                           throw new JSONException("parse number key error" + lexer.info());
                        }

                        ch = lexer.getCurrent();
                        if (ch != ':') {
                           throw new JSONException("parse number key error" + lexer.info());
                        }
                     }
                  }
               }

               if (!isObjectKey) {
                  lexer.next();
                  lexer.skipWhitespace();
               }

               ch = lexer.getCurrent();
               lexer.resetStringPosition();
               if (key == JSON.DEFAULT_TYPE_KEY && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                  String typeName = lexer.scanSymbol(this.symbolTable, '"');
                  if (!lexer.isEnabled(Feature.IgnoreAutoType)) {
                     Class<?> clazz = null;
                     if (object != null && object.getClass().getName().equals(typeName)) {
                        clazz = object.getClass();
                     } else if ("java.util.HashMap".equals(typeName)) {
                        clazz = HashMap.class;
                     } else if ("java.util.LinkedHashMap".equals(typeName)) {
                        clazz = LinkedHashMap.class;
                     } else {
                        boolean allDigits = true;
                        int i = 0;

                        while(true) {
                           if (i < typeName.length()) {
                              char c = typeName.charAt(i);
                              if (c >= '0' && c <= '9') {
                                 ++i;
                                 continue;
                              }

                              allDigits = false;
                           }

                           if (!allDigits) {
                              clazz = this.config.checkAutoType(typeName, (Class)null, lexer.getFeatures());
                           }
                           break;
                        }
                     }

                     if (clazz != null) {
                        lexer.nextToken(16);
                        if (lexer.token() == 13) {
                           lexer.nextToken(16);

                           try {
                              Object instance = null;
                              ObjectDeserializer deserializer = this.config.getDeserializer((Type)clazz);
                              if (deserializer instanceof JavaBeanDeserializer) {
                                 instance = TypeUtils.cast(object, clazz, this.config);
                              }

                              if (instance == null) {
                                 if (clazz == Cloneable.class) {
                                    instance = new HashMap();
                                 } else if ("java.util.Collections$EmptyMap".equals(typeName)) {
                                    instance = Collections.emptyMap();
                                 } else if ("java.util.Collections$UnmodifiableMap".equals(typeName)) {
                                    instance = Collections.unmodifiableMap(new HashMap());
                                 } else {
                                    instance = clazz.newInstance();
                                 }
                              }

                              Object var65 = instance;
                              return var65;
                           } catch (Exception e) {
                              throw new JSONException("create instance error", e);
                           }
                        }

                        this.setResolveStatus(2);
                        if (this.context != null && fieldName != null && !(fieldName instanceof Integer) && !(this.context.fieldName instanceof Integer)) {
                           this.popContext();
                        }

                        if (object.size() > 0) {
                           Object newObj = TypeUtils.cast(object, clazz, this.config);
                           this.setResolveStatus(0);
                           this.parseObject(newObj);
                           Object var61 = newObj;
                           return var61;
                        }

                        ObjectDeserializer deserializer = this.config.getDeserializer((Type)clazz);
                        Class deserClass = deserializer.getClass();
                        if (JavaBeanDeserializer.class.isAssignableFrom(deserClass) && deserClass != JavaBeanDeserializer.class && deserClass != ThrowableDeserializer.class) {
                           this.setResolveStatus(0);
                        } else if (deserializer instanceof MapDeserializer) {
                           this.setResolveStatus(0);
                        }

                        Object obj = deserializer.deserialze(this, clazz, fieldName);
                        Object var66 = obj;
                        return var66;
                     }

                     map.put(JSON.DEFAULT_TYPE_KEY, typeName);
                  }
               } else if (key == "$ref" && context != null && (object == null || object.size() == 0) && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                  lexer.nextToken(4);
                  if (lexer.token() != 4) {
                     throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                  }

                  String ref = lexer.stringVal();
                  lexer.nextToken(13);
                  if (lexer.token() != 16) {
                     Object refValue = null;
                     if ("@".equals(ref)) {
                        if (this.context != null) {
                           ParseContext thisContext = this.context;
                           Object thisObj = thisContext.object;
                           if (!(thisObj instanceof Object[]) && !(thisObj instanceof Collection)) {
                              if (thisContext.parent != null) {
                                 refValue = thisContext.parent.object;
                              }
                           } else {
                              refValue = thisObj;
                           }
                        }
                     } else if ("..".equals(ref)) {
                        if (context.object != null) {
                           refValue = context.object;
                        } else {
                           this.addResolveTask(new ResolveTask(context, ref));
                           this.setResolveStatus(1);
                        }
                     } else if ("$".equals(ref)) {
                        ParseContext rootContext;
                        for(rootContext = context; rootContext.parent != null; rootContext = rootContext.parent) {
                        }

                        if (rootContext.object != null) {
                           refValue = rootContext.object;
                        } else {
                           this.addResolveTask(new ResolveTask(rootContext, ref));
                           this.setResolveStatus(1);
                        }
                     } else {
                        JSONPath jsonpath = JSONPath.compile(ref);
                        if (jsonpath.isRef()) {
                           this.addResolveTask(new ResolveTask(context, ref));
                           this.setResolveStatus(1);
                        } else {
                           refValue = (new JSONObject()).fluentPut("$ref", ref);
                        }
                     }

                     if (lexer.token() != 13) {
                        throw new JSONException("syntax error, " + lexer.info());
                     }

                     lexer.nextToken(16);
                     Object input = refValue;
                     return input;
                  }

                  map.put(key, ref);
               } else {
                  if (!setContextFlag) {
                     if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                        context = this.context;
                     } else {
                        ParseContext contextR = this.setContext(object, fieldName);
                        if (context == null) {
                           context = contextR;
                        }

                        setContextFlag = true;
                     }
                  }

                  if (object.getClass() == JSONObject.class && key == null) {
                     key = "null";
                  }

                  Object value;
                  if (ch == '"') {
                     lexer.scanString();
                     String strValue = lexer.stringVal();
                     value = strValue;
                     if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                        JSONScanner iso8601Lexer = new JSONScanner(strValue);
                        if (iso8601Lexer.scanISO8601DateIfMatch()) {
                           value = iso8601Lexer.getCalendar().getTime();
                        }

                        iso8601Lexer.close();
                     }

                     map.put(key, value);
                  } else {
                     if ((ch < '0' || ch > '9') && ch != '-') {
                        if (ch == '[') {
                           lexer.nextToken();
                           JSONArray list = new JSONArray();
                           if (fieldName != null && fieldName.getClass() == Integer.class) {
                              boolean var68 = true;
                           } else {
                              boolean var10000 = false;
                           }

                           if (fieldName == null) {
                              this.setContext(context);
                           }

                           this.parseArray(list, (Object)key);
                           if (lexer.isEnabled(Feature.UseObjectArray)) {
                              value = list.toArray();
                           } else {
                              value = list;
                           }

                           map.put(key, value);
                           if (lexer.token() == 13) {
                              lexer.nextToken();
                              Map mapDeserializer = object;
                              return mapDeserializer;
                           }

                           if (lexer.token() != 16) {
                              throw new JSONException("syntax error");
                           }
                           continue;
                        }

                        if (ch != '{') {
                           lexer.nextToken();
                           value = this.parse();
                           map.put(key, value);
                           if (lexer.token() == 13) {
                              lexer.nextToken();
                              Map list = object;
                              return list;
                           }

                           if (lexer.token() != 16) {
                              throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                           }
                           continue;
                        }

                        lexer.nextToken();
                        boolean parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                        Map input;
                        if (lexer.isEnabled(Feature.CustomMapDeserializer)) {
                           MapDeserializer mapDeserializer = (MapDeserializer)this.config.getDeserializer((Type)Map.class);
                           input = (lexer.getFeatures() & Feature.OrderedField.mask) != 0 ? mapDeserializer.createMap(Map.class, lexer.getFeatures()) : mapDeserializer.createMap(Map.class);
                        } else {
                           input = new JSONObject(lexer.isEnabled(Feature.OrderedField));
                        }

                        ParseContext ctxLocal = null;
                        if (!parentIsArray) {
                           ctxLocal = this.setContext(this.context, input, key);
                        }

                        Object obj = null;
                        boolean objParsed = false;
                        if (this.fieldTypeResolver != null) {
                           String resolveFieldName = key != null ? key.toString() : null;
                           Type fieldType = this.fieldTypeResolver.resolve(object, resolveFieldName);
                           if (fieldType != null) {
                              ObjectDeserializer fieldDeser = this.config.getDeserializer(fieldType);
                              obj = fieldDeser.deserialze(this, fieldType, key);
                              objParsed = true;
                           }
                        }

                        if (!objParsed) {
                           obj = this.parseObject(input, key);
                        }

                        if (ctxLocal != null && input != obj) {
                           ctxLocal.object = object;
                        }

                        if (key != null) {
                           this.checkMapResolve(object, key.toString());
                        }

                        map.put(key, obj);
                        if (parentIsArray) {
                           this.setContext(obj, key);
                        }

                        if (lexer.token() == 13) {
                           lexer.nextToken();
                           this.setContext(context);
                           Map var67 = object;
                           return var67;
                        }

                        if (lexer.token() != 16) {
                           throw new JSONException("syntax error, " + lexer.tokenName());
                        }

                        if (parentIsArray) {
                           this.popContext();
                        } else {
                           this.setContext(context);
                        }
                        continue;
                     }

                     lexer.scanNumber();
                     if (lexer.token() == 2) {
                        value = lexer.integerValue();
                     } else {
                        value = lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                     }

                     map.put(key, value);
                  }

                  lexer.skipWhitespace();
                  ch = lexer.getCurrent();
                  if (ch != ',') {
                     if (ch != '}') {
                        throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                     }

                     lexer.next();
                     lexer.resetStringPosition();
                     lexer.nextToken();
                     this.setContext(value, key);
                     Map refValue = object;
                     return refValue;
                  }

                  lexer.next();
               }
            }
         } finally {
            this.setContext(context);
         }
      }
   }

   public ParserConfig getConfig() {
      return this.config;
   }

   public void setConfig(ParserConfig config) {
      this.config = config;
   }

   public <T> T parseObject(Class<T> clazz) {
      return (T)this.parseObject((Type)clazz, null);
   }

   public <T> T parseObject(Type type) {
      return (T)this.parseObject((Type)type, null);
   }

   public <T> T parseObject(Type type, Object fieldName) {
      int token = this.lexer.token();
      if (token == 8) {
         this.lexer.nextToken();
         return (T)TypeUtils.optionalEmpty(type);
      } else {
         if (token == 4) {
            if (type == byte[].class) {
               byte[] bytes = this.lexer.bytesValue();
               this.lexer.nextToken();
               return (T)bytes;
            }

            if (type == char[].class) {
               String strVal = this.lexer.stringVal();
               this.lexer.nextToken();
               return (T)strVal.toCharArray();
            }
         }

         ObjectDeserializer deserializer = this.config.getDeserializer(type);

         try {
            if (deserializer.getClass() == JavaBeanDeserializer.class) {
               if (this.lexer.token() != 12 && this.lexer.token() != 14) {
                  throw new JSONException("syntax error,expect start with { or [,but actually start with " + this.lexer.tokenName());
               } else {
                  return (T)((JavaBeanDeserializer)deserializer).deserialze(this, type, fieldName, 0);
               }
            } else {
               return (T)deserializer.deserialze(this, type, fieldName);
            }
         } catch (JSONException e) {
            throw e;
         } catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
         }
      }
   }

   public <T> List<T> parseArray(Class<T> clazz) {
      List<T> array = new ArrayList();
      this.parseArray(clazz, (Collection)array);
      return array;
   }

   public void parseArray(Class<?> clazz, Collection array) {
      this.parseArray(clazz, (Collection)array);
   }

   public void parseArray(Type type, Collection array) {
      this.parseArray(type, array, null);
   }

   public void parseArray(Type type, Collection array, Object fieldName) {
      int token = this.lexer.token();
      if (token == 21 || token == 22) {
         this.lexer.nextToken();
         token = this.lexer.token();
      }

      if (token != 14) {
         throw new JSONException("field " + fieldName + " expect '[', but " + JSONToken.name(token) + ", " + this.lexer.info());
      } else {
         ObjectDeserializer deserializer = null;
         if (Integer.TYPE == type) {
            deserializer = IntegerCodec.instance;
            this.lexer.nextToken(2);
         } else if (String.class == type) {
            deserializer = StringCodec.instance;
            this.lexer.nextToken(4);
         } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
         }

         ParseContext context = this.context;
         this.setContext(array, fieldName);

         try {
            int i = 0;

            while(true) {
               if (this.lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                  while(this.lexer.token() == 16) {
                     this.lexer.nextToken();
                  }
               }

               if (this.lexer.token() == 15) {
                  break;
               }

               if (Integer.TYPE == type) {
                  Object val = IntegerCodec.instance.deserialze(this, (Type)null, null);
                  array.add(val);
               } else if (String.class == type) {
                  String value;
                  if (this.lexer.token() == 4) {
                     value = this.lexer.stringVal();
                     this.lexer.nextToken(16);
                  } else {
                     Object obj = this.parse();
                     if (obj == null) {
                        value = null;
                     } else {
                        value = obj.toString();
                     }
                  }

                  array.add(value);
               } else {
                  Object val;
                  if (this.lexer.token() == 8) {
                     this.lexer.nextToken();
                     val = null;
                  } else {
                     val = deserializer.deserialze(this, type, i);
                  }

                  array.add(val);
                  this.checkListResolve(array);
               }

               if (this.lexer.token() == 16) {
                  this.lexer.nextToken(deserializer.getFastMatchToken());
               }

               ++i;
            }
         } finally {
            this.setContext(context);
         }

         this.lexer.nextToken(16);
      }
   }

   public Object[] parseArray(Type[] types) {
      if (this.lexer.token() == 8) {
         this.lexer.nextToken(16);
         return null;
      } else if (this.lexer.token() != 14) {
         throw new JSONException("syntax error : " + this.lexer.tokenName());
      } else {
         Object[] list = new Object[types.length];
         if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token() != 15) {
               throw new JSONException("syntax error");
            } else {
               this.lexer.nextToken(16);
               return new Object[0];
            }
         } else {
            this.lexer.nextToken(2);

            for(int i = 0; i < types.length; ++i) {
               Object value;
               if (this.lexer.token() == 8) {
                  value = null;
                  this.lexer.nextToken(16);
               } else {
                  Type type = types[i];
                  if (type != Integer.TYPE && type != Integer.class) {
                     if (type == String.class) {
                        if (this.lexer.token() == 4) {
                           value = this.lexer.stringVal();
                           this.lexer.nextToken(16);
                        } else {
                           value = this.parse();
                           value = TypeUtils.cast(value, type, this.config);
                        }
                     } else {
                        boolean isArray = false;
                        Class<?> componentType = null;
                        if (i == types.length - 1 && type instanceof Class) {
                           Class<?> clazz = (Class)type;
                           if (clazz != byte[].class && clazz != char[].class || this.lexer.token() != 4) {
                              isArray = clazz.isArray();
                              componentType = clazz.getComponentType();
                           }
                        }

                        if (isArray && this.lexer.token() != 14) {
                           List<Object> varList = new ArrayList();
                           ObjectDeserializer deserializer = this.config.getDeserializer((Type)componentType);
                           int fastMatch = deserializer.getFastMatchToken();
                           if (this.lexer.token() != 15) {
                              while(true) {
                                 Object item = deserializer.deserialze(this, type, null);
                                 varList.add(item);
                                 if (this.lexer.token() != 16) {
                                    if (this.lexer.token() != 15) {
                                       throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
                                    }
                                    break;
                                 }

                                 this.lexer.nextToken(fastMatch);
                              }
                           }

                           value = TypeUtils.cast(varList, type, this.config);
                        } else {
                           ObjectDeserializer deserializer = this.config.getDeserializer(type);
                           value = deserializer.deserialze(this, type, i);
                        }
                     }
                  } else if (this.lexer.token() == 2) {
                     value = this.lexer.intValue();
                     this.lexer.nextToken(16);
                  } else {
                     value = this.parse();
                     value = TypeUtils.cast(value, type, this.config);
                  }
               }

               list[i] = value;
               if (this.lexer.token() == 15) {
                  break;
               }

               if (this.lexer.token() != 16) {
                  throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
               }

               if (i == types.length - 1) {
                  this.lexer.nextToken(15);
               } else {
                  this.lexer.nextToken(2);
               }
            }

            if (this.lexer.token() != 15) {
               throw new JSONException("syntax error");
            } else {
               this.lexer.nextToken(16);
               return list;
            }
         }
      }
   }

   public void parseObject(Object object) {
      Class<?> clazz = object.getClass();
      JavaBeanDeserializer beanDeser = null;
      ObjectDeserializer deserializer = this.config.getDeserializer((Type)clazz);
      if (deserializer instanceof JavaBeanDeserializer) {
         beanDeser = (JavaBeanDeserializer)deserializer;
      }

      if (this.lexer.token() != 12 && this.lexer.token() != 16) {
         throw new JSONException("syntax error, expect {, actual " + this.lexer.tokenName());
      } else {
         while(true) {
            String key;
            do {
               key = this.lexer.scanSymbol(this.symbolTable);
               if (key != null) {
                  break;
               }

               if (this.lexer.token() == 13) {
                  this.lexer.nextToken(16);
                  return;
               }
            } while(this.lexer.token() == 16 && this.lexer.isEnabled(Feature.AllowArbitraryCommas));

            FieldDeserializer fieldDeser = null;
            if (beanDeser != null) {
               fieldDeser = beanDeser.getFieldDeserializer(key);
            }

            if (fieldDeser == null) {
               if (!this.lexer.isEnabled(Feature.IgnoreNotMatch)) {
                  throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
               }

               this.lexer.nextTokenWithColon();
               this.parse();
               if (this.lexer.token() == 13) {
                  this.lexer.nextToken();
                  return;
               }
            } else {
               Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
               Type fieldType = fieldDeser.fieldInfo.fieldType;
               Object fieldValue;
               if (fieldClass == Integer.TYPE) {
                  this.lexer.nextTokenWithColon(2);
                  fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
               } else if (fieldClass == String.class) {
                  this.lexer.nextTokenWithColon(4);
                  fieldValue = StringCodec.deserialze(this);
               } else if (fieldClass == Long.TYPE) {
                  this.lexer.nextTokenWithColon(2);
                  fieldValue = LongCodec.instance.deserialze(this, fieldType, null);
               } else {
                  ObjectDeserializer fieldValueDeserializer = this.config.getDeserializer(fieldClass, fieldType);
                  this.lexer.nextTokenWithColon(fieldValueDeserializer.getFastMatchToken());
                  fieldValue = fieldValueDeserializer.deserialze(this, fieldType, null);
               }

               fieldDeser.setValue(object, fieldValue);
               if (this.lexer.token() != 16 && this.lexer.token() == 13) {
                  this.lexer.nextToken(16);
                  return;
               }
            }
         }
      }
   }

   public Object parseArrayWithType(Type collectionType) {
      if (this.lexer.token() == 8) {
         this.lexer.nextToken();
         return null;
      } else {
         Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
         if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
         } else {
            Type actualTypeArgument = actualTypes[0];
            if (actualTypeArgument instanceof Class) {
               List<Object> array = new ArrayList();
               this.parseArray((Class)actualTypeArgument, (Collection)array);
               return array;
            } else if (actualTypeArgument instanceof WildcardType) {
               WildcardType wildcardType = (WildcardType)actualTypeArgument;
               Type upperBoundType = wildcardType.getUpperBounds()[0];
               if (Object.class.equals(upperBoundType)) {
                  if (wildcardType.getLowerBounds().length == 0) {
                     return this.parse();
                  } else {
                     throw new JSONException("not support type : " + collectionType);
                  }
               } else {
                  List<Object> array = new ArrayList();
                  this.parseArray((Class)upperBoundType, (Collection)array);
                  return array;
               }
            } else {
               if (actualTypeArgument instanceof TypeVariable) {
                  TypeVariable<?> typeVariable = (TypeVariable)actualTypeArgument;
                  Type[] bounds = typeVariable.getBounds();
                  if (bounds.length != 1) {
                     throw new JSONException("not support : " + typeVariable);
                  }

                  Type boundType = bounds[0];
                  if (boundType instanceof Class) {
                     List<Object> array = new ArrayList();
                     this.parseArray((Class)boundType, (Collection)array);
                     return array;
                  }
               }

               if (actualTypeArgument instanceof ParameterizedType) {
                  ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
                  List<Object> array = new ArrayList();
                  this.parseArray(parameterizedType, (Collection)array);
                  return array;
               } else {
                  throw new JSONException("TODO : " + collectionType);
               }
            }
         }
      }
   }

   public void acceptType(String typeName) {
      JSONLexer lexer = this.lexer;
      lexer.nextTokenWithColon();
      if (lexer.token() != 4) {
         throw new JSONException("type not match error");
      } else if (typeName.equals(lexer.stringVal())) {
         lexer.nextToken();
         if (lexer.token() == 16) {
            lexer.nextToken();
         }

      } else {
         throw new JSONException("type not match error");
      }
   }

   public int getResolveStatus() {
      return this.resolveStatus;
   }

   public void setResolveStatus(int resolveStatus) {
      this.resolveStatus = resolveStatus;
   }

   public Object getObject(String path) {
      for(int i = 0; i < this.contextArrayIndex; ++i) {
         if (path.equals(this.contextArray[i].toString())) {
            return this.contextArray[i].object;
         }
      }

      return null;
   }

   public void checkListResolve(Collection array) {
      if (this.resolveStatus == 1) {
         if (array instanceof List) {
            int index = array.size() - 1;
            List list = (List)array;
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = new ResolveFieldDeserializer(this, list, index);
            task.ownerContext = this.context;
            this.setResolveStatus(0);
         } else {
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = new ResolveFieldDeserializer(array);
            task.ownerContext = this.context;
            this.setResolveStatus(0);
         }
      }

   }

   public void checkMapResolve(Map object, Object fieldName) {
      if (this.resolveStatus == 1) {
         ResolveFieldDeserializer fieldResolver = new ResolveFieldDeserializer(object, fieldName);
         ResolveTask task = this.getLastResolveTask();
         task.fieldDeserializer = fieldResolver;
         task.ownerContext = this.context;
         this.setResolveStatus(0);
      }

   }

   public Object parseObject(Map object) {
      return this.parseObject((Map)object, null);
   }

   public JSONObject parseObject() {
      JSONObject object = new JSONObject(this.lexer.isEnabled(Feature.OrderedField));
      Object parsedObject = this.parseObject(object);
      if (parsedObject instanceof JSONObject) {
         return (JSONObject)parsedObject;
      } else {
         return parsedObject == null ? null : new JSONObject((Map)parsedObject);
      }
   }

   public final void parseArray(Collection array) {
      this.parseArray(array, null);
   }

   public final void parseArray(Collection array, Object fieldName) {
      JSONLexer lexer = this.lexer;
      if (lexer.token() == 21 || lexer.token() == 22) {
         lexer.nextToken();
      }

      if (lexer.token() != 14) {
         throw new JSONException("syntax error, expect [, actual " + JSONToken.name(lexer.token()) + ", pos " + lexer.pos() + ", fieldName " + fieldName);
      } else {
         lexer.nextToken(4);
         if (this.context != null && this.context.level > 512) {
            throw new JSONException("array level > 512");
         } else {
            ParseContext context = this.context;
            this.setContext(array, fieldName);

            try {
               int i = 0;

               while(true) {
                  if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                     while(lexer.token() == 16) {
                        lexer.nextToken();
                     }
                  }

                  Object value;
                  switch (lexer.token()) {
                     case 2:
                        value = lexer.integerValue();
                        lexer.nextToken(16);
                        break;
                     case 3:
                        if (lexer.isEnabled(Feature.UseBigDecimal)) {
                           value = lexer.decimalValue(true);
                        } else {
                           value = lexer.decimalValue(false);
                        }

                        lexer.nextToken(16);
                        break;
                     case 4:
                        String stringLiteral = lexer.stringVal();
                        lexer.nextToken(16);
                        if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                           JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);
                           if (iso8601Lexer.scanISO8601DateIfMatch()) {
                              value = iso8601Lexer.getCalendar().getTime();
                           } else {
                              value = stringLiteral;
                           }

                           iso8601Lexer.close();
                        } else {
                           value = stringLiteral;
                        }
                        break;
                     case 5:
                     case 9:
                     case 10:
                     case 11:
                     case 13:
                     case 16:
                     case 17:
                     case 18:
                     case 19:
                     case 21:
                     case 22:
                     default:
                        value = this.parse();
                        break;
                     case 6:
                        value = Boolean.TRUE;
                        lexer.nextToken(16);
                        break;
                     case 7:
                        value = Boolean.FALSE;
                        lexer.nextToken(16);
                        break;
                     case 8:
                        value = null;
                        lexer.nextToken(4);
                        break;
                     case 12:
                        JSONObject object = new JSONObject(lexer.isEnabled(Feature.OrderedField));
                        value = this.parseObject((Map)object, i);
                        break;
                     case 14:
                        Collection items = new JSONArray();
                        this.parseArray(items, (Object)i);
                        if (lexer.isEnabled(Feature.UseObjectArray)) {
                           value = items.toArray();
                        } else {
                           value = items;
                        }
                        break;
                     case 15:
                        lexer.nextToken(16);
                        return;
                     case 20:
                        throw new JSONException("unclosed jsonArray");
                     case 23:
                        value = null;
                        lexer.nextToken(4);
                  }

                  array.add(value);
                  this.checkListResolve(array);
                  if (lexer.token() == 16) {
                     lexer.nextToken(4);
                  }

                  ++i;
               }
            } catch (ClassCastException e) {
               throw new JSONException("unkown error", e);
            } finally {
               this.setContext(context);
            }
         }
      }
   }

   public ParseContext getContext() {
      return this.context;
   }

   public ParseContext getOwnerContext() {
      return this.context.parent;
   }

   public List<ResolveTask> getResolveTaskList() {
      if (this.resolveTaskList == null) {
         this.resolveTaskList = new ArrayList(2);
      }

      return this.resolveTaskList;
   }

   public void addResolveTask(ResolveTask task) {
      if (this.resolveTaskList == null) {
         this.resolveTaskList = new ArrayList(2);
      }

      this.resolveTaskList.add(task);
   }

   public ResolveTask getLastResolveTask() {
      return (ResolveTask)this.resolveTaskList.get(this.resolveTaskList.size() - 1);
   }

   public List<ExtraProcessor> getExtraProcessors() {
      if (this.extraProcessors == null) {
         this.extraProcessors = new ArrayList(2);
      }

      return this.extraProcessors;
   }

   public List<ExtraTypeProvider> getExtraTypeProviders() {
      if (this.extraTypeProviders == null) {
         this.extraTypeProviders = new ArrayList(2);
      }

      return this.extraTypeProviders;
   }

   public FieldTypeResolver getFieldTypeResolver() {
      return this.fieldTypeResolver;
   }

   public void setFieldTypeResolver(FieldTypeResolver fieldTypeResolver) {
      this.fieldTypeResolver = fieldTypeResolver;
   }

   public void setContext(ParseContext context) {
      if (!this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
         this.context = context;
      }
   }

   public void popContext() {
      if (!this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
         this.context = this.context.parent;
         if (this.contextArrayIndex > 0) {
            --this.contextArrayIndex;
            this.contextArray[this.contextArrayIndex] = null;
         }
      }
   }

   public ParseContext setContext(Object object, Object fieldName) {
      return this.lexer.isEnabled(Feature.DisableCircularReferenceDetect) ? null : this.setContext(this.context, object, fieldName);
   }

   public ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
      if (this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
         return null;
      } else {
         this.context = new ParseContext(parent, object, fieldName);
         this.addContext(this.context);
         return this.context;
      }
   }

   private void addContext(ParseContext context) {
      int i = this.contextArrayIndex++;
      if (this.contextArray == null) {
         this.contextArray = new ParseContext[8];
      } else if (i >= this.contextArray.length) {
         int newLen = this.contextArray.length * 3 / 2;
         ParseContext[] newArray = new ParseContext[newLen];
         System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
         this.contextArray = newArray;
      }

      this.contextArray[i] = context;
   }

   public Object parse() {
      return this.parse(null);
   }

   public Object parseKey() {
      if (this.lexer.token() == 18) {
         String value = this.lexer.stringVal();
         this.lexer.nextToken(16);
         return value;
      } else {
         return this.parse(null);
      }
   }

   public Object parse(Object fieldName) {
      JSONLexer lexer = this.lexer;
      switch (lexer.token()) {
         case 1:
         case 5:
         case 10:
         case 11:
         case 13:
         case 15:
         case 16:
         case 17:
         case 19:
         case 24:
         case 25:
         default:
            throw new JSONException("syntax error, " + lexer.info());
         case 2:
            Number intValue = lexer.integerValue();
            lexer.nextToken();
            return intValue;
         case 3:
            Object value = lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
            lexer.nextToken();
            return value;
         case 4:
            String stringLiteral = lexer.stringVal();
            lexer.nextToken(16);
            if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
               JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);

               Date var11;
               try {
                  if (!iso8601Lexer.scanISO8601DateIfMatch()) {
                     return stringLiteral;
                  }

                  var11 = iso8601Lexer.getCalendar().getTime();
               } finally {
                  iso8601Lexer.close();
               }

               return var11;
            }

            return stringLiteral;
         case 6:
            lexer.nextToken();
            return Boolean.TRUE;
         case 7:
            lexer.nextToken();
            return Boolean.FALSE;
         case 8:
            lexer.nextToken();
            return null;
         case 9:
            lexer.nextToken(18);
            if (lexer.token() != 18) {
               throw new JSONException("syntax error");
            }

            lexer.nextToken(10);
            this.accept(10);
            long time = lexer.integerValue().longValue();
            this.accept(2);
            this.accept(11);
            return new Date(time);
         case 12:
            Map object = (Map)(this.isEnabled(Feature.UseNativeJavaObject) ? (lexer.isEnabled(Feature.OrderedField) ? new HashMap() : new LinkedHashMap()) : new JSONObject(lexer.isEnabled(Feature.OrderedField)));
            return this.parseObject(object, fieldName);
         case 14:
            Collection array = (Collection)(this.isEnabled(Feature.UseNativeJavaObject) ? new ArrayList() : new JSONArray());
            this.parseArray(array, fieldName);
            if (lexer.isEnabled(Feature.UseObjectArray)) {
               return array.toArray();
            }

            return array;
         case 18:
            String identifier = lexer.stringVal();
            if ("NaN".equals(identifier)) {
               lexer.nextToken();
               return null;
            }

            throw new JSONException("syntax error, " + lexer.info());
         case 20:
            if (lexer.isBlankInput()) {
               return null;
            }

            throw new JSONException("unterminated json string, " + lexer.info());
         case 21:
            lexer.nextToken();
            HashSet<Object> set = new HashSet();
            this.parseArray(set, (Object)fieldName);
            return set;
         case 22:
            lexer.nextToken();
            TreeSet<Object> treeSet = new TreeSet();
            this.parseArray(treeSet, (Object)fieldName);
            return treeSet;
         case 23:
            lexer.nextToken();
            return null;
         case 26:
            byte[] bytes = lexer.bytesValue();
            lexer.nextToken();
            return bytes;
      }
   }

   public void config(Feature feature, boolean state) {
      this.lexer.config(feature, state);
   }

   public boolean isEnabled(Feature feature) {
      return this.lexer.isEnabled(feature);
   }

   public JSONLexer getLexer() {
      return this.lexer;
   }

   public final void accept(int token) {
      JSONLexer lexer = this.lexer;
      if (lexer.token() == token) {
         lexer.nextToken();
      } else {
         throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(lexer.token()));
      }
   }

   public final void accept(int token, int nextExpectToken) {
      JSONLexer lexer = this.lexer;
      if (lexer.token() == token) {
         lexer.nextToken(nextExpectToken);
      } else {
         this.throwException(token);
      }

   }

   public void throwException(int token) {
      throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(this.lexer.token()));
   }

   public void close() {
      JSONLexer lexer = this.lexer;

      try {
         if (lexer.isEnabled(Feature.AutoCloseSource) && lexer.token() != 20) {
            throw new JSONException("not close json text, token : " + JSONToken.name(lexer.token()));
         }
      } finally {
         lexer.close();
      }

   }

   public Object resolveReference(String ref) {
      if (this.contextArray == null) {
         return null;
      } else {
         for(int i = 0; i < this.contextArray.length && i < this.contextArrayIndex; ++i) {
            ParseContext context = this.contextArray[i];
            if (context.toString().equals(ref)) {
               return context.object;
            }
         }

         return null;
      }
   }

   public void handleResovleTask(Object value) {
      if (this.resolveTaskList != null) {
         int i = 0;

         for(int size = this.resolveTaskList.size(); i < size; ++i) {
            ResolveTask task = (ResolveTask)this.resolveTaskList.get(i);
            String ref = task.referenceValue;
            Object object = null;
            if (task.ownerContext != null) {
               object = task.ownerContext.object;
            }

            Object refValue;
            if (ref.startsWith("$")) {
               refValue = this.getObject(ref);
               if (refValue == null) {
                  try {
                     JSONPath jsonpath = new JSONPath(ref, SerializeConfig.getGlobalInstance(), this.config, true);
                     if (jsonpath.isRef()) {
                        refValue = jsonpath.eval(value);
                     }
                  } catch (JSONPathException var11) {
                  }
               }
            } else {
               refValue = task.context.object;
            }

            FieldDeserializer fieldDeser = task.fieldDeserializer;
            if (fieldDeser != null) {
               if (refValue != null && refValue.getClass() == JSONObject.class && fieldDeser.fieldInfo != null && !Map.class.isAssignableFrom(fieldDeser.fieldInfo.fieldClass)) {
                  Object root = this.contextArray[0].object;
                  JSONPath jsonpath = JSONPath.compile(ref);
                  if (jsonpath.isRef()) {
                     refValue = jsonpath.eval(root);
                  }
               }

               if (fieldDeser.getOwnerClass() != null && !fieldDeser.getOwnerClass().isInstance(object) && task.ownerContext.parent != null) {
                  for(ParseContext ctx = task.ownerContext.parent; ctx != null; ctx = ctx.parent) {
                     if (fieldDeser.getOwnerClass().isInstance(ctx.object)) {
                        object = ctx.object;
                        break;
                     }
                  }
               }

               fieldDeser.setValue(object, refValue);
            }
         }

      }
   }

   public void parseExtra(Object object, String key) {
      JSONLexer lexer = this.lexer;
      lexer.nextTokenWithColon();
      Type type = null;
      if (this.extraTypeProviders != null) {
         for(ExtraTypeProvider extraProvider : this.extraTypeProviders) {
            type = extraProvider.getExtraType(object, key);
         }
      }

      Object value = type == null ? this.parse() : this.parseObject(type);
      if (object instanceof ExtraProcessable) {
         ExtraProcessable extraProcessable = (ExtraProcessable)object;
         extraProcessable.processExtra(key, value);
      } else {
         if (this.extraProcessors != null) {
            for(ExtraProcessor process : this.extraProcessors) {
               process.processExtra(object, key, value);
            }
         }

         if (this.resolveStatus == 1) {
            this.resolveStatus = 0;
         }

      }
   }

   public Object parse(PropertyProcessable object, Object fieldName) {
      if (this.lexer.token() != 12) {
         String msg = "syntax error, expect {, actual " + this.lexer.tokenName();
         if (fieldName instanceof String) {
            msg = msg + ", fieldName ";
            msg = msg + fieldName;
         }

         msg = msg + ", ";
         msg = msg + this.lexer.info();
         JSONArray array = new JSONArray();
         this.parseArray(array, (Object)fieldName);
         if (array.size() == 1) {
            Object first = array.get(0);
            if (first instanceof JSONObject) {
               return (JSONObject)first;
            }
         }

         throw new JSONException(msg);
      } else {
         ParseContext context = this.context;

         try {
            int i = 0;

            while(true) {
               this.lexer.skipWhitespace();
               char ch = this.lexer.getCurrent();
               if (this.lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                  while(ch == ',') {
                     this.lexer.next();
                     this.lexer.skipWhitespace();
                     ch = this.lexer.getCurrent();
                  }
               }

               String key;
               if (ch == '"') {
                  key = this.lexer.scanSymbol(this.symbolTable, '"');
                  this.lexer.skipWhitespace();
                  ch = this.lexer.getCurrent();
                  if (ch != ':') {
                     throw new JSONException("expect ':' at " + this.lexer.pos());
                  }
               } else {
                  if (ch == '}') {
                     this.lexer.next();
                     this.lexer.resetStringPosition();
                     this.lexer.nextToken(16);
                     PropertyProcessable var25 = object;
                     return var25;
                  }

                  if (ch == '\'') {
                     if (!this.lexer.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                     }

                     key = this.lexer.scanSymbol(this.symbolTable, '\'');
                     this.lexer.skipWhitespace();
                     ch = this.lexer.getCurrent();
                     if (ch != ':') {
                        throw new JSONException("expect ':' at " + this.lexer.pos());
                     }
                  } else {
                     if (!this.lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                     }

                     key = this.lexer.scanSymbolUnQuoted(this.symbolTable);
                     this.lexer.skipWhitespace();
                     ch = this.lexer.getCurrent();
                     if (ch != ':') {
                        throw new JSONException("expect ':' at " + this.lexer.pos() + ", actual " + ch);
                     }
                  }
               }

               this.lexer.next();
               this.lexer.skipWhitespace();
               ch = this.lexer.getCurrent();
               this.lexer.resetStringPosition();
               if (key == JSON.DEFAULT_TYPE_KEY && !this.lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                  String typeName = this.lexer.scanSymbol(this.symbolTable, '"');
                  Class<?> clazz = this.config.checkAutoType(typeName, (Class)null, this.lexer.getFeatures());
                  if (!Map.class.isAssignableFrom(clazz)) {
                     ObjectDeserializer deserializer = this.config.getDeserializer((Type)clazz);
                     this.lexer.nextToken(16);
                     this.setResolveStatus(2);
                     if (context != null && !(fieldName instanceof Integer)) {
                        this.popContext();
                     }

                     Map var30 = (Map)deserializer.deserialze(this, clazz, fieldName);
                     return var30;
                  }

                  this.lexer.nextToken(16);
                  if (this.lexer.token() == 13) {
                     this.lexer.nextToken(16);
                     PropertyProcessable var27 = object;
                     return var27;
                  }
               } else {
                  this.lexer.nextToken();
                  if (i != 0) {
                     this.setContext(context);
                  }

                  Type valueType = object.getType(key);
                  Object value;
                  if (this.lexer.token() == 8) {
                     value = null;
                     this.lexer.nextToken();
                  } else {
                     value = this.parseObject((Type)valueType, key);
                  }

                  object.apply(key, value);
                  this.setContext(context, value, key);
                  this.setContext(context);
                  int tok = this.lexer.token();
                  if (tok == 20 || tok == 15) {
                     PropertyProcessable var29 = object;
                     return var29;
                  }

                  if (tok == 13) {
                     this.lexer.nextToken();
                     PropertyProcessable var10 = object;
                     return var10;
                  }
               }

               ++i;
            }
         } finally {
            this.setContext(context);
         }
      }
   }

   static {
      Class<?>[] classes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, String.class};
      primitiveClasses.addAll(Arrays.asList(classes));
   }

   public static class ResolveTask {
      public final ParseContext context;
      public final String referenceValue;
      public FieldDeserializer fieldDeserializer;
      public ParseContext ownerContext;

      public ResolveTask(ParseContext context, String referenceValue) {
         this.context = context;
         this.referenceValue = referenceValue;
      }
   }
}
