package com.alibaba.fastjson.parser;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;

public interface JSONLexer {
   char EOI = '\u001a';
   int NOT_MATCH = -1;
   int NOT_MATCH_NAME = -2;
   int UNKNOWN = 0;
   int OBJECT = 1;
   int ARRAY = 2;
   int VALUE = 3;
   int END = 4;
   int VALUE_NULL = 5;

   int token();

   String tokenName();

   void skipWhitespace();

   void nextToken();

   void nextToken(int var1);

   char getCurrent();

   char next();

   String scanSymbol(SymbolTable var1);

   String scanSymbol(SymbolTable var1, char var2);

   void resetStringPosition();

   void scanNumber();

   int pos();

   Number integerValue();

   BigDecimal decimalValue();

   Number decimalValue(boolean var1);

   String scanSymbolUnQuoted(SymbolTable var1);

   String stringVal();

   boolean isEnabled(int var1);

   boolean isEnabled(Feature var1);

   void config(Feature var1, boolean var2);

   void scanString();

   int intValue();

   void nextTokenWithColon();

   void nextTokenWithColon(int var1);

   boolean isBlankInput();

   void close();

   long longValue();

   boolean isRef();

   String scanTypeName(SymbolTable var1);

   String numberString();

   byte[] bytesValue();

   float floatValue();

   int scanInt(char var1);

   long scanLong(char var1);

   float scanFloat(char var1);

   double scanDouble(char var1);

   boolean scanBoolean(char var1);

   BigDecimal scanDecimal(char var1);

   String scanString(char var1);

   Enum<?> scanEnum(Class<?> var1, SymbolTable var2, char var3);

   String scanSymbolWithSeperator(SymbolTable var1, char var2);

   void scanStringArray(Collection<String> var1, char var2);

   TimeZone getTimeZone();

   void setTimeZone(TimeZone var1);

   Locale getLocale();

   void setLocale(Locale var1);

   String info();

   int getFeatures();

   void setFeatures(int var1);
}
