package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.IOUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class JSONScanner extends JSONLexerBase {
   private final String text;
   private final int len;

   public JSONScanner(String input) {
      this(input, JSON.DEFAULT_PARSER_FEATURE);
   }

   public JSONScanner(String input, int features) {
      super(features);
      this.text = input;
      this.len = this.text.length();
      this.bp = -1;
      this.next();
      if (this.ch == '\ufeff') {
         this.next();
      }

   }

   public final char charAt(int index) {
      return index >= this.len ? '\u001a' : this.text.charAt(index);
   }

   public final char next() {
      int index = ++this.bp;
      return this.ch = index >= this.len ? '\u001a' : this.text.charAt(index);
   }

   public JSONScanner(char[] input, int inputLength) {
      this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
   }

   public JSONScanner(char[] input, int inputLength, int features) {
      this(new String(input, 0, inputLength), features);
   }

   protected final void copyTo(int offset, int count, char[] dest) {
      this.text.getChars(offset, offset + count, dest, 0);
   }

   static boolean charArrayCompare(String src, int offset, char[] dest) {
      int destLen = dest.length;
      if (destLen + offset > src.length()) {
         return false;
      } else {
         for(int i = 0; i < destLen; ++i) {
            if (dest[i] != src.charAt(offset + i)) {
               return false;
            }
         }

         return true;
      }
   }

   public final boolean charArrayCompare(char[] chars) {
      return charArrayCompare(this.text, this.bp, chars);
   }

   public final int indexOf(char ch, int startIndex) {
      return this.text.indexOf(ch, startIndex);
   }

   public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
      return symbolTable.addSymbol(this.text, offset, len, hash);
   }

   public byte[] bytesValue() {
      if (this.token == 26) {
         int start = this.np + 1;
         int len = this.sp;
         if (len % 2 != 0) {
            throw new JSONException("illegal state. " + len);
         } else {
            byte[] bytes = new byte[len / 2];

            for(int i = 0; i < bytes.length; ++i) {
               char c0 = this.text.charAt(start + i * 2);
               char c1 = this.text.charAt(start + i * 2 + 1);
               int b0 = c0 - (c0 <= '9' ? 48 : 55);
               int b1 = c1 - (c1 <= '9' ? 48 : 55);
               bytes[i] = (byte)(b0 << 4 | b1);
            }

            return bytes;
         }
      } else if (!this.hasSpecial) {
         return IOUtils.decodeBase64(this.text, this.np + 1, this.sp);
      } else {
         String escapedText = new String(this.sbuf, 0, this.sp);
         return IOUtils.decodeBase64(escapedText);
      }
   }

   public final String stringVal() {
      return !this.hasSpecial ? this.subString(this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
   }

   public final String subString(int offset, int count) {
      if (ASMUtils.IS_ANDROID) {
         if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new String(this.sbuf, 0, count);
         } else {
            char[] chars = new char[count];
            this.text.getChars(offset, offset + count, chars, 0);
            return new String(chars);
         }
      } else {
         return this.text.substring(offset, offset + count);
      }
   }

   public final char[] sub_chars(int offset, int count) {
      if (ASMUtils.IS_ANDROID && count < this.sbuf.length) {
         this.text.getChars(offset, offset + count, this.sbuf, 0);
         return this.sbuf;
      } else {
         char[] chars = new char[count];
         this.text.getChars(offset, offset + count, chars, 0);
         return chars;
      }
   }

   public final String numberString() {
      char chLocal = this.charAt(this.np + this.sp - 1);
      int sp = this.sp;
      if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
         --sp;
      }

      return this.subString(this.np, sp);
   }

   public final BigDecimal decimalValue() {
      char chLocal = this.charAt(this.np + this.sp - 1);
      int sp = this.sp;
      if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
         --sp;
      }

      if (sp > 65535) {
         throw new JSONException("decimal overflow");
      } else {
         int offset = this.np;
         if (sp < this.sbuf.length) {
            this.text.getChars(offset, offset + sp, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, sp, MathContext.UNLIMITED);
         } else {
            char[] chars = new char[sp];
            this.text.getChars(offset, offset + sp, chars, 0);
            return new BigDecimal(chars, 0, chars.length, MathContext.UNLIMITED);
         }
      }
   }

   public boolean scanISO8601DateIfMatch() {
      return this.scanISO8601DateIfMatch(true);
   }

   public boolean scanISO8601DateIfMatch(boolean strict) {
      int rest = this.len - this.bp;
      return this.scanISO8601DateIfMatch(strict, rest);
   }

   private boolean scanISO8601DateIfMatch(boolean strict, int rest) {
      if (rest < 8) {
         return false;
      } else {
         char c0 = this.charAt(this.bp);
         char c1 = this.charAt(this.bp + 1);
         char c2 = this.charAt(this.bp + 2);
         char c3 = this.charAt(this.bp + 3);
         char c4 = this.charAt(this.bp + 4);
         char c5 = this.charAt(this.bp + 5);
         char c6 = this.charAt(this.bp + 6);
         char c7 = this.charAt(this.bp + 7);
         if (!strict && rest > 13) {
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
               int plusIndex = -1;

               for(int i = 6; i < rest; ++i) {
                  char c = this.charAt(this.bp + i);
                  if (c == '+') {
                     plusIndex = i;
                  } else if (c < '0' || c > '9') {
                     break;
                  }
               }

               if (plusIndex == -1) {
                  return false;
               }

               int offset = this.bp + 6;
               String numberText = this.subString(offset, this.bp + plusIndex - offset);
               long millis = Long.parseLong(numberText);
               this.calendar = Calendar.getInstance(this.timeZone, this.locale);
               this.calendar.setTimeInMillis(millis);
               this.token = 5;
               return true;
            }
         }

         char c10;
         if (rest == 8 || rest == 14 || rest == 16 && ((c10 = this.charAt(this.bp + 10)) == 'T' || c10 == ' ') || rest == 17 && this.charAt(this.bp + 6) != '-') {
            if (strict) {
               return false;
            } else {
               char c8 = this.charAt(this.bp + 8);
               boolean c_47 = c4 == '-' && c7 == '-';
               boolean sperate16 = c_47 && rest == 16;
               boolean sperate17 = c_47 && rest == 17;
               char y0;
               char y1;
               char y2;
               char y3;
               char M0;
               char M1;
               char d0;
               char d1;
               if (!sperate17 && !sperate16) {
                  if (c4 == '-' && c6 == '-') {
                     y0 = c0;
                     y1 = c1;
                     y2 = c2;
                     y3 = c3;
                     M0 = '0';
                     M1 = c5;
                     d0 = '0';
                     d1 = c7;
                  } else {
                     y0 = c0;
                     y1 = c1;
                     y2 = c2;
                     y3 = c3;
                     M0 = c4;
                     M1 = c5;
                     d0 = c6;
                     d1 = c7;
                  }
               } else {
                  y0 = c0;
                  y1 = c1;
                  y2 = c2;
                  y3 = c3;
                  M0 = c5;
                  M1 = c6;
                  d0 = c8;
                  d1 = this.charAt(this.bp + 9);
               }

               if (!checkDate(y0, y1, y2, y3, M0, M1, d0, d1)) {
                  return false;
               } else {
                  this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
                  int hour;
                  int minute;
                  int seconds;
                  int millis;
                  if (rest == 8) {
                     hour = 0;
                     minute = 0;
                     seconds = 0;
                     millis = 0;
                  } else {
                     char c9 = this.charAt(this.bp + 9);
                     c10 = this.charAt(this.bp + 10);
                     char c11 = this.charAt(this.bp + 11);
                     char c12 = this.charAt(this.bp + 12);
                     char c13 = this.charAt(this.bp + 13);
                     char h0;
                     char h1;
                     char m0;
                     char m1;
                     char s0;
                     char s1;
                     if ((!sperate17 || c10 != 'T' || c13 != ':' || this.charAt(this.bp + 16) != 'Z') && (!sperate16 || c10 != ' ' && c10 != 'T' || c13 != ':')) {
                        h0 = c8;
                        h1 = c9;
                        m0 = c10;
                        m1 = c11;
                        s0 = c12;
                        s1 = c13;
                     } else {
                        h0 = c11;
                        h1 = c12;
                        m0 = this.charAt(this.bp + 14);
                        m1 = this.charAt(this.bp + 15);
                        s0 = '0';
                        s1 = '0';
                     }

                     if (!this.checkTime(h0, h1, m0, m1, s0, s1)) {
                        return false;
                     }

                     if (rest == 17 && !sperate17) {
                        char S0 = this.charAt(this.bp + 14);
                        char S1 = this.charAt(this.bp + 15);
                        char S2 = this.charAt(this.bp + 16);
                        if (S0 < '0' || S0 > '9') {
                           return false;
                        }

                        if (S1 < '0' || S1 > '9') {
                           return false;
                        }

                        if (S2 < '0' || S2 > '9') {
                           return false;
                        }

                        millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
                     } else {
                        millis = 0;
                     }

                     hour = (h0 - 48) * 10 + (h1 - 48);
                     minute = (m0 - 48) * 10 + (m1 - 48);
                     seconds = (s0 - 48) * 10 + (s1 - 48);
                  }

                  this.calendar.set(11, hour);
                  this.calendar.set(12, minute);
                  this.calendar.set(13, seconds);
                  this.calendar.set(14, millis);
                  this.token = 5;
                  return true;
               }
            }
         } else if (rest < 9) {
            return false;
         } else {
            char c8 = this.charAt(this.bp + 8);
            char c9 = this.charAt(this.bp + 9);
            int date_len = 10;
            char y0;
            char y1;
            char y2;
            char y3;
            char M0;
            char M1;
            char d0;
            char d1;
            if ((c4 != '-' || c7 != '-') && (c4 != '/' || c7 != '/')) {
               if (c4 == '-' && c6 == '-') {
                  y0 = c0;
                  y1 = c1;
                  y2 = c2;
                  y3 = c3;
                  M0 = '0';
                  M1 = c5;
                  if (c8 == ' ') {
                     d0 = '0';
                     d1 = c7;
                     date_len = 8;
                  } else {
                     d0 = c7;
                     d1 = c8;
                     date_len = 9;
                  }
               } else if ((c2 != '.' || c5 != '.') && (c2 != '-' || c5 != '-')) {
                  if (c8 == 'T') {
                     y0 = c0;
                     y1 = c1;
                     y2 = c2;
                     y3 = c3;
                     M0 = c4;
                     M1 = c5;
                     d0 = c6;
                     d1 = c7;
                     date_len = 8;
                  } else {
                     if (c4 != 24180 && c4 != '년') {
                        return false;
                     }

                     y0 = c0;
                     y1 = c1;
                     y2 = c2;
                     y3 = c3;
                     if (c7 != 26376 && c7 != '월') {
                        if (c6 != 26376 && c6 != '월') {
                           return false;
                        }

                        M0 = '0';
                        M1 = c5;
                        if (c8 != 26085 && c8 != '일') {
                           if (c9 != 26085 && c9 != '일') {
                              return false;
                           }

                           d0 = c7;
                           d1 = c8;
                        } else {
                           d0 = '0';
                           d1 = c7;
                        }
                     } else {
                        M0 = c5;
                        M1 = c6;
                        if (c9 != 26085 && c9 != '일') {
                           if (this.charAt(this.bp + 10) != 26085 && this.charAt(this.bp + 10) != '일') {
                              return false;
                           }

                           d0 = c8;
                           d1 = c9;
                           date_len = 11;
                        } else {
                           d0 = '0';
                           d1 = c8;
                        }
                     }
                  }
               } else {
                  d0 = c0;
                  d1 = c1;
                  M0 = c3;
                  M1 = c4;
                  y0 = c6;
                  y1 = c7;
                  y2 = c8;
                  y3 = c9;
               }
            } else {
               y0 = c0;
               y1 = c1;
               y2 = c2;
               y3 = c3;
               M0 = c5;
               M1 = c6;
               if (c9 == ' ') {
                  d0 = '0';
                  d1 = c8;
                  date_len = 9;
               } else {
                  d0 = c8;
                  d1 = c9;
               }
            }

            if (!checkDate(y0, y1, y2, y3, M0, M1, d0, d1)) {
               return false;
            } else {
               this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
               char t = this.charAt(this.bp + date_len);
               if (t == 'T' && rest == 16 && date_len == 8 && this.charAt(this.bp + 15) == 'Z') {
                  char h0 = this.charAt(this.bp + date_len + 1);
                  char h1 = this.charAt(this.bp + date_len + 2);
                  char m0 = this.charAt(this.bp + date_len + 3);
                  char m1 = this.charAt(this.bp + date_len + 4);
                  char s0 = this.charAt(this.bp + date_len + 5);
                  char s1 = this.charAt(this.bp + date_len + 6);
                  if (!this.checkTime(h0, h1, m0, m1, s0, s1)) {
                     return false;
                  } else {
                     this.setTime(h0, h1, m0, m1, s0, s1);
                     this.calendar.set(14, 0);
                     if (this.calendar.getTimeZone().getRawOffset() != 0) {
                        String[] timeZoneIDs = TimeZone.getAvailableIDs(0);
                        if (timeZoneIDs.length > 0) {
                           TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                           this.calendar.setTimeZone(timeZone);
                        }
                     }

                     this.token = 5;
                     return true;
                  }
               } else if (t == 'T' || t == ' ' && !strict) {
                  if (rest < date_len + 9) {
                     return false;
                  } else if (this.charAt(this.bp + date_len + 3) != ':') {
                     return false;
                  } else if (this.charAt(this.bp + date_len + 6) != ':') {
                     return false;
                  } else {
                     char h0 = this.charAt(this.bp + date_len + 1);
                     char h1 = this.charAt(this.bp + date_len + 2);
                     char m0 = this.charAt(this.bp + date_len + 4);
                     char m1 = this.charAt(this.bp + date_len + 5);
                     char s0 = this.charAt(this.bp + date_len + 7);
                     char s1 = this.charAt(this.bp + date_len + 8);
                     if (!this.checkTime(h0, h1, m0, m1, s0, s1)) {
                        return false;
                     } else {
                        this.setTime(h0, h1, m0, m1, s0, s1);
                        char dot = this.charAt(this.bp + date_len + 9);
                        int millisLen = -1;
                        int millis = 0;
                        if (dot == '.') {
                           if (rest < date_len + 11) {
                              return false;
                           }

                           char S0 = this.charAt(this.bp + date_len + 10);
                           if (S0 < '0' || S0 > '9') {
                              return false;
                           }

                           millis = S0 - 48;
                           millisLen = 1;
                           if (rest > date_len + 11) {
                              char S1 = this.charAt(this.bp + date_len + 11);
                              if (S1 >= '0' && S1 <= '9') {
                                 millis = millis * 10 + (S1 - 48);
                                 millisLen = 2;
                              }
                           }

                           if (millisLen == 2) {
                              char S2 = this.charAt(this.bp + date_len + 12);
                              if (S2 >= '0' && S2 <= '9') {
                                 millis = millis * 10 + (S2 - 48);
                                 millisLen = 3;
                              }
                           }
                        }

                        this.calendar.set(14, millis);
                        int timzeZoneLength = 0;
                        char timeZoneFlag = this.charAt(this.bp + date_len + 10 + millisLen);
                        if (timeZoneFlag == ' ') {
                           ++millisLen;
                           timeZoneFlag = this.charAt(this.bp + date_len + 10 + millisLen);
                        }

                        if (timeZoneFlag != '+' && timeZoneFlag != '-') {
                           if (timeZoneFlag == 'Z') {
                              timzeZoneLength = 1;
                              if (this.calendar.getTimeZone().getRawOffset() != 0) {
                                 String[] timeZoneIDs = TimeZone.getAvailableIDs(0);
                                 if (timeZoneIDs.length > 0) {
                                    TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                                    this.calendar.setTimeZone(timeZone);
                                 }
                              }
                           }
                        } else {
                           char t0 = this.charAt(this.bp + date_len + 10 + millisLen + 1);
                           if (t0 < '0' || t0 > '1') {
                              return false;
                           }

                           char t1 = this.charAt(this.bp + date_len + 10 + millisLen + 2);
                           if (t1 < '0' || t1 > '9') {
                              return false;
                           }

                           char t2 = this.charAt(this.bp + date_len + 10 + millisLen + 3);
                           char t3 = '0';
                           char t4 = '0';
                           if (t2 == ':') {
                              t3 = this.charAt(this.bp + date_len + 10 + millisLen + 4);
                              t4 = this.charAt(this.bp + date_len + 10 + millisLen + 5);
                              if (t3 == '4' && t4 == '5') {
                                 if ((t0 != '1' || t1 != '2' && t1 != '3') && (t0 != '0' || t1 != '5' && t1 != '8')) {
                                    return false;
                                 }
                              } else {
                                 if (t3 != '0' && t3 != '3') {
                                    return false;
                                 }

                                 if (t4 != '0') {
                                    return false;
                                 }
                              }

                              timzeZoneLength = 6;
                           } else if (t2 == '0') {
                              t3 = this.charAt(this.bp + date_len + 10 + millisLen + 4);
                              if (t3 != '0' && t3 != '3') {
                                 return false;
                              }

                              timzeZoneLength = 5;
                           } else if (t2 == '3' && this.charAt(this.bp + date_len + 10 + millisLen + 4) == '0') {
                              t3 = '3';
                              t4 = '0';
                              timzeZoneLength = 5;
                           } else if (t2 == '4' && this.charAt(this.bp + date_len + 10 + millisLen + 4) == '5') {
                              t3 = '4';
                              t4 = '5';
                              timzeZoneLength = 5;
                           } else {
                              timzeZoneLength = 3;
                           }

                           this.setTimeZone(timeZoneFlag, t0, t1, t3, t4);
                        }

                        char end = this.charAt(this.bp + date_len + 10 + millisLen + timzeZoneLength);
                        if (end != 26 && end != '"') {
                           return false;
                        } else {
                           this.ch = this.charAt(this.bp += date_len + 10 + millisLen + timzeZoneLength);
                           this.token = 5;
                           return true;
                        }
                     }
                  }
               } else if (t != '"' && t != 26 && t != 26085 && t != '일') {
                  if (t != '+' && t != '-') {
                     return false;
                  } else if (this.len == date_len + 6) {
                     if (this.charAt(this.bp + date_len + 3) == ':' && this.charAt(this.bp + date_len + 4) == '0' && this.charAt(this.bp + date_len + 5) == '0') {
                        this.setTime('0', '0', '0', '0', '0', '0');
                        this.calendar.set(14, 0);
                        this.setTimeZone(t, this.charAt(this.bp + date_len + 1), this.charAt(this.bp + date_len + 2));
                        return true;
                     } else {
                        return false;
                     }
                  } else {
                     return false;
                  }
               } else {
                  this.calendar.set(11, 0);
                  this.calendar.set(12, 0);
                  this.calendar.set(13, 0);
                  this.calendar.set(14, 0);
                  this.ch = this.charAt(this.bp += date_len);
                  this.token = 5;
                  return true;
               }
            }
         }
      }
   }

   protected void setTime(char h0, char h1, char m0, char m1, char s0, char s1) {
      int hour = (h0 - 48) * 10 + (h1 - 48);
      int minute = (m0 - 48) * 10 + (m1 - 48);
      int seconds = (s0 - 48) * 10 + (s1 - 48);
      this.calendar.set(11, hour);
      this.calendar.set(12, minute);
      this.calendar.set(13, seconds);
   }

   protected void setTimeZone(char timeZoneFlag, char t0, char t1) {
      this.setTimeZone(timeZoneFlag, t0, t1, '0', '0');
   }

   protected void setTimeZone(char timeZoneFlag, char t0, char t1, char t3, char t4) {
      int timeZoneOffset = ((t0 - 48) * 10 + (t1 - 48)) * 3600 * 1000;
      timeZoneOffset += ((t3 - 48) * 10 + (t4 - 48)) * 60 * 1000;
      if (timeZoneFlag == '-') {
         timeZoneOffset = -timeZoneOffset;
      }

      if (this.calendar.getTimeZone().getRawOffset() != timeZoneOffset) {
         this.calendar.setTimeZone(new SimpleTimeZone(timeZoneOffset, Integer.toString(timeZoneOffset)));
      }

   }

   private boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
      if (h0 == '0') {
         if (h1 < '0' || h1 > '9') {
            return false;
         }
      } else if (h0 == '1') {
         if (h1 < '0' || h1 > '9') {
            return false;
         }
      } else {
         if (h0 != '2') {
            return false;
         }

         if (h1 < '0' || h1 > '4') {
            return false;
         }
      }

      if (m0 >= '0' && m0 <= '5') {
         if (m1 < '0' || m1 > '9') {
            return false;
         }
      } else {
         if (m0 != '6') {
            return false;
         }

         if (m1 != '0') {
            return false;
         }
      }

      if (s0 >= '0' && s0 <= '5') {
         if (s1 < '0' || s1 > '9') {
            return false;
         }
      } else {
         if (s0 != '6') {
            return false;
         }

         if (s1 != '0') {
            return false;
         }
      }

      return true;
   }

   private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
      this.calendar = Calendar.getInstance(this.timeZone, this.locale);
      int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
      int month = (M0 - 48) * 10 + (M1 - 48) - 1;
      int day = (d0 - 48) * 10 + (d1 - 48);
      this.calendar.set(1, year);
      this.calendar.set(2, month);
      this.calendar.set(5, day);
   }

   static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
      if (y0 >= '0' && y0 <= '9') {
         if (y1 >= '0' && y1 <= '9') {
            if (y2 >= '0' && y2 <= '9') {
               if (y3 >= '0' && y3 <= '9') {
                  if (M0 == '0') {
                     if (M1 < '1' || M1 > '9') {
                        return false;
                     }
                  } else {
                     if (M0 != '1') {
                        return false;
                     }

                     if (M1 != '0' && M1 != '1' && M1 != '2') {
                        return false;
                     }
                  }

                  if (d0 == 48) {
                     if (d1 < 49 || d1 > 57) {
                        return false;
                     }
                  } else if (d0 != 49 && d0 != 50) {
                     if (d0 != 51) {
                        return false;
                     }

                     if (d1 != 48 && d1 != 49) {
                        return false;
                     }
                  } else if (d1 < 48 || d1 > 57) {
                     return false;
                  }

                  return true;
               } else {
                  return false;
               }
            } else {
               return false;
            }
         } else {
            return false;
         }
      } else {
         return false;
      }
   }

   public boolean isEOF() {
      return this.bp == this.len || this.ch == 26 && this.bp + 1 >= this.len;
   }

   public int scanFieldInt(char[] fieldName) {
      this.matchStat = 0;
      int startPos = this.bp;
      char startChar = this.ch;
      if (!charArrayCompare(this.text, this.bp, fieldName)) {
         this.matchStat = -2;
         return 0;
      } else {
         int index = this.bp + fieldName.length;
         char ch = this.charAt(index++);
         boolean quote = ch == '"';
         if (quote) {
            ch = this.charAt(index++);
         }

         boolean negative = ch == '-';
         if (negative) {
            ch = this.charAt(index++);
         }

         if (ch >= '0' && ch <= '9') {
            int value = ch - 48;

            while(true) {
               ch = this.charAt(index++);
               if (ch < '0' || ch > '9') {
                  if (ch == '.') {
                     this.matchStat = -1;
                     return 0;
                  } else if (value < 0) {
                     this.matchStat = -1;
                     return 0;
                  } else {
                     if (quote) {
                        if (ch != '"') {
                           this.matchStat = -1;
                           return 0;
                        }

                        ch = this.charAt(index++);
                     }

                     while(ch != ',' && ch != '}') {
                        if (!isWhitespace(ch)) {
                           this.matchStat = -1;
                           return 0;
                        }

                        ch = this.charAt(index++);
                     }

                     this.bp = index - 1;
                     if (ch == ',') {
                        this.ch = this.charAt(++this.bp);
                        this.matchStat = 3;
                        this.token = 16;
                        return negative ? -value : value;
                     } else {
                        if (ch == '}') {
                           this.bp = index - 1;

                           label95: {
                              for(char var12 = this.charAt(++this.bp); var12 != ','; var12 = this.charAt(++this.bp)) {
                                 if (var12 == ']') {
                                    this.token = 15;
                                    this.ch = this.charAt(++this.bp);
                                    break label95;
                                 }

                                 if (var12 == '}') {
                                    this.token = 13;
                                    this.ch = this.charAt(++this.bp);
                                    break label95;
                                 }

                                 if (var12 == 26) {
                                    this.token = 20;
                                    break label95;
                                 }

                                 if (!isWhitespace(var12)) {
                                    this.bp = startPos;
                                    this.ch = startChar;
                                    this.matchStat = -1;
                                    return 0;
                                 }
                              }

                              this.token = 16;
                              this.ch = this.charAt(++this.bp);
                           }

                           this.matchStat = 4;
                        }

                        return negative ? -value : value;
                     }
                  }
               }

               int value_10 = value * 10;
               if (value_10 < value) {
                  this.matchStat = -1;
                  return 0;
               }

               value = value_10 + (ch - 48);
            }
         } else {
            this.matchStat = -1;
            return 0;
         }
      }
   }

   public String scanFieldString(char[] fieldName) {
      this.matchStat = 0;
      int startPos = this.bp;
      char startChar = this.ch;

      while(!charArrayCompare(this.text, this.bp, fieldName)) {
         if (!isWhitespace(this.ch)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
         }

         this.next();

         while(isWhitespace(this.ch)) {
            this.next();
         }
      }

      int index = this.bp + fieldName.length;
      int spaceCount = 0;
      char ch = this.charAt(index++);
      if (ch != '"') {
         while(isWhitespace(ch)) {
            ++spaceCount;
            ch = this.charAt(index++);
         }

         if (ch != '"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
         }
      }

      int endIndex = this.indexOf('"', index);
      if (endIndex == -1) {
         throw new JSONException("unclosed str");
      } else {
         String stringVal = this.subString(index, endIndex - index);
         if (stringVal.indexOf(92) != -1) {
            while(true) {
               int slashCount = 0;

               for(int i = endIndex - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                  ++slashCount;
               }

               if (slashCount % 2 == 0) {
                  slashCount = endIndex - (this.bp + fieldName.length + 1 + spaceCount);
                  char[] chars = this.sub_chars(this.bp + fieldName.length + 1 + spaceCount, slashCount);
                  stringVal = readString(chars, slashCount);
                  break;
               }

               endIndex = this.indexOf('"', endIndex + 1);
            }
         }

         if ((this.features & Feature.TrimStringFieldValue.mask) != 0) {
            stringVal = stringVal.trim();
         }

         for(ch = this.charAt(endIndex + 1); ch != ',' && ch != '}'; ch = this.charAt(endIndex + 1)) {
            if (!isWhitespace(ch)) {
               this.matchStat = -1;
               return this.stringDefaultValue();
            }

            ++endIndex;
         }

         this.bp = endIndex + 1;
         this.ch = ch;
         if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return stringVal;
         } else {
            ch = this.charAt(++this.bp);
            if (ch == ',') {
               this.token = 16;
               this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
               this.token = 15;
               this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
               this.token = 13;
               this.ch = this.charAt(++this.bp);
            } else {
               if (ch != 26) {
                  this.bp = startPos;
                  this.ch = startChar;
                  this.matchStat = -1;
                  return this.stringDefaultValue();
               }

               this.token = 20;
            }

            this.matchStat = 4;
            return stringVal;
         }
      }
   }

   public Date scanFieldDate(char[] fieldName) {
      this.matchStat = 0;
      int startPos = this.bp;
      char startChar = this.ch;
      if (!charArrayCompare(this.text, this.bp, fieldName)) {
         this.matchStat = -2;
         return null;
      } else {
         int index = this.bp + fieldName.length;
         char ch = this.charAt(index++);
         Date dateVal;
         if (ch == '"') {
            int endIndex = this.indexOf('"', index);
            if (endIndex == -1) {
               throw new JSONException("unclosed str");
            }

            int rest = endIndex - index;
            this.bp = index;
            if (!this.scanISO8601DateIfMatch(false, rest)) {
               this.bp = startPos;
               this.matchStat = -1;
               return null;
            }

            dateVal = this.calendar.getTime();
            ch = this.charAt(endIndex + 1);

            for(this.bp = startPos; ch != ',' && ch != '}'; ch = this.charAt(endIndex + 1)) {
               if (!isWhitespace(ch)) {
                  this.matchStat = -1;
                  return null;
               }

               ++endIndex;
            }

            this.bp = endIndex + 1;
            this.ch = ch;
         } else {
            if (ch != '-' && (ch < '0' || ch > '9')) {
               this.matchStat = -1;
               return null;
            }

            long millis = 0L;
            boolean negative = false;
            if (ch == '-') {
               ch = this.charAt(index++);
               negative = true;
            }

            if (ch >= '0' && ch <= '9') {
               millis = (long)(ch - 48);

               while(true) {
                  ch = this.charAt(index++);
                  if (ch < '0' || ch > '9') {
                     if (ch == ',' || ch == '}') {
                        this.bp = index - 1;
                     }
                     break;
                  }

                  millis = millis * 10L + (long)(ch - 48);
               }
            }

            if (millis < 0L) {
               this.matchStat = -1;
               return null;
            }

            if (negative) {
               millis = -millis;
            }

            dateVal = new Date(millis);
         }

         if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return dateVal;
         } else {
            ch = this.charAt(++this.bp);
            if (ch == ',') {
               this.token = 16;
               this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
               this.token = 15;
               this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
               this.token = 13;
               this.ch = this.charAt(++this.bp);
            } else {
               if (ch != 26) {
                  this.bp = startPos;
                  this.ch = startChar;
                  this.matchStat = -1;
                  return null;
               }

               this.token = 20;
            }

            this.matchStat = 4;
            return dateVal;
         }
      }
   }

   public long scanFieldSymbol(char[] fieldName) {
      this.matchStat = 0;

      while(!charArrayCompare(this.text, this.bp, fieldName)) {
         if (!isWhitespace(this.ch)) {
            this.matchStat = -2;
            return 0L;
         }

         this.next();

         while(isWhitespace(this.ch)) {
            this.next();
         }
      }

      int index = this.bp + fieldName.length;
      int spaceCount = 0;
      char ch = this.charAt(index++);
      if (ch != '"') {
         while(isWhitespace(ch)) {
            ch = this.charAt(index++);
            ++spaceCount;
         }

         if (ch != '"') {
            this.matchStat = -1;
            return 0L;
         }
      }

      long hash = -3750763034362895579L;

      while(true) {
         ch = this.charAt(index++);
         if (ch == '"') {
            this.bp = index;

            for(this.ch = ch = this.charAt(this.bp); ch != ','; ch = this.charAt(++this.bp)) {
               if (ch == '}') {
                  this.next();
                  this.skipWhitespace();
                  ch = this.getCurrent();
                  if (ch == ',') {
                     this.token = 16;
                     this.ch = this.charAt(++this.bp);
                  } else if (ch == ']') {
                     this.token = 15;
                     this.ch = this.charAt(++this.bp);
                  } else if (ch == '}') {
                     this.token = 13;
                     this.ch = this.charAt(++this.bp);
                  } else {
                     if (ch != 26) {
                        this.matchStat = -1;
                        return 0L;
                     }

                     this.token = 20;
                  }

                  this.matchStat = 4;
                  return hash;
               }

               if (!isWhitespace(ch)) {
                  this.matchStat = -1;
                  return 0L;
               }
            }

            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return hash;
         }

         if (index > this.len) {
            this.matchStat = -1;
            return 0L;
         }

         hash ^= (long)ch;
         hash *= 1099511628211L;
      }
   }

   public Collection<String> scanFieldStringArray(char[] fieldName, Class<?> type) {
      int index;
      for(this.matchStat = 0; this.ch == '\n' || this.ch == ' '; this.ch = index >= this.len ? 26 : this.text.charAt(index)) {
         index = ++this.bp;
      }

      if (!charArrayCompare(this.text, this.bp, fieldName)) {
         this.matchStat = -2;
         return null;
      } else {
         Collection<String> list = this.newCollectionByType(type);
         int startPos = this.bp;
         char startChar = this.ch;
         int arrayIndex = this.bp + fieldName.length;
         char ch = this.charAt(arrayIndex++);
         if (ch != '[') {
            if (!this.text.startsWith("ull", arrayIndex)) {
               this.matchStat = -1;
               return null;
            }

            arrayIndex += 3;
            ch = this.charAt(arrayIndex++);
            list = null;
         } else {
            ch = this.charAt(arrayIndex++);

            label136:
            while(true) {
               if (ch == '"') {
                  int endIndex = this.indexOf('"', arrayIndex);
                  if (endIndex == -1) {
                     throw new JSONException("unclosed str");
                  }

                  String stringVal = this.subString(arrayIndex, endIndex - arrayIndex);
                  if (stringVal.indexOf(92) != -1) {
                     while(true) {
                        int slashCount = 0;

                        for(int i = endIndex - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                           ++slashCount;
                        }

                        if (slashCount % 2 == 0) {
                           slashCount = endIndex - arrayIndex;
                           char[] chars = this.sub_chars(arrayIndex, slashCount);
                           stringVal = readString(chars, slashCount);
                           break;
                        }

                        endIndex = this.indexOf('"', endIndex + 1);
                     }
                  }

                  arrayIndex = endIndex + 1;
                  ch = this.charAt(arrayIndex++);
                  list.add(stringVal);
               } else {
                  if (ch != 'n' || !this.text.startsWith("ull", arrayIndex)) {
                     if (ch != ']' || list.size() != 0) {
                        this.matchStat = -1;
                        return null;
                     }

                     ch = this.charAt(arrayIndex++);
                     break;
                  }

                  arrayIndex += 3;
                  ch = this.charAt(arrayIndex++);
                  list.add(null);
               }

               if (ch != ',') {
                  if (ch != ']') {
                     this.matchStat = -1;
                     return null;
                  }

                  ch = this.charAt(arrayIndex++);

                  while(true) {
                     if (!isWhitespace(ch)) {
                        break label136;
                     }

                     ch = this.charAt(arrayIndex++);
                  }
               }

               ch = this.charAt(arrayIndex++);
            }
         }

         this.bp = arrayIndex;
         if (ch == ',') {
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return list;
         } else if (ch != '}') {
            this.ch = startChar;
            this.bp = startPos;
            this.matchStat = -1;
            return null;
         } else {
            ch = this.charAt(this.bp);

            while(true) {
               if (ch == ',') {
                  this.token = 16;
                  this.ch = this.charAt(++this.bp);
                  break;
               }

               if (ch == ']') {
                  this.token = 15;
                  this.ch = this.charAt(++this.bp);
                  break;
               }

               if (ch == '}') {
                  this.token = 13;
                  this.ch = this.charAt(++this.bp);
                  break;
               }

               if (ch == 26) {
                  this.token = 20;
                  this.ch = ch;
                  break;
               }

               boolean space;
               for(space = false; isWhitespace(ch); space = true) {
                  ch = this.charAt(arrayIndex++);
                  this.bp = arrayIndex;
               }

               if (!space) {
                  this.matchStat = -1;
                  return null;
               }
            }

            this.matchStat = 4;
            return list;
         }
      }
   }

   public long scanFieldLong(char[] fieldName) {
      this.matchStat = 0;
      int startPos = this.bp;
      char startChar = this.ch;
      if (!charArrayCompare(this.text, this.bp, fieldName)) {
         this.matchStat = -2;
         return 0L;
      } else {
         int index = this.bp + fieldName.length;
         char ch = this.charAt(index++);
         boolean quote = ch == '"';
         if (quote) {
            ch = this.charAt(index++);
         }

         boolean negative = false;
         if (ch == '-') {
            ch = this.charAt(index++);
            negative = true;
         }

         if (ch >= '0' && ch <= '9') {
            long value = (long)(ch - 48);

            while(true) {
               ch = this.charAt(index++);
               if (ch < '0' || ch > '9') {
                  if (ch == '.') {
                     this.matchStat = -1;
                     return 0L;
                  } else {
                     if (quote) {
                        if (ch != '"') {
                           this.matchStat = -1;
                           return 0L;
                        }

                        ch = this.charAt(index++);
                     }

                     if (ch == ',' || ch == '}') {
                        this.bp = index - 1;
                     }

                     boolean valid = value >= 0L || value == Long.MIN_VALUE && negative;
                     if (!valid) {
                        this.bp = startPos;
                        this.ch = startChar;
                        this.matchStat = -1;
                        return 0L;
                     } else {
                        while(ch != ',') {
                           if (ch == '}') {
                              ch = this.charAt(++this.bp);

                              while(true) {
                                 if (ch == ',') {
                                    this.token = 16;
                                    this.ch = this.charAt(++this.bp);
                                    break;
                                 }

                                 if (ch == ']') {
                                    this.token = 15;
                                    this.ch = this.charAt(++this.bp);
                                    break;
                                 }

                                 if (ch == '}') {
                                    this.token = 13;
                                    this.ch = this.charAt(++this.bp);
                                    break;
                                 }

                                 if (ch == 26) {
                                    this.token = 20;
                                    break;
                                 }

                                 if (!isWhitespace(ch)) {
                                    this.bp = startPos;
                                    this.ch = startChar;
                                    this.matchStat = -1;
                                    return 0L;
                                 }

                                 ch = this.charAt(++this.bp);
                              }

                              this.matchStat = 4;
                              return negative ? -value : value;
                           }

                           if (!isWhitespace(ch)) {
                              this.matchStat = -1;
                              return 0L;
                           }

                           this.bp = index;
                           ch = this.charAt(index++);
                        }

                        this.ch = this.charAt(++this.bp);
                        this.matchStat = 3;
                        this.token = 16;
                        return negative ? -value : value;
                     }
                  }
               }

               value = value * 10L + (long)(ch - 48);
            }
         } else {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return 0L;
         }
      }
   }

   public boolean scanFieldBoolean(char[] fieldName) {
      this.matchStat = 0;
      if (!charArrayCompare(this.text, this.bp, fieldName)) {
         this.matchStat = -2;
         return false;
      } else {
         int startPos = this.bp;
         int index = this.bp + fieldName.length;
         char ch = this.charAt(index++);
         boolean quote = ch == '"';
         if (quote) {
            ch = this.charAt(index++);
         }

         boolean value;
         if (ch == 't') {
            if (this.charAt(index++) != 'r') {
               this.matchStat = -1;
               return false;
            }

            if (this.charAt(index++) != 'u') {
               this.matchStat = -1;
               return false;
            }

            if (this.charAt(index++) != 'e') {
               this.matchStat = -1;
               return false;
            }

            if (quote && this.charAt(index++) != '"') {
               this.matchStat = -1;
               return false;
            }

            this.bp = index;
            ch = this.charAt(this.bp);
            value = true;
         } else if (ch == 'f') {
            if (this.charAt(index++) != 'a') {
               this.matchStat = -1;
               return false;
            }

            if (this.charAt(index++) != 'l') {
               this.matchStat = -1;
               return false;
            }

            if (this.charAt(index++) != 's') {
               this.matchStat = -1;
               return false;
            }

            if (this.charAt(index++) != 'e') {
               this.matchStat = -1;
               return false;
            }

            if (quote && this.charAt(index++) != '"') {
               this.matchStat = -1;
               return false;
            }

            this.bp = index;
            ch = this.charAt(this.bp);
            value = false;
         } else if (ch == '1') {
            if (quote && this.charAt(index++) != '"') {
               this.matchStat = -1;
               return false;
            }

            this.bp = index;
            ch = this.charAt(this.bp);
            value = true;
         } else {
            if (ch != '0') {
               this.matchStat = -1;
               return false;
            }

            if (quote && this.charAt(index++) != '"') {
               this.matchStat = -1;
               return false;
            }

            this.bp = index;
            ch = this.charAt(this.bp);
            value = false;
         }

         while(true) {
            if (ch == ',') {
               this.ch = this.charAt(++this.bp);
               this.matchStat = 3;
               this.token = 16;
               break;
            }

            if (ch == '}') {
               label118: {
                  for(char var17 = this.charAt(++this.bp); var17 != ','; var17 = this.charAt(++this.bp)) {
                     if (var17 == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        break label118;
                     }

                     if (var17 == '}') {
                        this.token = 13;
                        this.ch = this.charAt(++this.bp);
                        break label118;
                     }

                     if (var17 == 26) {
                        this.token = 20;
                        break label118;
                     }

                     if (!isWhitespace(var17)) {
                        this.matchStat = -1;
                        return false;
                     }
                  }

                  this.token = 16;
                  this.ch = this.charAt(++this.bp);
               }

               this.matchStat = 4;
               break;
            }

            if (!isWhitespace(ch)) {
               this.bp = startPos;
               ch = this.charAt(this.bp);
               this.matchStat = -1;
               return false;
            }

            ch = this.charAt(++this.bp);
         }

         return value;
      }
   }

   public final int scanInt(char expectNext) {
      this.matchStat = 0;
      int mark = this.bp;
      int offset = this.bp;

      char chLocal;
      for(chLocal = this.charAt(offset++); isWhitespace(chLocal); chLocal = this.charAt(offset++)) {
      }

      boolean quote = chLocal == '"';
      if (quote) {
         chLocal = this.charAt(offset++);
      }

      boolean negative = chLocal == '-';
      if (negative) {
         chLocal = this.charAt(offset++);
      }

      if (chLocal >= '0' && chLocal <= '9') {
         int value = chLocal - 48;

         while(true) {
            chLocal = this.charAt(offset++);
            if (chLocal < '0' || chLocal > '9') {
               if (chLocal == '.') {
                  this.matchStat = -1;
                  return 0;
               } else {
                  if (quote) {
                     if (chLocal != '"') {
                        this.matchStat = -1;
                        return 0;
                     }

                     chLocal = this.charAt(offset++);
                  }

                  if (value < 0) {
                     this.matchStat = -1;
                     return 0;
                  } else {
                     while(chLocal != expectNext) {
                        if (!isWhitespace(chLocal)) {
                           this.matchStat = -1;
                           return negative ? -value : value;
                        }

                        chLocal = this.charAt(offset++);
                     }

                     this.bp = offset;
                     this.ch = this.charAt(this.bp);
                     this.matchStat = 3;
                     this.token = 16;
                     return negative ? -value : value;
                  }
               }
            }

            int value_10 = value * 10;
            if (value_10 < value) {
               throw new JSONException("parseInt error : " + this.subString(mark, offset - 1));
            }

            value = value_10 + (chLocal - 48);
         }
      } else if (chLocal == 'n' && this.charAt(offset++) == 'u' && this.charAt(offset++) == 'l' && this.charAt(offset++) == 'l') {
         this.matchStat = 5;
         int value = 0;
         chLocal = this.charAt(offset++);
         if (quote && chLocal == '"') {
            chLocal = this.charAt(offset++);
         }

         while(chLocal != ',') {
            if (chLocal == ']') {
               this.bp = offset;
               this.ch = this.charAt(this.bp);
               this.matchStat = 5;
               this.token = 15;
               return value;
            }

            if (!isWhitespace(chLocal)) {
               this.matchStat = -1;
               return 0;
            }

            chLocal = this.charAt(offset++);
         }

         this.bp = offset;
         this.ch = this.charAt(this.bp);
         this.matchStat = 5;
         this.token = 16;
         return value;
      } else {
         this.matchStat = -1;
         return 0;
      }
   }

   public double scanDouble(char seperator) {
      this.matchStat = 0;
      int offset = this.bp;
      char chLocal = this.charAt(offset++);
      boolean quote = chLocal == '"';
      if (quote) {
         chLocal = this.charAt(offset++);
      }

      boolean negative = chLocal == '-';
      if (negative) {
         chLocal = this.charAt(offset++);
      }

      if (chLocal >= '0' && chLocal <= '9') {
         long intVal = (long)(chLocal - 48);

         while(true) {
            chLocal = this.charAt(offset++);
            if (chLocal < '0' || chLocal > '9') {
               long power = 1L;
               boolean small = chLocal == '.';
               if (small) {
                  chLocal = this.charAt(offset++);
                  if (chLocal < '0' || chLocal > '9') {
                     this.matchStat = -1;
                     return (double)0.0F;
                  }

                  intVal = intVal * 10L + (long)(chLocal - 48);
                  power = 10L;

                  while(true) {
                     chLocal = this.charAt(offset++);
                     if (chLocal < '0' || chLocal > '9') {
                        break;
                     }

                     intVal = intVal * 10L + (long)(chLocal - 48);
                     power *= 10L;
                  }
               }

               boolean exp = chLocal == 'e' || chLocal == 'E';
               if (exp) {
                  chLocal = this.charAt(offset++);
                  if (chLocal == '+' || chLocal == '-') {
                     chLocal = this.charAt(offset++);
                  }

                  while(chLocal >= '0' && chLocal <= '9') {
                     chLocal = this.charAt(offset++);
                  }
               }

               int start;
               int count;
               if (quote) {
                  if (chLocal != '"') {
                     this.matchStat = -1;
                     return (double)0.0F;
                  }

                  chLocal = this.charAt(offset++);
                  start = this.bp + 1;
                  count = offset - start - 2;
               } else {
                  start = this.bp;
                  count = offset - start - 1;
               }

               double value;
               if (!exp && count < 18) {
                  value = (double)intVal / (double)power;
                  if (negative) {
                     value = -value;
                  }
               } else {
                  String text = this.subString(start, count);
                  value = Double.parseDouble(text);
               }

               if (chLocal == seperator) {
                  this.bp = offset;
                  this.ch = this.charAt(this.bp);
                  this.matchStat = 3;
                  this.token = 16;
                  return value;
               }

               this.matchStat = -1;
               return value;
            }

            intVal = intVal * 10L + (long)(chLocal - 48);
         }
      } else if (chLocal == 'n' && this.charAt(offset++) == 'u' && this.charAt(offset++) == 'l' && this.charAt(offset++) == 'l') {
         this.matchStat = 5;
         double value = (double)0.0F;
         chLocal = this.charAt(offset++);
         if (quote && chLocal == '"') {
            chLocal = this.charAt(offset++);
         }

         while(chLocal != ',') {
            if (chLocal == ']') {
               this.bp = offset;
               this.ch = this.charAt(this.bp);
               this.matchStat = 5;
               this.token = 15;
               return value;
            }

            if (!isWhitespace(chLocal)) {
               this.matchStat = -1;
               return (double)0.0F;
            }

            chLocal = this.charAt(offset++);
         }

         this.bp = offset;
         this.ch = this.charAt(this.bp);
         this.matchStat = 5;
         this.token = 16;
         return value;
      } else {
         this.matchStat = -1;
         return (double)0.0F;
      }
   }

   public long scanLong(char seperator) {
      this.matchStat = 0;
      int offset = this.bp;
      char chLocal = this.charAt(offset++);
      boolean quote = chLocal == '"';
      if (quote) {
         chLocal = this.charAt(offset++);
      }

      boolean negative = chLocal == '-';
      if (negative) {
         chLocal = this.charAt(offset++);
      }

      if (chLocal >= '0' && chLocal <= '9') {
         long value = (long)(chLocal - 48);

         while(true) {
            chLocal = this.charAt(offset++);
            if (chLocal < '0' || chLocal > '9') {
               if (chLocal == '.') {
                  this.matchStat = -1;
                  return 0L;
               } else {
                  if (quote) {
                     if (chLocal != '"') {
                        this.matchStat = -1;
                        return 0L;
                     }

                     chLocal = this.charAt(offset++);
                  }

                  boolean valid = value >= 0L || value == Long.MIN_VALUE && negative;
                  if (!valid) {
                     this.matchStat = -1;
                     return 0L;
                  } else {
                     while(chLocal != seperator) {
                        if (!isWhitespace(chLocal)) {
                           this.matchStat = -1;
                           return value;
                        }

                        chLocal = this.charAt(offset++);
                     }

                     this.bp = offset;
                     this.ch = this.charAt(this.bp);
                     this.matchStat = 3;
                     this.token = 16;
                     return negative ? -value : value;
                  }
               }
            }

            value = value * 10L + (long)(chLocal - 48);
         }
      } else if (chLocal == 'n' && this.charAt(offset++) == 'u' && this.charAt(offset++) == 'l' && this.charAt(offset++) == 'l') {
         this.matchStat = 5;
         long value = 0L;
         chLocal = this.charAt(offset++);
         if (quote && chLocal == '"') {
            chLocal = this.charAt(offset++);
         }

         while(chLocal != ',') {
            if (chLocal == ']') {
               this.bp = offset;
               this.ch = this.charAt(this.bp);
               this.matchStat = 5;
               this.token = 15;
               return value;
            }

            if (!isWhitespace(chLocal)) {
               this.matchStat = -1;
               return 0L;
            }

            chLocal = this.charAt(offset++);
         }

         this.bp = offset;
         this.ch = this.charAt(this.bp);
         this.matchStat = 5;
         this.token = 16;
         return value;
      } else {
         this.matchStat = -1;
         return 0L;
      }
   }

   public Date scanDate(char seperator) {
      this.matchStat = 0;
      int startPos = this.bp;
      char startChar = this.ch;
      int index = this.bp;
      char ch = this.charAt(index++);
      Date dateVal;
      if (ch == '"') {
         int endIndex = this.indexOf('"', index);
         if (endIndex == -1) {
            throw new JSONException("unclosed str");
         }

         int rest = endIndex - index;
         this.bp = index;
         if (!this.scanISO8601DateIfMatch(false, rest)) {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return null;
         }

         dateVal = this.calendar.getTime();
         ch = this.charAt(endIndex + 1);

         for(this.bp = startPos; ch != ',' && ch != ']'; ch = this.charAt(endIndex + 1)) {
            if (!isWhitespace(ch)) {
               this.bp = startPos;
               this.ch = startChar;
               this.matchStat = -1;
               return null;
            }

            ++endIndex;
         }

         this.bp = endIndex + 1;
         this.ch = ch;
      } else if (ch != '-' && (ch < '0' || ch > '9')) {
         if (ch != 'n' || this.charAt(index++) != 'u' || this.charAt(index++) != 'l' || this.charAt(index++) != 'l') {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return null;
         }

         dateVal = null;
         ch = this.charAt(index);
         this.bp = index;
      } else {
         long millis = 0L;
         boolean negative = false;
         if (ch == '-') {
            ch = this.charAt(index++);
            negative = true;
         }

         if (ch >= '0' && ch <= '9') {
            millis = (long)(ch - 48);

            while(true) {
               ch = this.charAt(index++);
               if (ch < '0' || ch > '9') {
                  if (ch == ',' || ch == ']') {
                     this.bp = index - 1;
                  }
                  break;
               }

               millis = millis * 10L + (long)(ch - 48);
            }
         }

         if (millis < 0L) {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return null;
         }

         if (negative) {
            millis = -millis;
         }

         dateVal = new Date(millis);
      }

      if (ch == ',') {
         this.ch = this.charAt(++this.bp);
         this.matchStat = 3;
         return dateVal;
      } else {
         ch = this.charAt(++this.bp);
         if (ch == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
         } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
         } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
         } else {
            if (ch != 26) {
               this.bp = startPos;
               this.ch = startChar;
               this.matchStat = -1;
               return null;
            }

            this.ch = 26;
            this.token = 20;
         }

         this.matchStat = 4;
         return dateVal;
      }
   }

   protected final void arrayCopy(int srcPos, char[] dest, int destPos, int length) {
      this.text.getChars(srcPos, srcPos + length, dest, destPos);
   }

   public String info() {
      StringBuilder buf = new StringBuilder();
      int line = 1;
      int column = 1;

      for(int i = 0; i < this.bp; ++column) {
         char ch = this.text.charAt(i);
         if (ch == '\n') {
            column = 1;
            ++line;
         }

         ++i;
      }

      buf.append("pos ").append(this.bp).append(", line ").append(line).append(", column ").append(column);
      if (this.text.length() < 65535) {
         buf.append(this.text);
      } else {
         buf.append(this.text.substring(0, 65535));
      }

      return buf.toString();
   }

   public String[] scanFieldStringArray(char[] fieldName, int argTypesCount, SymbolTable typeSymbolTable) {
      int startPos = this.bp;
      char starChar = this.ch;

      while(isWhitespace(this.ch)) {
         this.next();
      }

      int offset;
      char ch;
      if (fieldName != null) {
         this.matchStat = 0;
         if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return null;
         }

         offset = this.bp + fieldName.length;

         for(ch = this.text.charAt(offset++); isWhitespace(ch); ch = this.text.charAt(offset++)) {
         }

         if (ch != ':') {
            this.matchStat = -1;
            return null;
         }

         for(ch = this.text.charAt(offset++); isWhitespace(ch); ch = this.text.charAt(offset++)) {
         }
      } else {
         offset = this.bp + 1;
         ch = this.ch;
      }

      if (ch != '[') {
         if (ch == 'n' && this.text.startsWith("ull", this.bp + 1)) {
            this.bp += 4;
            this.ch = this.text.charAt(this.bp);
            return null;
         } else {
            this.matchStat = -1;
            return null;
         }
      } else {
         this.bp = offset;
         this.ch = this.text.charAt(this.bp);
         String[] types = argTypesCount >= 0 ? new String[argTypesCount] : new String[4];
         int typeIndex = 0;

         while(true) {
            while(!isWhitespace(this.ch)) {
               if (this.ch != '"') {
                  this.bp = startPos;
                  this.ch = starChar;
                  this.matchStat = -1;
                  return null;
               }

               String type = this.scanSymbol(typeSymbolTable, '"');
               if (typeIndex == types.length) {
                  int newCapacity = types.length + (types.length >> 1) + 1;
                  String[] array = new String[newCapacity];
                  System.arraycopy(types, 0, array, 0, types.length);
                  types = array;
               }

               types[typeIndex++] = type;

               while(isWhitespace(this.ch)) {
                  this.next();
               }

               if (this.ch != ',') {
                  if (types.length != typeIndex) {
                     String[] newTypes = new String[typeIndex];
                     System.arraycopy(types, 0, newTypes, 0, typeIndex);
                     types = newTypes;
                  }

                  while(isWhitespace(this.ch)) {
                     this.next();
                  }

                  if (this.ch == ']') {
                     this.next();
                     return types;
                  }

                  this.bp = startPos;
                  this.ch = starChar;
                  this.matchStat = -1;
                  return null;
               }

               this.next();
            }

            this.next();
         }
      }
   }

   public boolean matchField2(char[] fieldName) {
      while(isWhitespace(this.ch)) {
         this.next();
      }

      if (!this.charArrayCompare(fieldName)) {
         this.matchStat = -2;
         return false;
      } else {
         int offset = this.bp + fieldName.length;

         char ch;
         for(ch = this.text.charAt(offset++); isWhitespace(ch); ch = this.text.charAt(offset++)) {
         }

         if (ch == ':') {
            this.bp = offset;
            this.ch = this.charAt(this.bp);
            return true;
         } else {
            this.matchStat = -2;
            return false;
         }
      }
   }

   public final void skipObject() {
      this.skipObject(false);
   }

   public final void skipObject(boolean valid) {
      boolean quote = false;
      int braceCnt = 0;

      int i;
      for(i = this.bp; i < this.text.length(); ++i) {
         char ch = this.text.charAt(i);
         if (ch == '\\') {
            if (i >= this.len - 1) {
               this.ch = ch;
               this.bp = i;
               throw new JSONException("illegal str, " + this.info());
            }

            ++i;
         } else if (ch == '"') {
            quote = !quote;
         } else if (ch == '{') {
            if (!quote) {
               ++braceCnt;
            }
         } else if (ch == '}' && !quote) {
            --braceCnt;
            if (braceCnt == -1) {
               this.bp = i + 1;
               if (this.bp == this.text.length()) {
                  this.ch = 26;
                  this.token = 20;
                  return;
               }

               this.ch = this.text.charAt(this.bp);
               if (this.ch == ',') {
                  this.token = 16;
                  int index = ++this.bp;
                  this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                  return;
               }

               if (this.ch == '}') {
                  this.token = 13;
                  this.next();
                  return;
               }

               if (this.ch == ']') {
                  this.token = 15;
                  this.next();
                  return;
               }

               this.nextToken(16);
               return;
            }
         }
      }

      for(int j = 0; j < this.bp; ++j) {
         if (j < this.text.length() && this.text.charAt(j) == ' ') {
            ++i;
         }
      }

      if (i == this.text.length()) {
         throw new JSONException("illegal str, " + this.info());
      }
   }

   public final void skipArray() {
      this.skipArray(false);
   }

   public final void skipArray(boolean valid) {
      boolean quote = false;
      int bracketCnt = 0;

      int i;
      for(i = this.bp; i < this.text.length(); ++i) {
         char ch = this.text.charAt(i);
         if (ch == '\\') {
            if (i >= this.len - 1) {
               this.ch = ch;
               this.bp = i;
               throw new JSONException("illegal str, " + this.info());
            }

            ++i;
         } else if (ch == '"') {
            quote = !quote;
         } else if (ch == '[') {
            if (!quote) {
               ++bracketCnt;
            }
         } else if (ch == '{' && valid) {
            int index = ++this.bp;
            this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
            this.skipObject(valid);
         } else if (ch == ']' && !quote) {
            --bracketCnt;
            if (bracketCnt == -1) {
               this.bp = i + 1;
               if (this.bp == this.text.length()) {
                  this.ch = 26;
                  this.token = 20;
                  return;
               }

               this.ch = this.text.charAt(this.bp);
               this.nextToken(16);
               return;
            }
         }
      }

      if (i == this.text.length()) {
         throw new JSONException("illegal str, " + this.info());
      }
   }

   public final void skipString() {
      if (this.ch == '"') {
         for(int i = this.bp + 1; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\\') {
               if (i < this.len - 1) {
                  ++i;
               }
            } else if (c == '"') {
               this.ch = this.text.charAt(this.bp = i + 1);
               return;
            }
         }

         throw new JSONException("unclosed str");
      } else {
         throw new UnsupportedOperationException();
      }
   }

   public boolean seekArrayToItem(int index) {
      if (index < 0) {
         throw new IllegalArgumentException("index must > 0, but " + index);
      } else if (this.token == 20) {
         return false;
      } else if (this.token != 14) {
         throw new UnsupportedOperationException();
      } else {
         for(int i = 0; i < index; ++i) {
            this.skipWhitespace();
            if (this.ch != '"' && this.ch != '\'') {
               if (this.ch == '{') {
                  this.next();
                  this.token = 12;
                  this.skipObject(false);
               } else {
                  if (this.ch != '[') {
                     boolean match = false;

                     for(int j = this.bp + 1; j < this.text.length(); ++j) {
                        char c = this.text.charAt(j);
                        if (c == ',') {
                           match = true;
                           this.bp = j + 1;
                           this.ch = this.charAt(this.bp);
                           break;
                        }

                        if (c == ']') {
                           this.bp = j + 1;
                           this.ch = this.charAt(this.bp);
                           this.nextToken();
                           return false;
                        }
                     }

                     if (!match) {
                        throw new JSONException("illegal json.");
                     }
                     continue;
                  }

                  this.next();
                  this.token = 14;
                  this.skipArray(false);
               }

               if (this.token != 16) {
                  if (this.token == 15) {
                     return false;
                  }

                  throw new UnsupportedOperationException();
               }
            } else {
               this.skipString();
               if (this.ch != ',') {
                  if (this.ch == ']') {
                     this.next();
                     this.nextToken(16);
                     return false;
                  }

                  throw new JSONException("illegal json.");
               }

               this.next();
            }
         }

         this.nextToken();
         return true;
      }
   }

   public int seekObjectToField(long fieldNameHash, boolean deepScan) {
      if (this.token == 20) {
         return -1;
      } else if (this.token != 13 && this.token != 15) {
         if (this.token != 12 && this.token != 16) {
            throw new UnsupportedOperationException(JSONToken.name(this.token));
         } else {
            while(this.ch != '}') {
               if (this.ch == 26) {
                  return -1;
               }

               if (this.ch != '"') {
                  this.skipWhitespace();
               }

               if (this.ch != '"') {
                  throw new UnsupportedOperationException();
               }

               long hash = -3750763034362895579L;

               for(int i = this.bp + 1; i < this.text.length(); ++i) {
                  char c = this.text.charAt(i);
                  if (c == '\\') {
                     ++i;
                     if (i == this.text.length()) {
                        throw new JSONException("unclosed str, " + this.info());
                     }

                     c = this.text.charAt(i);
                  }

                  if (c == '"') {
                     this.bp = i + 1;
                     this.ch = this.bp >= this.text.length() ? 26 : this.text.charAt(this.bp);
                     break;
                  }

                  hash ^= (long)c;
                  hash *= 1099511628211L;
               }

               if (hash == fieldNameHash) {
                  if (this.ch != ':') {
                     this.skipWhitespace();
                  }

                  if (this.ch == ':') {
                     int index = ++this.bp;
                     this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                     if (this.ch == ',') {
                        index = ++this.bp;
                        this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                        this.token = 16;
                     } else if (this.ch == ']') {
                        index = ++this.bp;
                        this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                        this.token = 15;
                     } else if (this.ch == '}') {
                        index = ++this.bp;
                        this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                        this.token = 13;
                     } else if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                     } else {
                        this.nextToken(2);
                     }
                  }

                  return 3;
               }

               if (this.ch != ':') {
                  this.skipWhitespace();
               }

               if (this.ch != ':') {
                  throw new JSONException("illegal json, " + this.info());
               }

               int index = ++this.bp;
               this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
               if (this.ch != '"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
                  this.skipWhitespace();
               }

               if (this.ch != '-' && this.ch != '+' && (this.ch < '0' || this.ch > '9')) {
                  if (this.ch == '"') {
                     this.skipString();
                     if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                     }

                     if (this.ch == ',') {
                        this.next();
                     }
                  } else if (this.ch == 't') {
                     this.next();
                     if (this.ch == 'r') {
                        this.next();
                        if (this.ch == 'u') {
                           this.next();
                           if (this.ch == 'e') {
                              this.next();
                           }
                        }
                     }

                     if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                     }

                     if (this.ch == ',') {
                        this.next();
                     }
                  } else if (this.ch == 'n') {
                     this.next();
                     if (this.ch == 'u') {
                        this.next();
                        if (this.ch == 'l') {
                           this.next();
                           if (this.ch == 'l') {
                              this.next();
                           }
                        }
                     }

                     if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                     }

                     if (this.ch == ',') {
                        this.next();
                     }
                  } else if (this.ch == 'f') {
                     this.next();
                     if (this.ch == 'a') {
                        this.next();
                        if (this.ch == 'l') {
                           this.next();
                           if (this.ch == 's') {
                              this.next();
                              if (this.ch == 'e') {
                                 this.next();
                              }
                           }
                        }
                     }

                     if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                     }

                     if (this.ch == ',') {
                        this.next();
                     }
                  } else if (this.ch == '{') {
                     index = ++this.bp;
                     this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                     if (deepScan) {
                        this.token = 12;
                        return 1;
                     }

                     this.skipObject(false);
                     if (this.token == 13) {
                        return -1;
                     }
                  } else {
                     if (this.ch != '[') {
                        throw new UnsupportedOperationException();
                     }

                     this.next();
                     if (deepScan) {
                        this.token = 14;
                        return 2;
                     }

                     this.skipArray(false);
                     if (this.token == 13) {
                        return -1;
                     }
                  }
               } else {
                  this.next();

                  while(this.ch >= '0' && this.ch <= '9') {
                     this.next();
                  }

                  if (this.ch == '.') {
                     this.next();

                     while(this.ch >= '0' && this.ch <= '9') {
                        this.next();
                     }
                  }

                  if (this.ch == 'E' || this.ch == 'e') {
                     this.next();
                     if (this.ch == '-' || this.ch == '+') {
                        this.next();
                     }

                     while(this.ch >= '0' && this.ch <= '9') {
                        this.next();
                     }
                  }

                  if (this.ch != ',') {
                     this.skipWhitespace();
                  }

                  if (this.ch == ',') {
                     this.next();
                  }
               }
            }

            this.next();
            this.nextToken();
            return -1;
         }
      } else {
         this.nextToken();
         return -1;
      }
   }

   public int seekObjectToField(long[] fieldNameHash) {
      if (this.token != 12 && this.token != 16) {
         throw new UnsupportedOperationException();
      } else {
         while(this.ch != '}') {
            if (this.ch == 26) {
               this.matchStat = -1;
               return -1;
            }

            if (this.ch != '"') {
               this.skipWhitespace();
            }

            if (this.ch != '"') {
               throw new UnsupportedOperationException();
            }

            long hash = -3750763034362895579L;

            for(int i = this.bp + 1; i < this.text.length(); ++i) {
               char c = this.text.charAt(i);
               if (c == '\\') {
                  ++i;
                  if (i == this.text.length()) {
                     throw new JSONException("unclosed str, " + this.info());
                  }

                  c = this.text.charAt(i);
               }

               if (c == '"') {
                  this.bp = i + 1;
                  this.ch = this.bp >= this.text.length() ? 26 : this.text.charAt(this.bp);
                  break;
               }

               hash ^= (long)c;
               hash *= 1099511628211L;
            }

            int matchIndex = -1;

            for(int i = 0; i < fieldNameHash.length; ++i) {
               if (hash == fieldNameHash[i]) {
                  matchIndex = i;
                  break;
               }
            }

            if (matchIndex != -1) {
               if (this.ch != ':') {
                  this.skipWhitespace();
               }

               if (this.ch == ':') {
                  int index = ++this.bp;
                  this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                  if (this.ch == ',') {
                     index = ++this.bp;
                     this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                     this.token = 16;
                  } else if (this.ch == ']') {
                     index = ++this.bp;
                     this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                     this.token = 15;
                  } else if (this.ch == '}') {
                     index = ++this.bp;
                     this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                     this.token = 13;
                  } else if (this.ch >= '0' && this.ch <= '9') {
                     this.sp = 0;
                     this.pos = this.bp;
                     this.scanNumber();
                  } else {
                     this.nextToken(2);
                  }
               }

               this.matchStat = 3;
               return matchIndex;
            }

            if (this.ch != ':') {
               this.skipWhitespace();
            }

            if (this.ch != ':') {
               throw new JSONException("illegal json, " + this.info());
            }

            int index = ++this.bp;
            this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
            if (this.ch != '"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
               this.skipWhitespace();
            }

            if (this.ch != '-' && this.ch != '+' && (this.ch < '0' || this.ch > '9')) {
               if (this.ch == '"') {
                  this.skipString();
                  if (this.ch != ',' && this.ch != '}') {
                     this.skipWhitespace();
                  }

                  if (this.ch == ',') {
                     this.next();
                  }
               } else if (this.ch == '{') {
                  index = ++this.bp;
                  this.ch = index >= this.text.length() ? 26 : this.text.charAt(index);
                  this.skipObject(false);
               } else {
                  if (this.ch != '[') {
                     throw new UnsupportedOperationException();
                  }

                  this.next();
                  this.skipArray(false);
               }
            } else {
               this.next();

               while(this.ch >= '0' && this.ch <= '9') {
                  this.next();
               }

               if (this.ch == '.') {
                  this.next();

                  while(this.ch >= '0' && this.ch <= '9') {
                     this.next();
                  }
               }

               if (this.ch == 'E' || this.ch == 'e') {
                  this.next();
                  if (this.ch == '-' || this.ch == '+') {
                     this.next();
                  }

                  while(this.ch >= '0' && this.ch <= '9') {
                     this.next();
                  }
               }

               if (this.ch != ',') {
                  this.skipWhitespace();
               }

               if (this.ch == ',') {
                  this.next();
               }
            }
         }

         this.next();
         this.nextToken();
         this.matchStat = -1;
         return -1;
      }
   }

   public String scanTypeName(SymbolTable symbolTable) {
      if (this.text.startsWith("\"@type\":\"", this.bp)) {
         int p = this.text.indexOf(34, this.bp + 9);
         if (p != -1) {
            this.bp += 9;
            int h = 0;

            for(int i = this.bp; i < p; ++i) {
               h = 31 * h + this.text.charAt(i);
            }

            String typeName = this.addSymbol(this.bp, p - this.bp, h, symbolTable);
            char separator = this.text.charAt(p + 1);
            if (separator != ',' && separator != ']') {
               return null;
            }

            this.bp = p + 2;
            this.ch = this.text.charAt(this.bp);
            return typeName;
         }
      }

      return null;
   }
}
