package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;

public class SymbolTable {
   private final String[] symbols;
   private final int indexMask;

   public SymbolTable(int tableSize) {
      this.indexMask = tableSize - 1;
      this.symbols = new String[tableSize];
      this.addSymbol((String)"$ref", 0, 4, "$ref".hashCode());
      this.addSymbol((String)JSON.DEFAULT_TYPE_KEY, 0, JSON.DEFAULT_TYPE_KEY.length(), JSON.DEFAULT_TYPE_KEY.hashCode());
   }

   public String addSymbol(char[] buffer, int offset, int len) {
      int hash = hash(buffer, offset, len);
      return this.addSymbol(buffer, offset, len, hash);
   }

   public String addSymbol(char[] buffer, int offset, int len, int hash) {
      int bucket = hash & this.indexMask;
      String symbol = this.symbols[bucket];
      if (symbol == null) {
         symbol = (new String(buffer, offset, len)).intern();
         this.symbols[bucket] = symbol;
         return symbol;
      } else {
         boolean eq = true;
         if (hash == symbol.hashCode() && len == symbol.length()) {
            for(int i = 0; i < len; ++i) {
               if (buffer[offset + i] != symbol.charAt(i)) {
                  eq = false;
                  break;
               }
            }
         } else {
            eq = false;
         }

         return eq ? symbol : new String(buffer, offset, len);
      }
   }

   public String addSymbol(String buffer, int offset, int len, int hash) {
      return this.addSymbol(buffer, offset, len, hash, false);
   }

   public String addSymbol(String buffer, int offset, int len, int hash, boolean replace) {
      int bucket = hash & this.indexMask;
      String symbol = this.symbols[bucket];
      if (symbol != null) {
         if (hash == symbol.hashCode() && len == symbol.length() && buffer.startsWith(symbol, offset)) {
            return symbol;
         } else {
            String str = subString(buffer, offset, len);
            if (replace) {
               this.symbols[bucket] = str;
            }

            return str;
         }
      } else {
         symbol = len == buffer.length() ? buffer : subString(buffer, offset, len);
         symbol = symbol.intern();
         this.symbols[bucket] = symbol;
         return symbol;
      }
   }

   private static String subString(String src, int offset, int len) {
      char[] chars = new char[len];
      src.getChars(offset, offset + len, chars, 0);
      return new String(chars);
   }

   public static int hash(char[] buffer, int offset, int len) {
      int h = 0;
      int off = offset;

      for(int i = 0; i < len; ++i) {
         h = 31 * h + buffer[off++];
      }

      return h;
   }
}
