package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EnumDeserializer implements ObjectDeserializer {
   protected final Class<?> enumClass;
   protected final Enum[] enums;
   protected final Enum[] ordinalEnums;
   protected long[] enumNameHashCodes;

   public EnumDeserializer(Class<?> enumClass) {
      this.enumClass = enumClass;
      this.ordinalEnums = (Enum[])enumClass.getEnumConstants();
      Map<Long, Enum> enumMap = new HashMap();

      for(int i = 0; i < this.ordinalEnums.length; ++i) {
         Enum e = this.ordinalEnums[i];
         String name = e.name();
         JSONField jsonField = null;

         try {
            Field field = enumClass.getField(name);
            jsonField = (JSONField)TypeUtils.getAnnotation(field, JSONField.class);
            if (jsonField != null) {
               String jsonFieldName = jsonField.name();
               if (jsonFieldName != null && jsonFieldName.length() > 0) {
                  name = jsonFieldName;
               }
            }
         } catch (Exception var19) {
         }

         long hash = -3750763034362895579L;
         long hash_lower = -3750763034362895579L;

         for(int j = 0; j < name.length(); ++j) {
            char ch = name.charAt(j);
            hash ^= (long)ch;
            hash_lower ^= (long)(ch >= 'A' && ch <= 'Z' ? ch + 32 : ch);
            hash *= 1099511628211L;
            hash_lower *= 1099511628211L;
         }

         enumMap.put(hash, e);
         if (hash != hash_lower) {
            enumMap.put(hash_lower, e);
         }

         if (jsonField != null) {
            for(String alterName : jsonField.alternateNames()) {
               long alterNameHash = -3750763034362895579L;

               for(int j = 0; j < alterName.length(); ++j) {
                  char ch = alterName.charAt(j);
                  alterNameHash ^= (long)ch;
                  alterNameHash *= 1099511628211L;
               }

               if (alterNameHash != hash && alterNameHash != hash_lower) {
                  enumMap.put(alterNameHash, e);
               }
            }
         }
      }

      this.enumNameHashCodes = new long[enumMap.size()];
      int i = 0;

      for(Long h : enumMap.keySet()) {
         this.enumNameHashCodes[i++] = h;
      }

      Arrays.sort(this.enumNameHashCodes);
      this.enums = new Enum[this.enumNameHashCodes.length];

      for(int i2 = 0; i2 < this.enumNameHashCodes.length; ++i2) {
         long hash = this.enumNameHashCodes[i2];
         Enum e = (Enum)enumMap.get(hash);
         this.enums[i2] = e;
      }

   }

   public Enum getEnumByHashCode(long hashCode) {
      if (this.enums == null) {
         return null;
      } else {
         int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
         return enumIndex < 0 ? null : this.enums[enumIndex];
      }
   }

   public Enum<?> valueOf(int ordinal) {
      return this.ordinalEnums[ordinal];
   }

   public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
      try {
         JSONLexer lexer = parser.lexer;
         int token = lexer.token();
         if (token == 2) {
            int intValue = lexer.intValue();
            lexer.nextToken(16);
            if (intValue >= 0 && intValue < this.ordinalEnums.length) {
               return (T)this.ordinalEnums[intValue];
            } else {
               throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + intValue);
            }
         } else if (token != 4) {
            if (token == 8) {
               Object value = null;
               lexer.nextToken(16);
               return null;
            } else {
               Object value = parser.parse();
               throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
            }
         } else {
            String name = lexer.stringVal();
            lexer.nextToken(16);
            if (name.length() == 0) {
               return null;
            } else {
               long hash = -3750763034362895579L;
               long hash_lower = -3750763034362895579L;

               for(int j = 0; j < name.length(); ++j) {
                  char ch = name.charAt(j);
                  hash ^= (long)ch;
                  hash_lower ^= (long)(ch >= 'A' && ch <= 'Z' ? ch + 32 : ch);
                  hash *= 1099511628211L;
                  hash_lower *= 1099511628211L;
               }

               Enum e = this.getEnumByHashCode(hash);
               if (e == null && hash_lower != hash) {
                  e = this.getEnumByHashCode(hash_lower);
               }

               if (e == null && lexer.isEnabled(Feature.ErrorOnEnumNotMatch)) {
                  throw new JSONException("not match enum value, " + this.enumClass.getName() + " : " + name);
               } else {
                  return (T)e;
               }
            }
         }
      } catch (JSONException e) {
         throw e;
      } catch (Exception e) {
         throw new JSONException(e.getMessage(), e);
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
